/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.bracket;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotation.BracketValidator;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import java.util.Optional;
import mekanism.api.MekanismAPI;
import mekanism.common.integration.crafttweaker.CrTConstants;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.mekanism.api.BracketValidators")
public class CrTBracketValidators {
    @ZenCodeType.Method
    @BracketValidator(value="chemical")
    public static boolean validateChemicalStack(String tokens) {
        return CrTBracketValidators.validate("chemical", tokens, MekanismAPI.CHEMICAL_REGISTRY_NAME);
    }

    @ZenCodeType.Method
    @BracketValidator(value="robit_skin")
    public static boolean validateRobitSkin(String tokens) {
        return CrTBracketValidators.validate("robit_skin", tokens, MekanismAPI.ROBIT_SKIN_REGISTRY_NAME);
    }

    @ZenCodeType.Method
    @BracketValidator(value="module_data")
    public static boolean validateModuleData(String tokens) {
        return CrTBracketValidators.validate("module_data", tokens, MekanismAPI.MODULE_REGISTRY_NAME);
    }

    private static boolean validate(String bracket, String tokens, ResourceKey<? extends Registry<?>> registryKey) {
        ResourceLocation registryName = ResourceLocation.tryParse((String)tokens);
        if (registryName == null) {
            CrTConstants.CRT_LOGGER.error("Could not get BEP <{}:{}>. Syntax is <{}:modid:{}_name>", (Object)bracket, (Object)tokens, (Object)bracket, (Object)bracket);
            return false;
        }
        Optional registry = CraftTweakerAPI.getAccessibleElementsProvider().registryAccess().registry(registryKey);
        if (registry.isEmpty() || ((Registry)registry.get()).containsKey(registryName)) {
            return true;
        }
        String typeName = bracket.replace("_", " ");
        CrTConstants.CRT_LOGGER.error("Could not get {} for <{}:{}>, {} does not appear to exist!", (Object)typeName, (Object)bracket, (Object)tokens, (Object)typeName);
        return false;
    }
}

