/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.holder.chemical;

import java.util.function.BiPredicate;
import java.util.function.Supplier;
import mekanism.api.AutomationType;
import mekanism.api.RelativeSide;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHolder;
import mekanism.common.capabilities.holder.chemical.ConfigChemicalTankHolder;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.lib.radiation.RadiationManager;
import mekanism.common.tile.interfaces.ISideConfiguration;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.NotNull;

public class ChemicalTankHelper {
    private final IChemicalTankHolder slotHolder;
    private boolean built;

    private ChemicalTankHelper(IChemicalTankHolder slotHolder) {
        this.slotHolder = slotHolder;
    }

    public static BiPredicate<ChemicalStack, @NotNull AutomationType> radioactiveInputTankPredicate(Supplier<IChemicalTank> outputTank) {
        return (type, automationType) -> automationType != AutomationType.EXTERNAL || ((IChemicalTank)outputTank.get()).isEmpty() && type.isRadioactive() && RadiationManager.isGlobalRadiationEnabled();
    }

    public static ChemicalTankHelper forSide(Supplier<Direction> facingSupplier) {
        return new ChemicalTankHelper(new ChemicalTankHolder(facingSupplier));
    }

    public static ChemicalTankHelper forSideWithConfig(ISideConfiguration sideConfiguration) {
        return new ChemicalTankHelper(new ConfigChemicalTankHolder(sideConfiguration));
    }

    public IChemicalTank addTank(IChemicalTank tank) {
        if (this.built) {
            throw new IllegalStateException("Builder has already built.");
        }
        IChemicalTankHolder iChemicalTankHolder = this.slotHolder;
        if (iChemicalTankHolder instanceof ChemicalTankHolder) {
            ChemicalTankHolder tankHolder = (ChemicalTankHolder)iChemicalTankHolder;
            tankHolder.addTank(tank, new RelativeSide[0]);
        } else {
            iChemicalTankHolder = this.slotHolder;
            if (iChemicalTankHolder instanceof ConfigChemicalTankHolder) {
                ConfigChemicalTankHolder tankHolder = (ConfigChemicalTankHolder)iChemicalTankHolder;
                tankHolder.addTank(tank);
            } else {
                throw new IllegalArgumentException("Holder does not know how to add tanks");
            }
        }
        return tank;
    }

    public IChemicalTank addTank(IChemicalTank tank, RelativeSide ... sides) {
        if (this.built) {
            throw new IllegalStateException("Builder has already built.");
        }
        IChemicalTankHolder iChemicalTankHolder = this.slotHolder;
        if (!(iChemicalTankHolder instanceof ChemicalTankHolder)) {
            throw new IllegalArgumentException("Holder does not know how to add tanks on specific sides");
        }
        ChemicalTankHolder tankHolder = (ChemicalTankHolder)iChemicalTankHolder;
        tankHolder.addTank(tank, sides);
        return tank;
    }

    public IChemicalTankHolder build() {
        this.built = true;
        return this.slotHolder;
    }
}

