/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.attachments;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntSortedMap;
import it.unimi.dsi.fastutil.objects.Object2IntSortedMaps;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.common.Mekanism;
import mekanism.common.lib.inventory.HashedItem;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;

@NothingNullByDefault
public record OverflowAware(Object2IntSortedMap<HashedItem> overflow) {
    public static final OverflowAware EMPTY = new OverflowAware((Object2IntSortedMap<HashedItem>)Object2IntSortedMaps.emptyMap());
    public static final Codec<OverflowAware> CODEC = ItemCount.CODEC.listOf().promotePartial(error -> Mekanism.logger.error("Failed to load overflown items: {}", error)).xmap(counts -> {
        Object2IntLinkedOpenHashMap overflow = new Object2IntLinkedOpenHashMap(counts.size());
        for (ItemCount itemCount : counts) {
            overflow.mergeInt((Object)itemCount.type(), itemCount.count(), Integer::sum);
        }
        return new OverflowAware((Object2IntSortedMap<HashedItem>)overflow);
    }, overflowAware -> {
        ArrayList<ItemCount> counts = new ArrayList<ItemCount>(overflowAware.overflow().size());
        ObjectIterator iterator = Object2IntMaps.fastIterator(overflowAware.overflow());
        while (iterator.hasNext()) {
            Object2IntMap.Entry entry = (Object2IntMap.Entry)iterator.next();
            counts.add(new ItemCount((HashedItem)entry.getKey(), entry.getIntValue()));
        }
        return counts;
    });
    public static final StreamCodec<RegistryFriendlyByteBuf, OverflowAware> STREAM_CODEC = ByteBufCodecs.map(Object2IntLinkedOpenHashMap::new, HashedItem.STREAM_CODEC, (StreamCodec)ByteBufCodecs.VAR_INT).map(OverflowAware::new, OverflowAware::overflow);

    public OverflowAware(Object2IntSortedMap<HashedItem> overflow) {
        this.overflow = overflow = Object2IntSortedMaps.unmodifiable(overflow);
    }

    private record ItemCount(HashedItem type, int count) {
        public static final Codec<ItemCount> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)HashedItem.CODEC.fieldOf("type").forGetter(ItemCount::type), (App)ExtraCodecs.POSITIVE_INT.fieldOf("count").forGetter(ItemCount::count)).apply((Applicative)instance, ItemCount::new));
    }
}

