/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.gear;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mekanism.api.MekanismAPI;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IHUDElement;
import mekanism.api.gear.IModule;
import mekanism.api.gear.ModuleData;
import mekanism.api.gear.config.ModuleConfig;
import mekanism.api.providers.IModuleDataProvider;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public interface IModuleContainer {
    public Map<ModuleData<?>, ? extends IModule<?>> typedModules();

    public Collection<? extends IModule<?>> modules();

    default public Set<ModuleData<?>> moduleTypes() {
        return this.typedModules().keySet();
    }

    @Deprecated(forRemoval=true, since="10.7.11")
    default public <MODULE extends ICustomModule<MODULE>> IModuleContainer replaceModuleConfig(HolderLookup.Provider provider, ItemStack stack, IModuleDataProvider<MODULE> type, ModuleConfig<?> config) {
        return this.replaceModuleConfig(provider, stack, this.asHolder(type), config);
    }

    public IModuleContainer replaceModuleConfig(HolderLookup.Provider var1, ItemStack var2, Holder<ModuleData<?>> var3, ModuleConfig<?> var4);

    public ItemEnchantments moduleBasedEnchantments();

    default public int getModuleEnchantmentLevel(Holder<Enchantment> enchantment) {
        return this.moduleBasedEnchantments().getLevel(enchantment);
    }

    default public int installedCount() {
        return this.typedModules().size();
    }

    @Deprecated(forRemoval=true, since="10.7.11")
    default public int installedCount(IModuleDataProvider<?> typeProvider) {
        IModule<?> module = this.get(typeProvider);
        return module == null ? 0 : module.getInstalledCount();
    }

    default public int installedCount(Holder<ModuleData<?>> type) {
        IModule<?> module = this.get(type);
        return module == null ? 0 : module.getInstalledCount();
    }

    @Deprecated(forRemoval=true, since="10.7.11")
    @Nullable
    default public <MODULE extends ICustomModule<MODULE>> IModule<MODULE> get(IModuleDataProvider<MODULE> typeProvider) {
        return this.getUnchecked(this.asHolder(typeProvider));
    }

    @Nullable
    default public <MODULE extends ICustomModule<MODULE>> IModule<MODULE> get(DeferredHolder<ModuleData<?>, ModuleData<MODULE>> type) {
        return this.getUnchecked((Holder<ModuleData<?>>)type);
    }

    @Nullable
    public <MODULE extends ICustomModule<MODULE>> IModule<MODULE> getUnchecked(Holder<ModuleData<?>> var1);

    @Nullable
    public IModule<?> get(Holder<ModuleData<?>> var1);

    @Deprecated(forRemoval=true, since="10.7.11")
    @Nullable
    default public <MODULE extends ICustomModule<MODULE>> IModule<MODULE> getIfEnabled(IModuleDataProvider<MODULE> typeProvider) {
        IModule<MODULE> module = this.get(typeProvider);
        return module != null && module.isEnabled() ? module : null;
    }

    @Nullable
    default public <MODULE extends ICustomModule<MODULE>> IModule<MODULE> getIfEnabled(DeferredHolder<ModuleData<?>, ModuleData<MODULE>> type) {
        IModule<MODULE> module = this.get(type);
        return module != null && module.isEnabled() ? module : null;
    }

    @Nullable
    default public IModule<?> getIfEnabled(Holder<ModuleData<?>> type) {
        IModule<?> module = this.get(type);
        return module != null && module.isEnabled() ? module : null;
    }

    @Deprecated(forRemoval=true, since="10.7.11")
    default public boolean has(IModuleDataProvider<?> typeProvider) {
        return this.typedModules().containsKey(typeProvider.getModuleData());
    }

    default public boolean has(Holder<ModuleData<?>> type) {
        return this.typedModules().containsKey(type.value());
    }

    @Deprecated(forRemoval=true, since="10.7.11")
    default public boolean hasEnabled(IModuleDataProvider<?> typeProvider) {
        return this.getIfEnabled(typeProvider) != null;
    }

    default public boolean hasEnabled(Holder<ModuleData<?>> typeProvider) {
        return this.getIfEnabled(typeProvider) != null;
    }

    public List<IHUDElement> getHUDElements(Player var1, ItemStack var2);

    public List<Component> getHUDStrings(Player var1, ItemStack var2);

    @Deprecated(forRemoval=true, since="10.7.11")
    private Holder<ModuleData<?>> asHolder(IModuleDataProvider<?> moduleDataProvider) {
        return MekanismAPI.MODULE_REGISTRY.wrapAsHolder(moduleDataProvider.getModuleData());
    }
}

