/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.datagen.recipe.builder;

import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.datagen.recipe.MekanismRecipeBuilder;
import mekanism.api.recipes.ElectrolysisRecipe;
import mekanism.api.recipes.basic.BasicElectrolysisRecipe;
import mekanism.api.recipes.ingredients.FluidStackIngredient;

@NothingNullByDefault
public class ElectrolysisRecipeBuilder
extends MekanismRecipeBuilder<ElectrolysisRecipeBuilder> {
    private final FluidStackIngredient input;
    private final ChemicalStack leftChemicalOutput;
    private final ChemicalStack rightChemicalOutput;
    private long energyMultiplier = 1L;

    protected ElectrolysisRecipeBuilder(FluidStackIngredient input, ChemicalStack leftChemicalOutput, ChemicalStack rightChemicalOutput) {
        this.input = input;
        this.leftChemicalOutput = leftChemicalOutput;
        this.rightChemicalOutput = rightChemicalOutput;
    }

    public static ElectrolysisRecipeBuilder separating(FluidStackIngredient input, ChemicalStack leftChemicalOutput, ChemicalStack rightChemicalOutput) {
        if (leftChemicalOutput.isEmpty() || rightChemicalOutput.isEmpty()) {
            throw new IllegalArgumentException("This separating recipe requires non empty chemical outputs.");
        }
        return new ElectrolysisRecipeBuilder(input, leftChemicalOutput, rightChemicalOutput);
    }

    public ElectrolysisRecipeBuilder energyMultiplier(long multiplier) {
        if (multiplier < 1L) {
            throw new IllegalArgumentException("Energy multiplier must be greater than or equal to one");
        }
        this.energyMultiplier = multiplier;
        return this;
    }

    protected ElectrolysisRecipe asRecipe() {
        return new BasicElectrolysisRecipe(this.input, this.energyMultiplier, this.leftChemicalOutput, this.rightChemicalOutput);
    }
}

