/*
 * Decompiled with CFR 0.152.
 */
package fuzs.magnumtorch.config;

import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.util.StringRepresentable;

public enum ShapeType implements StringRepresentable
{
    ELLIPSOID{

        @Override
        public boolean isPositionInside(int posX, int posY, int posZ, int width, int height) {
            return (double)((float)(posX * posX + posZ * posZ) / (float)(width * width) + (float)(posY * posY) / (float)(height * height)) <= 1.0;
        }
    }
    ,
    CYLINDER{

        @Override
        public boolean isPositionInside(int posX, int posY, int posZ, int width, int height) {
            return posX * posX + posZ * posZ <= width * width && posY <= height;
        }
    }
    ,
    CUBOID{

        @Override
        public boolean isPositionInside(int posX, int posY, int posZ, int width, int height) {
            return posX <= width && posZ <= width && posY <= height;
        }
    };

    public static final StringRepresentable.StringRepresentableCodec<ShapeType> CODEC;

    public boolean isPositionInside(BlockPos centerPosition, BlockPos sectionPosition, int width, int height) {
        return this.isPositionInside(centerPosition.getX(), centerPosition.getY(), centerPosition.getZ(), sectionPosition.getX(), sectionPosition.getY(), sectionPosition.getZ(), width, height);
    }

    public boolean isPositionInside(int centerX, int centerY, int centerZ, int sectionX, int sectionY, int sectionZ, int width, int height) {
        return this.isPositionInside(Math.abs(centerX - sectionX), Math.abs(centerY - sectionY), Math.abs(centerZ - sectionZ), width, height);
    }

    public abstract boolean isPositionInside(int var1, int var2, int var3, int var4, int var5);

    public String getSerializedName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    static {
        CODEC = StringRepresentable.fromEnum(ShapeType::values);
    }
}

