/*
 * Decompiled with CFR 0.152.
 */
package com.rinko1231.letmefeedyou;

import com.rinko1231.letmefeedyou.Config.FeedPlayerConfig;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class FeedEvents {
    private static final long FEED_COOLDOWN = 1000L;
    private static final HashMap<UUID, Long> playerFeedCooldowns = new HashMap();

    @SubscribeEvent
    public void onPlayerRightClickEntity(PlayerInteractEvent.EntityInteract event) {
        Entity entity = event.getTarget();
        if (entity instanceof Player) {
            Player targetPlayer = (Player)entity;
            if (!event.getLevel().isClientSide) {
                long lastFedTime;
                Player feeder = event.getEntity();
                ItemStack foodItem = feeder.getMainHandItem();
                if (foodItem.getFoodProperties((LivingEntity)feeder) == null) {
                    return;
                }
                String itemId = BuiltInRegistries.ITEM.getKey((Object)foodItem.getItem()).toString();
                if (((List)FeedPlayerConfig.foodBlacklist.get()).contains(itemId)) {
                    return;
                }
                if (targetPlayer.getFoodData().getFoodLevel() >= (Integer)FeedPlayerConfig.canBeFedBelowHungerOf.get()) {
                    return;
                }
                UUID targetUUID = targetPlayer.getUUID();
                long currentTime = System.currentTimeMillis();
                playerFeedCooldowns.entrySet().removeIf(entry -> currentTime - (Long)entry.getValue() > 1000L);
                if (playerFeedCooldowns.containsKey(targetUUID) && currentTime - (lastFedTime = playerFeedCooldowns.get(targetUUID).longValue()) < 1000L) {
                    return;
                }
                Component foodName = foodItem.has(DataComponents.CUSTOM_NAME) ? foodItem.getHoverName() : foodItem.getDisplayName();
                String feederName = feeder.getDisplayName().getString();
                if (!feeder.isCreative()) {
                    ItemStack consumed = foodItem.finishUsingItem(targetPlayer.level(), (LivingEntity)targetPlayer);
                    targetPlayer.displayClientMessage((Component)Component.translatable((String)"info.letmefeedyou.success", (Object[])new Object[]{feederName, foodName}), true);
                    if (!feeder.getAbilities().instabuild) {
                        feeder.setItemInHand(InteractionHand.MAIN_HAND, consumed);
                    }
                    playerFeedCooldowns.put(targetUUID, currentTime);
                } else {
                    targetPlayer.eat(targetPlayer.level(), foodItem.copy());
                    targetPlayer.displayClientMessage((Component)Component.translatable((String)"info.letmefeedyou.success", (Object[])new Object[]{feederName, foodName}), true);
                    playerFeedCooldowns.put(targetUUID, currentTime);
                }
            }
        }
    }
}

