/*
 * Decompiled with CFR 0.152.
 */
package jeresources.profiling;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jeresources.config.Settings;
import jeresources.json.ProfilingAdapter;
import jeresources.profiling.ChunkGetter;
import jeresources.profiling.DummyWorld;
import jeresources.profiling.ProfiledDimensionData;
import jeresources.profiling.ProfilingBlacklist;
import jeresources.profiling.ProfilingExecutor;
import jeresources.profiling.ProfilingTimer;
import jeresources.util.DimensionHelper;
import jeresources.util.LogHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.commands.CommandSource;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class Profiler
implements Runnable {
    private final ConcurrentMap<ResourceKey<Level>, ProfiledDimensionData> allDimensionData;
    private final ProfilingTimer timer;
    private final Entity sender;
    private final ProfilingBlacklist blacklist;
    private final int chunkCount;
    private final boolean allDimensions;
    private ProfilingExecutor currentExecutor;
    private static Profiler currentProfiler;

    private Profiler(Entity sender, int chunkCount, boolean allDimensions) {
        this.sender = sender;
        this.allDimensionData = new ConcurrentHashMap<ResourceKey<Level>, ProfiledDimensionData>();
        this.chunkCount = chunkCount;
        this.timer = new ProfilingTimer((CommandSource)sender, chunkCount);
        this.allDimensions = allDimensions;
        this.blacklist = new ProfilingBlacklist();
    }

    @Override
    public void run() {
        if (!this.allDimensions) {
            ResourceKey worldKey = this.sender.level().dimension();
            this.profileWorld((ResourceKey<Level>)worldKey);
        } else {
            for (ResourceKey worldKey : this.sender.getServer().levelKeys()) {
                this.profileWorld((ResourceKey<Level>)worldKey);
            }
        }
        this.writeData();
        this.timer.complete();
    }

    private void profileWorld(ResourceKey<Level> dimensionKey) {
        ProfilingExecutor executor;
        IntegratedServer server = Minecraft.getInstance().getSingleplayerServer();
        ServerLevel world = server.getLevel(dimensionKey);
        if (world == null) {
            String msg = "Unable to profile dimension " + DimensionHelper.getDimensionName(dimensionKey) + ".  There is no world for it.";
            LogHelper.error(msg, new Object[0]);
            this.sender.sendSystemMessage((Component)Component.literal((String)msg));
            return;
        }
        ServerLevel serverLevel = world;
        String msg = "Inspecting dimension " + DimensionHelper.getDimensionName(dimensionKey) + ". ";
        this.sender.sendSystemMessage((Component)Component.literal((String)msg));
        LogHelper.info(msg, new Object[0]);
        if (Settings.excludedDimensions.contains(dimensionKey.location().toString())) {
            msg = "Skipped dimension " + DimensionHelper.getDimensionName(dimensionKey) + " during profiling";
            LogHelper.info(msg, new Object[0]);
            this.sender.sendSystemMessage((Component)Component.literal((String)msg));
            return;
        }
        this.currentExecutor = executor = new ProfilingExecutor(this);
        this.allDimensionData.put(dimensionKey, new ProfiledDimensionData());
        DummyWorld dummyWorld = new DummyWorld(serverLevel);
        ChunkGetter chunkGetter = new ChunkGetter(this.chunkCount, dummyWorld, executor);
        serverLevel.getServer().addTickable((Runnable)chunkGetter);
        executor.awaitTermination();
        this.currentExecutor = null;
    }

    public ProfilingTimer getTimer() {
        return this.timer;
    }

    public ProfilingBlacklist getBlacklist() {
        return this.blacklist;
    }

    public ConcurrentMap<ResourceKey<Level>, ProfiledDimensionData> getAllDimensionData() {
        return this.allDimensionData;
    }

    private void writeData() {
        HashMap<ResourceKey<Level>, ProfilingAdapter.DimensionData> allData = new HashMap<ResourceKey<Level>, ProfilingAdapter.DimensionData>();
        for (ResourceKey worldRegistryKey : this.allDimensionData.keySet()) {
            ProfiledDimensionData profiledData = (ProfiledDimensionData)this.allDimensionData.get(worldRegistryKey);
            ProfilingAdapter.DimensionData data = new ProfilingAdapter.DimensionData();
            data.dropsMap = profiledData.dropsMap;
            data.silkTouchMap = profiledData.silkTouchMap;
            for (Map.Entry entry : profiledData.distributionMap.entrySet()) {
                Float[] array = new Float[256];
                for (int i = 0; i < 256; ++i) {
                    array[i] = Float.valueOf((float)((Integer[])entry.getValue())[i].intValue() * 1.0f / (float)this.timer.getBlocksPerLayer((ResourceKey<Level>)worldRegistryKey));
                }
                data.distribution.put((String)entry.getKey(), array);
            }
            allData.put((ResourceKey<Level>)worldRegistryKey, data);
        }
        ProfilingAdapter.write(allData);
    }

    public static boolean init(Entity sender, int chunks, boolean allWorlds) {
        sender.sendSystemMessage((Component)Component.literal((String)"Command not yet re-implemented, profiling will be re-added in the future"));
        return true;
    }

    public static boolean stop(Entity sender) {
        sender.sendSystemMessage((Component)Component.literal((String)"Command not yet re-implemented, profiling will be re-added in the future"));
        return true;
    }
}

