/*
 * Decompiled with CFR 0.152.
 */
package twistedgate.immersiveposts.enums;

import blusunrize.immersiveengineering.common.register.IEBlocks;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import twistedgate.immersiveposts.api.posts.IPostMaterial;
import twistedgate.immersiveposts.common.ExternalModContent;
import twistedgate.immersiveposts.common.IPOContent;
import twistedgate.immersiveposts.util.ResourceUtils;

public enum EnumPostMaterial implements IPostMaterial
{
    WOOD("wood", PostBlockProperties.WOOD, () -> ExternalModContent.IE_TREATED_FENCE.value()),
    ALUMINIUM("aluminium", PostBlockProperties.METAL, () -> ExternalModContent.IE_ALUMINIUM_FENCE.value()),
    STEEL("steel", PostBlockProperties.METAL, () -> ExternalModContent.IE_STEEL_FENCE.value()),
    NETHERBRICK("nether", PostBlockProperties.STONE, Blocks.NETHER_BRICK_FENCE),
    IRON("iron", PostBlockProperties.METAL, () -> IPOContent.Blocks.Fences.IRON.get()),
    GOLD("gold", PostBlockProperties.METAL, () -> IPOContent.Blocks.Fences.GOLD.get()),
    COPPER("copper", PostBlockProperties.METAL, () -> IPOContent.Blocks.Fences.COPPER.get()),
    LEAD("lead", PostBlockProperties.METAL, () -> IPOContent.Blocks.Fences.LEAD.get()),
    SILVER("silver", PostBlockProperties.METAL, () -> IPOContent.Blocks.Fences.SILVER.get()),
    NICKEL("nickel", PostBlockProperties.METAL, () -> IPOContent.Blocks.Fences.NICKEL.get()),
    CONSTANTAN("constantan", PostBlockProperties.METAL, () -> IPOContent.Blocks.Fences.CONSTANTAN.get()),
    ELECTRUM("electrum", PostBlockProperties.METAL, () -> IPOContent.Blocks.Fences.ELECTRUM.get()),
    URANIUM("uranium", PostBlockProperties.metal().lightLevel(s -> 8), () -> IPOContent.Blocks.Fences.URANIUM.get()),
    CONCRETE("concrete", PostBlockProperties.STONE, () -> ((IEBlocks.BlockEntry)IEBlocks.TO_SLAB.get(IEBlocks.StoneDecoration.CONCRETE.getId())).get()),
    CONCRETE_LEADED("leadedconcrete", PostBlockProperties.STONE, () -> ((IEBlocks.BlockEntry)IEBlocks.TO_SLAB.get(IEBlocks.StoneDecoration.CONCRETE_LEADED.getId())).get());

    private boolean isFence;
    private final String name;
    private Block sourceBlock;
    private Supplier<Block> sourceBlockSupplier;
    private final BlockBehaviour.Properties properties;
    private ResourceLocation texture;

    private EnumPostMaterial(String name, BlockBehaviour.Properties properties, Supplier<Block> sourceBlockSupplier) {
        this(name, properties, null, sourceBlockSupplier);
    }

    private EnumPostMaterial(String name, BlockBehaviour.Properties properties, Block sourceBlock) {
        this.name = name;
        this.properties = properties;
        this.sourceBlock = sourceBlock;
        this.isFence = sourceBlock instanceof FenceBlock;
    }

    private EnumPostMaterial(String name, BlockBehaviour.Properties properties, ResourceLocation texture, Supplier<Block> sourceBlockSupplier) {
        this.name = name;
        this.properties = properties;
        this.texture = texture;
        this.sourceBlockSupplier = sourceBlockSupplier;
    }

    @Override
    public ItemStack getItemStack() {
        Block block = this.getSourceBlock();
        return block == null ? ItemStack.EMPTY : new ItemStack((ItemLike)block);
    }

    @Override
    public ResourceLocation getTexture() {
        if (this.texture == null) {
            return ResourceUtils.ipo("block/posts/post_" + this.getName());
        }
        return this.texture;
    }

    @Override
    public Block getSourceBlock() {
        if (this.sourceBlock == null) {
            this.sourceBlock = this.sourceBlockSupplier.get();
            this.isFence = this.sourceBlock != null && this.sourceBlock instanceof FenceBlock;
        }
        return this.sourceBlock;
    }

    @Override
    public boolean isFence() {
        return this.isFence;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getBlockName() {
        return this.name + "post";
    }

    @Override
    public BlockBehaviour.Properties getBlockProperties() {
        return this.properties;
    }

    public static class PostBlockProperties {
        public static final BlockBehaviour.Properties WOOD = PostBlockProperties.wood();
        public static final BlockBehaviour.Properties STONE = PostBlockProperties.stone();
        public static final BlockBehaviour.Properties METAL = PostBlockProperties.metal();

        public static BlockBehaviour.Properties wood() {
            return BlockBehaviour.Properties.of().forceSolidOn().mapColor(MapColor.WOOD).sound(SoundType.WOOD).strength(2.0f, 5.0f).noOcclusion().isViewBlocking((s, r, p) -> false);
        }

        public static BlockBehaviour.Properties stone() {
            return BlockBehaviour.Properties.of().forceSolidOn().mapColor(MapColor.STONE).sound(SoundType.STONE).requiresCorrectToolForDrops().strength(1.5f, 6.0f).noOcclusion().isViewBlocking((s, r, p) -> false);
        }

        public static BlockBehaviour.Properties metal() {
            return BlockBehaviour.Properties.of().forceSolidOn().mapColor(MapColor.METAL).sound(SoundType.METAL).requiresCorrectToolForDrops().strength(3.0f, 15.0f).noOcclusion().isViewBlocking((s, r, p) -> false);
        }
    }
}

