/*
 * Decompiled with CFR 0.152.
 */
package twistedgate.immersiveposts.common.tileentity;

import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import twistedgate.immersiveposts.common.IPOTileTypes;
import twistedgate.immersiveposts.common.blocks.PostBaseBlock;
import twistedgate.immersiveposts.common.tileentity.IPOTileEntityBase;

public class PostBaseTileEntity
extends IPOTileEntityBase {
    @Nonnull
    protected ItemStack stack = ItemStack.EMPTY;
    protected final UpdatableBlockState cover = new UpdatableBlockState(this);
    protected Direction facing = Direction.NORTH;

    public PostBaseTileEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType<? extends BlockEntity>)((BlockEntityType)IPOTileTypes.POST_BASE.get()), pWorldPosition, pBlockState);
    }

    @Nonnull
    public ItemStack getStack() {
        return this.stack;
    }

    @Nonnull
    public BlockState getCoverState() {
        return this.cover.get(false);
    }

    public Direction getFacing() {
        return this.facing;
    }

    public void setFacing(Direction facing) {
        if (Direction.Plane.HORIZONTAL.test(facing)) {
            this.facing = facing;
            this.setChanged();
        }
    }

    public boolean setStack(ItemStack stack) {
        ItemStack last = this.stack;
        if (stack == null || stack.isEmpty()) {
            this.stack = ItemStack.EMPTY;
        } else if (stack.getItem() instanceof BlockItem) {
            this.stack = stack;
        }
        boolean changed = !ItemStack.matches((ItemStack)this.stack, (ItemStack)last);
        this.updateLazy(changed);
        if (changed) {
            this.setChanged();
        }
        return changed;
    }

    @Override
    protected CompoundTag writeCustom(CompoundTag compound, @Nonnull HolderLookup.Provider provider) {
        compound.putString("facing", this.facing != null ? this.facing.getName() : Direction.NORTH.getName());
        compound.put("stack", this.stack.saveOptional(provider));
        return compound;
    }

    @Override
    protected void readCustom(CompoundTag compound, @Nonnull HolderLookup.Provider provider) {
        this.facing = Direction.byName((String)compound.getString("facing"));
        ItemStack last = this.stack;
        this.stack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)compound.getCompound("stack"));
        boolean changed = !ItemStack.matches((ItemStack)this.stack, (ItemStack)last);
        this.updateLazy(changed);
        if (changed && this.getLevel() != null) {
            this.getLevel().sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public boolean interact(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand) {
        ItemStack held = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (held == ItemStack.EMPTY) {
            if (player.isShiftKeyDown() && !this.getStack().isEmpty()) {
                if (!world.isClientSide) {
                    this.setFacing(Direction.NORTH);
                    Block.popResource((Level)world, (BlockPos)pos, (ItemStack)this.getStack());
                    this.setStack(ItemStack.EMPTY);
                    world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)PostBaseBlock.HIDDEN, (Comparable)Boolean.valueOf(false)));
                }
                return true;
            }
        } else if (held.getItem() instanceof BlockItem && this.isUsableCover(Block.byItem((Item)held.getItem()), (BlockGetter)world, pos) && this.getStack().isEmpty()) {
            if (!world.isClientSide) {
                this.setFacing(player.getDirection().getOpposite());
                ItemStack copy = held.copy();
                copy.setCount(1);
                this.setStack(copy);
                if (!player.isCreative()) {
                    held.shrink(1);
                    if (held.isEmpty()) {
                        player.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
                    }
                }
                world.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)PostBaseBlock.HIDDEN, (Comparable)Boolean.valueOf(true))).setValue((Property)PostBaseBlock.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
            }
            return true;
        }
        return false;
    }

    private boolean isUsableCover(@Nonnull Block block, @Nonnull BlockGetter reader, @Nonnull BlockPos pos) {
        BlockState state = block.defaultBlockState();
        return block != Blocks.AIR && state.isRedstoneConductor(reader, pos) && state.isSolidRender(reader, pos);
    }

    protected void updateLazy(boolean changed) {
        this.cover.get(changed);
    }

    public static class UpdatableBlockState {
        static final Supplier<BlockState> AIR = () -> ((Block)Blocks.AIR).defaultBlockState();
        private Supplier<BlockState> value;
        private final PostBaseTileEntity postBase;

        public UpdatableBlockState(PostBaseTileEntity postBase) {
            this.postBase = postBase;
        }

        public BlockState get(boolean changed) {
            if (changed || this.value == null) {
                Item item;
                ItemStack stack = this.postBase.stack;
                if (!stack.isEmpty() && (item = stack.getItem()) instanceof BlockItem) {
                    BlockItem blockItem = (BlockItem)item;
                    this.value = () -> {
                        BlockState state = blockItem.getBlock().defaultBlockState();
                        Optional<DirectionProperty> prop = state.getProperties().stream().filter(p -> p instanceof DirectionProperty && p.getName().equals("facing")).map(p -> (DirectionProperty)p).filter(p -> p.getPossibleValues().stream().allMatch(Direction.Plane.HORIZONTAL)).findAny();
                        if (prop.isPresent()) {
                            state = (BlockState)state.setValue((Property)prop.get(), (Comparable)this.postBase.facing);
                        }
                        return state;
                    };
                } else {
                    this.value = AIR;
                }
            }
            return this.value.get();
        }
    }
}

