/*
 * Decompiled with CFR 0.152.
 */
package twistedgate.immersiveposts.common.tileentity;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class IPOTileEntityBase
extends BlockEntity {
    public IPOTileEntityBase(BlockEntityType<? extends BlockEntity> pType, BlockPos pWorldPosition, BlockState pBlockState) {
        super(pType, pWorldPosition, pBlockState);
    }

    @Nonnull
    public Level getWorldNonnull() {
        return Objects.requireNonNull(super.getLevel());
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this, BlockEntity::getUpdateTag);
    }

    public void handleUpdateTag(@Nonnull CompoundTag tag, @Nonnull HolderLookup.Provider provider) {
        this.loadAdditional(tag, provider);
    }

    @Nonnull
    public CompoundTag getUpdateTag(@Nonnull HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        this.saveAdditional(nbt, provider);
        return nbt;
    }

    public void onDataPacket(@Nonnull Connection net, ClientboundBlockEntityDataPacket pkt, @Nonnull HolderLookup.Provider provider) {
        this.loadAdditional(pkt.getTag(), provider);
    }

    public void saveAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        this.writeCustom(compound, provider);
    }

    public void loadAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        this.readCustom(compound, provider);
    }

    protected abstract CompoundTag writeCustom(@Nonnull CompoundTag var1, @Nonnull HolderLookup.Provider var2);

    protected abstract void readCustom(@Nonnull CompoundTag var1, @Nonnull HolderLookup.Provider var2);
}

