/*
 * Decompiled with CFR 0.152.
 */
package twistedgate.immersiveposts.common.blocks;

import blusunrize.immersiveengineering.api.IPostBlock;
import blusunrize.immersiveengineering.common.util.Utils;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectArrayMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectMap;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Vector3f;
import twistedgate.immersiveposts.api.IPOTags;
import twistedgate.immersiveposts.api.posts.IPostMaterial;
import twistedgate.immersiveposts.common.IPOConfig;
import twistedgate.immersiveposts.common.blocks.GenericPostBlock;
import twistedgate.immersiveposts.common.blocks.HorizontalTrussBlock;
import twistedgate.immersiveposts.enums.EnumFlipState;
import twistedgate.immersiveposts.enums.EnumHTrussType;
import twistedgate.immersiveposts.enums.EnumPostMaterial;
import twistedgate.immersiveposts.enums.EnumPostType;

public class PostBlock
extends GenericPostBlock
implements IPostBlock,
SimpleWaterloggedBlock {
    public static final DustParticleOptions URAN_PARTICLE = new DustParticleOptions(new Vector3f(0.0f, 1.0f, 0.0f), 1.0f);
    public static final VoxelShape POST_SHAPE = Shapes.box((double)0.3125, (double)0.0, (double)0.3125, (double)0.6875, (double)1.0, (double)0.6875);
    public static final VoxelShape LPARM_NORTH_BOUNDS = Shapes.box((double)0.3125, (double)0.25, (double)0.0, (double)0.6875, (double)0.75, (double)0.3125);
    public static final VoxelShape LPARM_SOUTH_BOUNDS = Shapes.box((double)0.3125, (double)0.25, (double)0.6875, (double)0.6875, (double)0.75, (double)1.0);
    public static final VoxelShape LPARM_EAST_BOUNDS = Shapes.box((double)0.6875, (double)0.25, (double)0.3125, (double)1.0, (double)0.75, (double)0.6875);
    public static final VoxelShape LPARM_WEST_BOUNDS = Shapes.box((double)0.0, (double)0.25, (double)0.3125, (double)0.3125, (double)0.75, (double)0.6875);
    public static final BooleanProperty LPARM_NORTH = BooleanProperty.create((String)"parm_north");
    public static final BooleanProperty LPARM_EAST = BooleanProperty.create((String)"parm_east");
    public static final BooleanProperty LPARM_SOUTH = BooleanProperty.create((String)"parm_south");
    public static final BooleanProperty LPARM_WEST = BooleanProperty.create((String)"parm_west");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final DirectionProperty FACING = DirectionProperty.create((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    public static final EnumProperty<EnumPostType> TYPE = EnumProperty.create((String)"type", EnumPostType.class);
    public static final EnumProperty<EnumFlipState> FLIPSTATE = EnumProperty.create((String)"flipstate", EnumFlipState.class);
    private static final VoxelShape X_BOUNDS = Shapes.box((double)0.0, (double)0.34375, (double)0.3125, (double)1.0, (double)1.0, (double)0.6875);
    private static final VoxelShape Z_BOUNDS = Shapes.box((double)0.3125, (double)0.34375, (double)0.0, (double)0.6875, (double)1.0, (double)1.0);
    private static final Byte2ObjectMap<VoxelShape> armMap = new Byte2ObjectArrayMap();
    private static final Byte2ObjectMap<VoxelShape> defaultMap = new Byte2ObjectArrayMap();

    public PostBlock(IPostMaterial material) {
        super(material);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(FLIPSTATE, (Comparable)((Object)EnumFlipState.UP))).setValue(TYPE, (Comparable)((Object)EnumPostType.POST_TOP))).setValue((Property)LPARM_NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)LPARM_EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)LPARM_SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)LPARM_WEST, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED, FACING, FLIPSTATE, TYPE, LPARM_NORTH, LPARM_EAST, LPARM_SOUTH, LPARM_WEST});
    }

    public int getLightBlock(@Nullable BlockState state, @Nullable BlockGetter worldIn, @Nullable BlockPos pos) {
        return 0;
    }

    public float getShadeBrightness(@Nullable BlockState state, @Nullable BlockGetter worldIn, @Nullable BlockPos pos) {
        return 1.0f;
    }

    public boolean propagatesSkylightDown(@Nonnull BlockState state, @Nullable BlockGetter reader, @Nullable BlockPos pos) {
        return (Boolean)state.getValue((Property)WATERLOGGED) == false;
    }

    @Nonnull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : Fluids.EMPTY.defaultFluidState();
    }

    @Nullable
    public BlockState getStateForPlacement(@Nonnull BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        FluidState fs = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fs.getType() == Fluids.WATER));
    }

    @Nonnull
    public BlockState updateShape(BlockState state, @Nullable Direction facing, @Nullable BlockState facingState, @Nonnull LevelAccessor world, @Nonnull BlockPos pos, @Nonnull BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        if (((EnumPostType)((Object)state.getValue(TYPE))).id() > 1) {
            return state;
        }
        boolean b0 = PostBlock.canConnect((BlockGetter)world, pos, Direction.NORTH);
        boolean b1 = PostBlock.canConnect((BlockGetter)world, pos, Direction.EAST);
        boolean b2 = PostBlock.canConnect((BlockGetter)world, pos, Direction.SOUTH);
        boolean b3 = PostBlock.canConnect((BlockGetter)world, pos, Direction.WEST);
        return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)LPARM_NORTH, (Comparable)Boolean.valueOf(b0))).setValue((Property)LPARM_EAST, (Comparable)Boolean.valueOf(b1))).setValue((Property)LPARM_SOUTH, (Comparable)Boolean.valueOf(b2))).setValue((Property)LPARM_WEST, (Comparable)Boolean.valueOf(b3));
    }

    public boolean isLadder(@Nullable BlockState state, @Nullable LevelReader world, @Nullable BlockPos pos, @Nullable LivingEntity entity) {
        return true;
    }

    public boolean isFlammable(@Nullable BlockState state, @Nullable BlockGetter world, @Nullable BlockPos pos, @Nullable Direction face) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(@Nonnull BlockState stateIn, @Nonnull Level worldIn, @Nonnull BlockPos pos, @Nonnull RandomSource rand) {
        if (this.getPostMaterial() == EnumPostMaterial.URANIUM && stateIn.getValue(TYPE) != EnumPostType.ARM && rand.nextFloat() < 0.125f) {
            double x = (double)pos.getX() + 0.375 + 0.25 * rand.nextDouble();
            double y = (double)pos.getY() + rand.nextDouble();
            double z = (double)pos.getZ() + 0.375 + 0.25 * rand.nextDouble();
            worldIn.addParticle((ParticleOptions)URAN_PARTICLE, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean skipRendering(@Nullable BlockState state, @Nullable BlockState adjacentBlockState, @Nullable Direction side) {
        return false;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader world, BlockPos pos, Player player) {
        return this.getPostMaterial().getItemStack();
    }

    public boolean canConnectTransformer(BlockGetter world, BlockPos pos) {
        return ((EnumPostType)((Object)world.getBlockState(pos).getValue(TYPE))).id() < 2;
    }

    @Override
    public InteractionResult use(BlockState state, Level worldIn, BlockPos pos, Player playerIn, InteractionHand handIn, BlockHitResult hit) {
        block43: {
            Direction facing;
            block45: {
                ItemStack held;
                block44: {
                    BlockItem blockItem;
                    if (worldIn.isClientSide) break block43;
                    held = playerIn.getMainHandItem();
                    Item item = held.getItem();
                    if (item instanceof BlockItem && (item = (blockItem = (BlockItem)item).getBlock()) instanceof LanternBlock) {
                        LanternBlock lanternBlock = (LanternBlock)item;
                        if (!playerIn.isCrouching() && state.getValue(TYPE) == EnumPostType.ARM) {
                            return switch (hit.getDirection()) {
                                case Direction.DOWN -> {
                                    BlockPos below = pos.below();
                                    if (worldIn.getBlockState(below).isAir()) {
                                        BlockState bState = lanternBlock.defaultBlockState();
                                        boolean placed = worldIn.setBlockAndUpdate(below, (BlockState)bState.setValue((Property)LanternBlock.HANGING, (Comparable)Boolean.valueOf(true)));
                                        if (placed && !playerIn.isCreative()) {
                                            held.shrink(1);
                                        }
                                        yield InteractionResult.SUCCESS;
                                    }
                                    yield InteractionResult.FAIL;
                                }
                                default -> InteractionResult.FAIL;
                            };
                        }
                    }
                    if (!IPostMaterial.isValidItem(held)) break block44;
                    if (!ItemStack.isSameItem((ItemStack)held, (ItemStack)this.getPostMaterial().getItemStack())) {
                        playerIn.displayClientMessage((Component)Component.translatable((String)"immersiveposts.expectedlocal", (Object[])new Object[]{this.getPostMaterial().getItemStack().getHoverName()}), true);
                        return InteractionResult.SUCCESS;
                    }
                    for (int y = 0; y <= worldIn.getHeight(Heightmap.Types.WORLD_SURFACE, pos.getX(), pos.getZ()) - pos.getY(); ++y) {
                        BlockPos nPos = pos.offset(0, y, 0);
                        BlockState nState = worldIn.getBlockState(nPos);
                        if (nState.getBlock() instanceof PostBlock) {
                            EnumPostType type = (EnumPostType)((Object)nState.getValue(TYPE));
                            if (type != EnumPostType.POST && type != EnumPostType.POST_TOP && nState.getValue(FLIPSTATE) == EnumFlipState.DOWN) {
                                return InteractionResult.SUCCESS;
                            }
                            nState = worldIn.getBlockState(nPos.relative(Direction.UP));
                            if (nState.getBlock() instanceof PostBlock && (type = (EnumPostType)((Object)nState.getValue(TYPE))) != EnumPostType.POST && type != EnumPostType.POST_TOP) {
                                return InteractionResult.SUCCESS;
                            }
                        }
                        if (worldIn.isEmptyBlock(nPos) || worldIn.getBlockState(nPos).getBlock() == Blocks.WATER) {
                            BlockState fb = (BlockState)IPostMaterial.getPostState(held).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(worldIn.getBlockState(nPos).getBlock() == Blocks.WATER));
                            if (fb != null && !playerIn.blockPosition().equals((Object)nPos) && worldIn.setBlockAndUpdate(nPos, fb) && !playerIn.isCreative()) {
                                held.shrink(1);
                            }
                            return InteractionResult.SUCCESS;
                        }
                        if (worldIn.getBlockState(nPos).getBlock() instanceof PostBlock) continue;
                        return InteractionResult.SUCCESS;
                    }
                    break block43;
                }
                if (!Utils.isHammer((ItemStack)held)) break block43;
                if (!playerIn.isShiftKeyDown()) break block45;
                switch ((EnumPostType)((Object)state.getValue(TYPE))) {
                    case POST: 
                    case POST_TOP: {
                        BlockState nState;
                        BlockPos nPos;
                        int size;
                        facing = hit.getDirection();
                        if (!Direction.Plane.HORIZONTAL.test(facing)) break;
                        BlockPos p = pos.relative(facing);
                        BlockState hstate = worldIn.getBlockState(p);
                        if (hstate.getBlock() instanceof HorizontalTrussBlock) {
                            this.replaceSelf(hstate, worldIn, p);
                            return InteractionResult.SUCCESS;
                        }
                        boolean success = false;
                        for (size = 0; size <= (Integer)IPOConfig.MAIN.maxTrussLength.get(); ++size) {
                            nPos = pos.relative(facing, size + 1);
                            nState = worldIn.getBlockState(nPos);
                            if (nState.isAir()) continue;
                            if (nState.getBlock() instanceof HorizontalTrussBlock) {
                                return InteractionResult.FAIL;
                            }
                            if (nState.getBlock() instanceof PostBlock && ((EnumPostType)((Object)nState.getValue(TYPE))).id() <= 1) {
                                if (this.getPostMaterial() != ((PostBlock)nState.getBlock()).getPostMaterial()) {
                                    playerIn.displayClientMessage((Component)Component.translatable((String)"immersiveposts.truss_notsametype"), true);
                                    return InteractionResult.FAIL;
                                }
                                success = true;
                                break;
                            }
                            if (nState.getBlock() != Blocks.WATER) break;
                        }
                        if (success && size >= 1) {
                            if (size == 1) {
                                nPos = pos.relative(facing);
                                nState = worldIn.getBlockState(nPos);
                                BlockState hState = (BlockState)((BlockState)IPostMaterial.getTrussState(this.getPostMaterial()).setValue((Property)HorizontalTrussBlock.FACING, (Comparable)facing)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(nState.getBlock() == Blocks.WATER));
                                worldIn.setBlockAndUpdate(nPos, hState.updateShape(null, null, (LevelAccessor)worldIn, nPos, null));
                            } else {
                                for (int i = 0; i < size; ++i) {
                                    BlockPos nPos2 = pos.relative(facing, i + 1);
                                    BlockState nState2 = worldIn.getBlockState(nPos2);
                                    BlockState hState = (BlockState)((BlockState)IPostMaterial.getTrussState(this.getPostMaterial()).setValue((Property)HorizontalTrussBlock.FACING, (Comparable)facing)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(nState2.getBlock() == Blocks.WATER));
                                    hState = i == 0 ? (BlockState)hState.setValue(HorizontalTrussBlock.TYPE, (Comparable)((Object)EnumHTrussType.MULTI_A)) : (i == size - 1 ? (i % 2 == 0 ? (BlockState)hState.setValue(HorizontalTrussBlock.TYPE, (Comparable)((Object)EnumHTrussType.MULTI_D_ODD)) : (BlockState)hState.setValue(HorizontalTrussBlock.TYPE, (Comparable)((Object)EnumHTrussType.MULTI_D_EVEN))) : (i % 2 == 0 ? (BlockState)hState.setValue(HorizontalTrussBlock.TYPE, (Comparable)((Object)EnumHTrussType.MULTI_C)) : (BlockState)hState.setValue(HorizontalTrussBlock.TYPE, (Comparable)((Object)EnumHTrussType.MULTI_B))));
                                    worldIn.setBlockAndUpdate(nPos2, hState.updateShape(null, null, (LevelAccessor)worldIn, nPos2, null));
                                }
                            }
                            return InteractionResult.SUCCESS;
                        }
                        if (size == 0) {
                            playerIn.displayClientMessage((Component)Component.translatable((String)"immersiveposts.truss_minimumdistance"), true);
                            break;
                        }
                        if (!success && size >= 1) {
                            playerIn.displayClientMessage((Component)Component.translatable((String)"immersiveposts.truss_postnotfound"), true);
                            break;
                        } else {
                            break;
                        }
                    }
                }
                break block43;
            }
            switch ((EnumPostType)((Object)state.getValue(TYPE))) {
                case POST: 
                case POST_TOP: {
                    facing = hit.getDirection();
                    BlockState defaultState = (BlockState)this.defaultBlockState().setValue(TYPE, (Comparable)((Object)EnumPostType.ARM));
                    switch (facing) {
                        case NORTH: 
                        case EAST: 
                        case SOUTH: 
                        case WEST: {
                            BlockPos nPos = pos.relative(facing);
                            BlockState nState = worldIn.getBlockState(nPos);
                            if (nState.isAir() || nState.getBlock() == Blocks.WATER) {
                                defaultState = (BlockState)((BlockState)defaultState.setValue((Property)FACING, (Comparable)facing)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(nState.getBlock() == Blocks.WATER));
                                worldIn.setBlockAndUpdate(nPos, defaultState);
                                defaultState.handleNeighborChanged(worldIn, nPos, (Block)this, pos, false);
                                break;
                            }
                            if (PostBlock.getBlockFrom((BlockGetter)worldIn, nPos) != this) break;
                            switch ((EnumPostType)((Object)nState.getValue(TYPE))) {
                                case ARM: 
                                case EMPTY: {
                                    this.replaceSelf(nState, worldIn, nPos);
                                    return InteractionResult.SUCCESS;
                                }
                            }
                        }
                    }
                    return InteractionResult.SUCCESS;
                }
                case ARM: {
                    Direction bfacing = (Direction)state.getValue((Property)FACING);
                    BlockPos offset = pos.relative(bfacing);
                    if (worldIn.isEmptyBlock(offset) || worldIn.getBlockState(offset).getBlock() == Blocks.WATER) {
                        BlockState dArmState = (BlockState)((BlockState)((BlockState)state.setValue(TYPE, (Comparable)((Object)EnumPostType.ARM_DOUBLE))).setValue(FLIPSTATE, (Comparable)((Object)EnumFlipState.UP))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(worldIn.getBlockState(offset).getBlock() == Blocks.WATER));
                        worldIn.setBlockAndUpdate(offset, dArmState);
                        worldIn.setBlockAndUpdate(pos, (BlockState)state.setValue(TYPE, (Comparable)((Object)EnumPostType.EMPTY)));
                    }
                    return InteractionResult.SUCCESS;
                }
                case ARM_DOUBLE: {
                    Direction bFacing = (Direction)state.getValue((Property)FACING);
                    this.replaceSelf(state, worldIn, pos);
                    worldIn.setBlockAndUpdate(pos.relative(bFacing.getOpposite()), (BlockState)state.setValue(TYPE, (Comparable)((Object)EnumPostType.ARM)));
                    return InteractionResult.SUCCESS;
                }
                case EMPTY: {
                    Direction bFacing = (Direction)state.getValue((Property)FACING);
                    worldIn.setBlockAndUpdate(pos, (BlockState)state.setValue(TYPE, (Comparable)((Object)EnumPostType.ARM)));
                    this.replaceSelf(state, worldIn, pos.relative(bFacing));
                    return InteractionResult.SUCCESS;
                }
            }
        }
        if (Utils.isHammer((ItemStack)playerIn.getMainHandItem()) || IPostMaterial.isValidItem(playerIn.getMainHandItem())) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (world.isClientSide) {
            return;
        }
        this.updateState(state, world, pos);
    }

    private void updateState(BlockState stateIn, Level world, BlockPos pos) {
        BlockState state;
        EnumPostType thisType = (EnumPostType)((Object)stateIn.getValue(TYPE));
        if (thisType.id() <= 1 && ((state = world.getBlockState(pos.relative(Direction.DOWN))).getBlock() == Blocks.AIR || state.getBlock() == Blocks.WATER)) {
            Block.dropResources((BlockState)stateIn, (Level)world, (BlockPos)pos);
            this.replaceSelf(stateIn, world, pos);
            return;
        }
        BlockState aboveState = world.getBlockState(pos.relative(Direction.UP));
        Block aboveBlock = aboveState.getBlock();
        switch (thisType) {
            case POST: {
                if (aboveBlock instanceof PostBlock) break;
                world.setBlockAndUpdate(pos, (BlockState)stateIn.setValue(TYPE, (Comparable)((Object)EnumPostType.POST_TOP)));
                break;
            }
            case POST_TOP: {
                if (!(aboveBlock instanceof PostBlock) || aboveState.getValue(TYPE) != EnumPostType.POST_TOP) break;
                world.setBlockAndUpdate(pos, (BlockState)stateIn.setValue(TYPE, (Comparable)((Object)EnumPostType.POST)));
                break;
            }
            case ARM: {
                Direction f = ((Direction)stateIn.getValue((Property)FACING)).getOpposite();
                BlockState state2 = world.getBlockState(pos.relative(f));
                if (state2 != null && !(state2.getBlock() instanceof PostBlock)) {
                    this.replaceSelf(stateIn, world, pos);
                    break;
                }
                world.setBlockAndUpdate(pos, (BlockState)stateIn.setValue(FLIPSTATE, (Comparable)((Object)this.getFlipState((BlockGetter)world, pos))));
                break;
            }
            case ARM_DOUBLE: {
                Direction f = ((Direction)stateIn.getValue((Property)FACING)).getOpposite();
                BlockState state3 = world.getBlockState(pos.relative(f));
                if (state3 == null || state3.getBlock() instanceof PostBlock) break;
                this.replaceSelf(stateIn, world, pos);
                break;
            }
            case EMPTY: {
                BlockState state4 = world.getBlockState(pos.relative(((Direction)stateIn.getValue((Property)FACING)).getOpposite()));
                if (state4 != null && !(state4.getBlock() instanceof PostBlock)) {
                    this.replaceSelf(stateIn, world, pos);
                    return;
                }
                state4 = world.getBlockState(pos.relative((Direction)stateIn.getValue((Property)FACING)));
                if (state4.getBlock() != Blocks.AIR && state4.getBlock() != Blocks.WATER) break;
                this.replaceSelf(stateIn, world, pos);
            }
        }
    }

    private EnumFlipState getFlipState(BlockGetter world, BlockPos pos) {
        boolean down;
        BlockState aboveState = world.getBlockState(pos.relative(Direction.UP));
        BlockState belowState = world.getBlockState(pos.relative(Direction.DOWN));
        Block aboveBlock = aboveState.getBlock();
        Block belowBlock = belowState.getBlock();
        boolean up = PostBlock.canConnect(world, pos, Direction.UP) && (!(aboveBlock instanceof PostBlock) || aboveState.getValue(TYPE) != EnumPostType.ARM);
        boolean bl = down = PostBlock.canConnect(world, pos, Direction.DOWN) && (!(belowBlock instanceof PostBlock) || belowState.getValue(TYPE) != EnumPostType.ARM);
        if (up && down) {
            return EnumFlipState.BOTH;
        }
        if (down) {
            return EnumFlipState.DOWN;
        }
        return EnumFlipState.UP;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return PostBlock.stateBounds(state);
    }

    private static VoxelShape stateBounds(BlockState state) {
        EnumPostType type = (EnumPostType)((Object)state.getValue(TYPE));
        switch (type) {
            case ARM: 
            case ARM_DOUBLE: {
                Direction dir = (Direction)state.getValue((Property)FACING);
                EnumFlipState flipstate = (EnumFlipState)((Object)state.getValue(FLIPSTATE));
                byte bid = 0;
                switch (flipstate) {
                    case UP: {
                        bid = 16;
                        break;
                    }
                    case DOWN: {
                        bid = 32;
                        break;
                    }
                    case BOTH: {
                        bid = 48;
                    }
                }
                switch (dir) {
                    case WEST: {
                        bid = (byte)(bid | 8);
                        break;
                    }
                    case SOUTH: {
                        bid = (byte)(bid | 4);
                        break;
                    }
                    case EAST: {
                        bid = (byte)(bid | 2);
                        break;
                    }
                    default: {
                        bid = (byte)(bid | 1);
                    }
                }
                if (!armMap.containsKey(bid)) {
                    double minY = 0.0;
                    double maxY = 1.0;
                    switch (flipstate) {
                        case UP: {
                            minY = 0.34375;
                            maxY = 1.0;
                            break;
                        }
                        case DOWN: {
                            minY = 0.0;
                            maxY = 0.65625;
                            break;
                        }
                        case BOTH: {
                            minY = 0.0;
                            maxY = 1.0;
                        }
                    }
                    double minX = dir == Direction.EAST ? 0.0 : 0.3125;
                    double maxX = dir == Direction.WEST ? 1.0 : 0.6875;
                    double minZ = dir == Direction.SOUTH ? 0.0 : 0.3125;
                    double maxZ = dir == Direction.NORTH ? 1.0 : 0.6875;
                    VoxelShape shape = Shapes.box((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
                    armMap.put(bid, (Object)shape);
                    return shape;
                }
                return (VoxelShape)armMap.get(bid);
            }
            case EMPTY: {
                if (((Direction)state.getValue((Property)FACING)).getAxis() == Direction.Axis.X) {
                    return X_BOUNDS;
                }
                return Z_BOUNDS;
            }
        }
        byte bid = 0;
        if (((Boolean)state.getValue((Property)LPARM_NORTH)).booleanValue()) {
            bid = (byte)(bid | 1);
        }
        if (((Boolean)state.getValue((Property)LPARM_SOUTH)).booleanValue()) {
            bid = (byte)(bid | 2);
        }
        if (((Boolean)state.getValue((Property)LPARM_EAST)).booleanValue()) {
            bid = (byte)(bid | 4);
        }
        if (((Boolean)state.getValue((Property)LPARM_WEST)).booleanValue()) {
            bid = (byte)(bid | 8);
        }
        if (!defaultMap.containsKey(bid)) {
            VoxelShape shape = POST_SHAPE;
            if (((Boolean)state.getValue((Property)LPARM_NORTH)).booleanValue()) {
                shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)LPARM_NORTH_BOUNDS, (BooleanOp)BooleanOp.OR);
            }
            if (((Boolean)state.getValue((Property)LPARM_SOUTH)).booleanValue()) {
                shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)LPARM_SOUTH_BOUNDS, (BooleanOp)BooleanOp.OR);
            }
            if (((Boolean)state.getValue((Property)LPARM_EAST)).booleanValue()) {
                shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)LPARM_EAST_BOUNDS, (BooleanOp)BooleanOp.OR);
            }
            if (((Boolean)state.getValue((Property)LPARM_WEST)).booleanValue()) {
                shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)LPARM_WEST_BOUNDS, (BooleanOp)BooleanOp.OR);
            }
            shape = shape.optimize();
            defaultMap.put(bid, (Object)shape);
            return shape;
        }
        return (VoxelShape)defaultMap.get(bid);
    }

    public static boolean canConnect(BlockGetter worldIn, BlockPos posIn, Direction facingIn) {
        BlockPos nPos = posIn.relative(facingIn);
        BlockState otherState = worldIn.getBlockState(nPos);
        Block otherBlock = otherState.getBlock();
        if (otherBlock == Blocks.AIR || otherState.isAir()) {
            return false;
        }
        if (otherBlock instanceof CrossCollisionBlock || otherBlock instanceof PostBlock || otherBlock instanceof HorizontalTrussBlock) {
            return false;
        }
        if (otherState.is(IPOTags.IGNORED_BY_POSTARM)) {
            return false;
        }
        if (facingIn == Direction.DOWN && otherBlock instanceof LanternBlock && ((Boolean)otherState.getValue((Property)LanternBlock.HANGING)).booleanValue()) {
            return true;
        }
        VoxelShape shape = otherState.getShape(worldIn, nPos);
        if (!shape.isEmpty()) {
            boolean b;
            AABB box = shape.bounds();
            switch (facingIn) {
                case UP: {
                    return Mth.equal((double)0.0, (double)box.minY);
                }
                case DOWN: {
                    boolean bool = otherBlock instanceof PostBlock;
                    return !bool && Mth.equal((double)1.0, (double)box.maxY);
                }
                case NORTH: {
                    b = Mth.equal((double)1.0, (double)box.maxZ);
                    break;
                }
                case SOUTH: {
                    b = Mth.equal((double)0.0, (double)box.minZ);
                    break;
                }
                case WEST: {
                    b = Mth.equal((double)1.0, (double)box.maxX);
                    break;
                }
                case EAST: {
                    b = Mth.equal((double)0.0, (double)box.minX);
                    break;
                }
                default: {
                    b = false;
                }
            }
            if (b) {
                if (facingIn == Direction.SOUTH || facingIn == Direction.NORTH) {
                    AABB arm = LPARM_SOUTH_BOUNDS.bounds();
                    if ((box.minX > 0.0 && box.maxX < 1.0 || box.minY > 0.0 && box.maxY < 1.0) && box.minX <= arm.minX && box.maxX >= arm.maxX && box.minY <= arm.minY && box.maxY >= arm.maxY) {
                        return true;
                    }
                } else if (facingIn == Direction.EAST || facingIn == Direction.WEST) {
                    AABB arm = LPARM_EAST_BOUNDS.bounds();
                    if ((box.minZ > 0.0 && box.maxZ < 1.0 || box.minY > 0.0 && box.maxY < 1.0) && box.minZ <= arm.minZ && box.maxZ >= arm.maxZ && box.minY <= arm.minY && box.maxY >= arm.maxY) {
                        return true;
                    }
                }
                if (facingIn.getAxis() == Direction.Axis.Z && box.minX > 0.0 && box.maxX < 1.0) {
                    return true;
                }
                if (facingIn.getAxis() == Direction.Axis.X && box.minZ > 0.0 && box.maxZ < 1.0) {
                    return true;
                }
            }
        }
        return false;
    }
}

