/*
 * Decompiled with CFR 0.152.
 */
package twistedgate.immersiveposts.common.blocks;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import twistedgate.immersiveposts.api.posts.IPostMaterial;
import twistedgate.immersiveposts.common.IPOTileTypes;
import twistedgate.immersiveposts.common.blocks.IPOBlockBase;
import twistedgate.immersiveposts.common.blocks.PostBlock;
import twistedgate.immersiveposts.common.tileentity.PostBaseTileEntity;
import twistedgate.immersiveposts.enums.EnumFlipState;
import twistedgate.immersiveposts.enums.EnumPostMaterial;
import twistedgate.immersiveposts.enums.EnumPostType;

public class PostBaseBlock
extends IPOBlockBase
implements SimpleWaterloggedBlock,
EntityBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty HIDDEN = BooleanProperty.create((String)"hidden");
    private static final VoxelShape BASE_SIZE = Shapes.box((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)1.0, (double)0.75);

    private static BlockBehaviour.Properties prop() {
        return EnumPostMaterial.PostBlockProperties.stone().requiresCorrectToolForDrops().strength(5.0f, 3.0f).noOcclusion();
    }

    public PostBaseBlock() {
        super(PostBaseBlock.prop());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)HIDDEN, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HIDDEN, WATERLOGGED});
    }

    public boolean propagatesSkylightDown(BlockState state, @Nonnull BlockGetter reader, @Nonnull BlockPos pos) {
        return !((Boolean)state.getValue((Property)HIDDEN)).booleanValue() ? !((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue() : super.propagatesSkylightDown(state, reader, pos);
    }

    @Nonnull
    public ItemStack getCloneItemStack(@Nonnull BlockState state, @Nonnull HitResult target, @Nonnull LevelReader world, @Nonnull BlockPos pos, Player player) {
        ItemStack stack;
        if (player.isShiftKeyDown() && ((Boolean)state.getValue((Property)HIDDEN)).booleanValue() && (stack = ((PostBaseTileEntity)world.getBlockEntity(pos)).getStack()) != ItemStack.EMPTY) {
            return stack;
        }
        return super.getCloneItemStack(state, target, world, pos, player);
    }

    @Nonnull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)HIDDEN) == false && (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : Fluids.EMPTY.defaultFluidState();
    }

    @Nullable
    public BlockState getStateForPlacement(@Nonnull BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        FluidState fs = context.getLevel().getFluidState(context.getClickedPos());
        state = (BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fs.getType() == Fluids.WATER));
        return state;
    }

    @Nonnull
    public BlockState updateShape(BlockState state, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull LevelAccessor world, @Nonnull BlockPos pos, @Nonnull BlockPos facingPos) {
        if (!((Boolean)state.getValue((Property)HIDDEN)).booleanValue() && ((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return state;
    }

    public boolean canPlaceLiquid(Player player, @Nonnull BlockGetter world, @Nonnull BlockPos pos, BlockState state, @Nonnull Fluid fluid) {
        return (Boolean)state.getValue((Property)HIDDEN) == false && super.canPlaceLiquid(player, world, pos, state, fluid);
    }

    public BlockEntity newBlockEntity(@Nonnull BlockPos pPos, @Nonnull BlockState pState) {
        return ((BlockEntityType)IPOTileTypes.POST_BASE.get()).create(pPos, pState);
    }

    @Nonnull
    public VoxelShape getCollisionShape(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return this.getShape(state, worldIn, pos, context);
    }

    @Nonnull
    public VoxelShape getShape(BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return (Boolean)state.getValue((Property)HIDDEN) != false ? Shapes.block() : BASE_SIZE;
    }

    public boolean skipRendering(@Nonnull BlockState state, @Nonnull BlockState adjacentBlockState, @Nonnull Direction side) {
        return false;
    }

    @Override
    public InteractionResult use(BlockState state, Level worldIn, BlockPos pos, Player playerIn, InteractionHand handIn, BlockHitResult hit) {
        ItemStack held;
        PostBaseTileEntity baseTe;
        BlockEntity te = worldIn.getBlockEntity(pos);
        if (te instanceof PostBaseTileEntity && (baseTe = (PostBaseTileEntity)te).interact(state, worldIn, pos, playerIn, handIn)) {
            return InteractionResult.SUCCESS;
        }
        if (worldIn.isClientSide) {
            held = playerIn.getMainHandItem();
            if (IPostMaterial.isValidItem(held)) {
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        held = playerIn.getMainHandItem();
        if (IPostMaterial.isValidItem(held)) {
            ItemStack tmp;
            BlockState aboveState;
            Block b;
            if (!worldIn.isEmptyBlock(pos.relative(Direction.UP)) && (b = (aboveState = worldIn.getBlockState(pos.relative(Direction.UP))).getBlock()) instanceof PostBlock && !held.is((tmp = ((PostBlock)b).getPostMaterial().getItemStack()).getItem())) {
                playerIn.displayClientMessage((Component)Component.translatable((String)"immersiveposts.expectedlocal", (Object[])new Object[]{tmp.getHoverName()}), true);
                return InteractionResult.SUCCESS;
            }
            for (int y = 1; y <= worldIn.getHeight(Heightmap.Types.WORLD_SURFACE, pos.getX(), pos.getZ()) - pos.getY(); ++y) {
                BlockPos nPos = pos.offset(0, y, 0);
                BlockState nState = worldIn.getBlockState(nPos);
                if (nState.getBlock() instanceof PostBlock) {
                    EnumPostType type = (EnumPostType)((Object)nState.getValue(PostBlock.TYPE));
                    if (type != EnumPostType.POST && type != EnumPostType.POST_TOP && nState.getValue(PostBlock.FLIPSTATE) == EnumFlipState.DOWN) {
                        return InteractionResult.SUCCESS;
                    }
                    nState = worldIn.getBlockState(nPos.relative(Direction.UP));
                    if (nState.getBlock() instanceof PostBlock && (type = (EnumPostType)((Object)nState.getValue(PostBlock.TYPE))) != EnumPostType.POST && type != EnumPostType.POST_TOP) {
                        return InteractionResult.SUCCESS;
                    }
                }
                if (worldIn.isEmptyBlock(nPos) || worldIn.getBlockState(nPos).getBlock() == Blocks.WATER) {
                    BlockState fb = (BlockState)IPostMaterial.getPostState(held).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(worldIn.getBlockState(nPos).getBlock() == Blocks.WATER));
                    if (fb != null && !playerIn.blockPosition().equals((Object)nPos) && worldIn.setBlockAndUpdate(nPos, fb.updateShape(null, null, (LevelAccessor)worldIn, nPos, null)) && !playerIn.isCreative()) {
                        held.shrink(1);
                    }
                    return InteractionResult.SUCCESS;
                }
                if (worldIn.getBlockState(nPos).getBlock() instanceof PostBlock) continue;
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.FAIL;
    }

    public static class ItemPostBase
    extends BlockItem {
        public ItemPostBase(Block block) {
            super(block, new Item.Properties());
        }

        public void appendHoverText(@Nonnull ItemStack stack, @Nonnull Item.TooltipContext context, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag tooltipFlag) {
            super.appendHoverText(stack, context, tooltip, tooltipFlag);
            tooltip.add((Component)Component.translatable((String)"tooltip.postbase"));
        }
    }
}

