/*
 * Decompiled with CFR 0.152.
 */
package twistedgate.immersiveposts.common.blocks;

import blusunrize.immersiveengineering.api.IPostBlock;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import twistedgate.immersiveposts.api.posts.IPostMaterial;
import twistedgate.immersiveposts.common.blocks.GenericPostBlock;
import twistedgate.immersiveposts.common.blocks.PostBlock;
import twistedgate.immersiveposts.enums.EnumHTrussType;
import twistedgate.immersiveposts.enums.EnumPostMaterial;

public class HorizontalTrussBlock
extends GenericPostBlock
implements IPostBlock,
SimpleWaterloggedBlock {
    public static final BooleanProperty CONNECTOR_POINT_TOP = BooleanProperty.create((String)"connector_point_top");
    public static final BooleanProperty CONNECTOR_POINT_BOTTOM = BooleanProperty.create((String)"connector_point_bottom");
    public static final BooleanProperty PANEL_NORTH = BooleanProperty.create((String)"panel_north");
    public static final BooleanProperty PANEL_EAST = BooleanProperty.create((String)"panel_east");
    public static final BooleanProperty PANEL_SOUTH = BooleanProperty.create((String)"panel_south");
    public static final BooleanProperty PANEL_WEST = BooleanProperty.create((String)"panel_west");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final DirectionProperty FACING = DirectionProperty.create((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    public static final EnumProperty<EnumHTrussType> TYPE = EnumProperty.create((String)"type", EnumHTrussType.class);
    static final VoxelShape NORTH_SOUTH = Shapes.box((double)0.3125, (double)0.0, (double)0.0, (double)0.6875, (double)1.0, (double)1.0);
    static final VoxelShape EAST_WEST = Shapes.box((double)0.0, (double)0.0, (double)0.3125, (double)1.0, (double)1.0, (double)0.6875);
    private static final VoxelShape[] SHAPE_CACHE = new VoxelShape[32];

    public HorizontalTrussBlock(IPostMaterial material) {
        super(material);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(TYPE, (Comparable)((Object)EnumHTrussType.SINGLE))).setValue((Property)CONNECTOR_POINT_TOP, (Comparable)Boolean.valueOf(false))).setValue((Property)CONNECTOR_POINT_BOTTOM, (Comparable)Boolean.valueOf(false))).setValue((Property)PANEL_NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)PANEL_EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)PANEL_SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)PANEL_WEST, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED, FACING, TYPE, PANEL_NORTH, PANEL_EAST, PANEL_SOUTH, PANEL_WEST, CONNECTOR_POINT_TOP, CONNECTOR_POINT_BOTTOM});
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public float getShadeBrightness(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 1.0f;
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return (Boolean)state.getValue((Property)WATERLOGGED) == false;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : Fluids.EMPTY.defaultFluidState();
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        FluidState fs = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fs.getType() == Fluids.WATER));
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        boolean b0 = PostBlock.canConnect((BlockGetter)world, pos, Direction.UP);
        boolean b1 = PostBlock.canConnect((BlockGetter)world, pos, Direction.DOWN) || world.getBlockState(pos.relative(Direction.DOWN)).getBlock() instanceof PostBlock;
        return (BlockState)((BlockState)state.setValue((Property)CONNECTOR_POINT_TOP, (Comparable)Boolean.valueOf(b0))).setValue((Property)CONNECTOR_POINT_BOTTOM, (Comparable)Boolean.valueOf(b1));
    }

    public boolean isLadder(BlockState state, LevelReader world, BlockPos pos, LivingEntity entity) {
        return true;
    }

    public boolean isFlammable(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        if (this.getPostMaterial() == EnumPostMaterial.URANIUM && rand.nextFloat() < 0.125f) {
            double x = (double)pos.getX() + 0.375 + 0.25 * rand.nextDouble();
            double y = (double)pos.getY() + rand.nextDouble();
            double z = (double)pos.getZ() + 0.375 + 0.25 * rand.nextDouble();
            worldIn.addParticle((ParticleOptions)PostBlock.URAN_PARTICLE, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean skipRendering(@Nonnull BlockState state, @Nonnull BlockState adjacentBlockState, @Nonnull Direction side) {
        return false;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader world, BlockPos pos, Player player) {
        return this.getPostMaterial().getItemStack();
    }

    public boolean canConnectTransformer(BlockGetter world, BlockPos pos) {
        return true;
    }

    @Override
    public InteractionResult use(BlockState state, Level worldIn, BlockPos pos, Player playerIn, InteractionHand handIn, BlockHitResult hit) {
        ItemStack held;
        if (!worldIn.isClientSide && Utils.isHammer((ItemStack)(held = playerIn.getMainHandItem()))) {
            Direction face = hit.getDirection();
            Direction facing = (Direction)state.getValue((Property)FACING);
            BlockState newState = state;
            switch (facing) {
                case NORTH: 
                case SOUTH: {
                    if (face == Direction.EAST) {
                        newState = (BlockState)newState.setValue((Property)PANEL_EAST, (Comparable)Boolean.valueOf((Boolean)newState.getValue((Property)PANEL_EAST) == false));
                        break;
                    }
                    if (face != Direction.WEST) break;
                    newState = (BlockState)newState.setValue((Property)PANEL_WEST, (Comparable)Boolean.valueOf((Boolean)newState.getValue((Property)PANEL_WEST) == false));
                    break;
                }
                case EAST: 
                case WEST: {
                    if (face == Direction.NORTH) {
                        newState = (BlockState)newState.setValue((Property)PANEL_NORTH, (Comparable)Boolean.valueOf((Boolean)newState.getValue((Property)PANEL_NORTH) == false));
                        break;
                    }
                    if (face != Direction.SOUTH) break;
                    newState = (BlockState)newState.setValue((Property)PANEL_SOUTH, (Comparable)Boolean.valueOf((Boolean)newState.getValue((Property)PANEL_SOUTH) == false));
                    break;
                }
            }
            if (!newState.equals(state)) {
                worldIn.setBlockAndUpdate(pos, newState);
                return InteractionResult.SUCCESS;
            }
        }
        if (Utils.isHammer((ItemStack)playerIn.getMainHandItem())) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (world.isClientSide) {
            return;
        }
        Direction facing = (Direction)state.getValue((Property)FACING);
        BlockPos posA = pos.relative(facing);
        BlockPos posB = pos.relative(facing.getOpposite());
        BlockState stateA = world.getBlockState(posA);
        BlockState stateB = world.getBlockState(posB);
        if (stateA.isAir() || stateB.isAir() || stateA.getBlock() == Blocks.WATER || stateB.getBlock() == Blocks.WATER) {
            this.replaceSelf(state, world, pos);
            return;
        }
    }

    private static int getCacheIndex(Direction.Axis axis, boolean panelNorth, boolean panelEast, boolean panelSouth, boolean panelWest) {
        int result;
        int n = result = axis == Direction.Axis.X ? 1 : 0;
        if (panelNorth) {
            result |= 2;
        }
        if (panelEast) {
            result |= 4;
        }
        if (panelSouth) {
            result |= 8;
        }
        if (panelWest) {
            result |= 0x10;
        }
        return result;
    }

    private static VoxelShape computeShape(Direction.Axis axis, boolean panelNorth, boolean panelEast, boolean panelSouth, boolean panelWest) {
        VoxelShape shape = null;
        switch (axis) {
            case Z: {
                shape = NORTH_SOUTH;
                break;
            }
            case X: {
                shape = EAST_WEST;
                break;
            }
        }
        if (shape == null) {
            return Shapes.empty();
        }
        if (panelNorth) {
            shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)0.5), (BooleanOp)BooleanOp.OR);
        }
        if (panelEast) {
            shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.5, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
        }
        if (panelSouth) {
            shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.5, (double)1.0, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
        }
        if (panelWest) {
            shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
        }
        return shape.optimize();
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction.Axis axis = ((Direction)state.getValue((Property)FACING)).getAxis();
        if (axis != Direction.Axis.X && axis != Direction.Axis.Z) {
            return Shapes.empty();
        }
        return SHAPE_CACHE[HorizontalTrussBlock.getCacheIndex(axis, (Boolean)state.getValue((Property)PANEL_NORTH), (Boolean)state.getValue((Property)PANEL_EAST), (Boolean)state.getValue((Property)PANEL_SOUTH), (Boolean)state.getValue((Property)PANEL_WEST))];
    }

    static {
        boolean[] bools = new boolean[]{false, true};
        for (Direction.Axis axis : new Direction.Axis[]{Direction.Axis.X, Direction.Axis.Z}) {
            for (boolean north : bools) {
                for (boolean east : bools) {
                    for (boolean south : bools) {
                        for (boolean west : bools) {
                            HorizontalTrussBlock.SHAPE_CACHE[HorizontalTrussBlock.getCacheIndex((Direction.Axis)axis, (boolean)north, (boolean)east, (boolean)south, (boolean)west)] = HorizontalTrussBlock.computeShape(axis, north, east, south, west);
                        }
                    }
                }
            }
        }
    }
}

