/*
 * Decompiled with CFR 0.152.
 */
package twistedgate.immersiveposts.common;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@EventBusSubscriber(modid="immersiveposts", bus=EventBusSubscriber.Bus.MOD)
public class IPOConfig {
    public static final Logger log = LogManager.getLogger((String)"immersiveposts/Config");
    public static final ModConfigSpec ALL;
    public static final Posts MAIN;
    private static IConfigSpec.ILoadedConfig rawConfig;

    public static CommentedConfig getRawConfig() {
        if (rawConfig == null) {
            try {
                Field childConfig = ModConfigSpec.class.getDeclaredField("loadedConfig");
                childConfig.setAccessible(true);
                rawConfig = (IConfigSpec.ILoadedConfig)childConfig.get(ALL);
                Preconditions.checkNotNull((Object)rawConfig);
            }
            catch (Exception x) {
                throw new RuntimeException(x);
            }
        }
        return rawConfig.config();
    }

    @SubscribeEvent
    public static void onConfigReload(ModConfigEvent ev) {
    }

    static {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        MAIN = new Posts(builder);
        ALL = builder.build();
    }

    public static class Posts {
        public final ModConfigSpec.ConfigValue<Integer> maxTrussLength;

        Posts(ModConfigSpec.Builder builder) {
            builder.comment(new String[]{"Maximum length of Horizontal Trusses", "Does not affect already existing Trusses when changed", "Default: 8"});
            this.maxTrussLength = builder.defineInRange("maxTrussLength", 8, 3, 128);
        }
    }
}

