/*
 * Decompiled with CFR 0.152.
 */
package twistedgate.immersiveposts.client.model;

import blusunrize.immersiveengineering.client.utils.ModelUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.client.model.geometry.IUnbakedGeometry;
import org.jetbrains.annotations.NotNull;
import twistedgate.immersiveposts.client.model.IPOBakedModel;
import twistedgate.immersiveposts.client.model.IPOModelData;
import twistedgate.immersiveposts.common.tileentity.PostBaseTileEntity;
import twistedgate.immersiveposts.util.ResourceUtils;

public class PostBaseModel
extends IPOBakedModel {
    public static final Cache<Key, SpecialPostBaseModel> CACHE = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.MINUTES).maximumSize(100L).build();
    private static final ChunkRenderTypeSet RENDER_TYPE = ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.cutout()});
    static TextureAtlasSprite postbaseSprite;

    @Override
    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull RandomSource rand, @Nonnull ModelData extraData, @Nullable RenderType layer) {
        Key key;
        SpecialPostBaseModel special;
        BlockState hState = Blocks.DIRT.defaultBlockState();
        Direction facing = Direction.NORTH;
        if (extraData.has(IPOModelData.POSTBASE)) {
            IPOModelData.PostBaseModelData data = (IPOModelData.PostBaseModelData)extraData.get(IPOModelData.POSTBASE);
            hState = data.state;
            facing = data.facing;
        }
        if ((special = (SpecialPostBaseModel)CACHE.getIfPresent((Object)(key = new Key(hState, facing)))) == null) {
            special = new SpecialPostBaseModel(key);
            CACHE.put((Object)key, (Object)special);
        }
        return special.getQuads(state, side, rand);
    }

    @Nonnull
    public ModelData getModelData(@Nonnull BlockAndTintGetter world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull ModelData tileData) {
        ModelData.Builder mData = super.getModelData(world, pos, state, tileData).derive();
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof PostBaseTileEntity) {
            PostBaseTileEntity base = (PostBaseTileEntity)blockEntity;
            IPOModelData.PostBaseModelData data = new IPOModelData.PostBaseModelData(base);
            mData.with(IPOModelData.POSTBASE, (Object)data);
        }
        return mData.build();
    }

    @Nonnull
    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        return RENDER_TYPE;
    }

    public boolean useAmbientOcclusion() {
        return true;
    }

    public boolean isGui3d() {
        return true;
    }

    public boolean isCustomRenderer() {
        return false;
    }

    static TextureAtlasSprite getPostbaseSprite() {
        if (postbaseSprite == null) {
            postbaseSprite = Minecraft.getInstance().getModelManager().getAtlas(InventoryMenu.BLOCK_ATLAS).getSprite(ResourceUtils.ipo("block/postbase"));
        }
        return postbaseSprite;
    }

    @Nonnull
    public TextureAtlasSprite getParticleIcon() {
        return PostBaseModel.getPostbaseSprite();
    }

    @Nonnull
    public ItemOverrides getOverrides() {
        return ItemOverrides.EMPTY;
    }

    private record Key(BlockState state, Direction facing) {
    }

    private static class SpecialPostBaseModel
    extends PostBaseModel {
        private static final RandomSource RANDOM = RandomSource.create();
        private static final Vec3[] verts = new Vec3[]{new Vec3(0.25, (double)1.001f, 0.25), new Vec3(0.25, (double)1.001f, 0.75), new Vec3(0.75, (double)1.001f, 0.75), new Vec3(0.75, (double)1.001f, 0.25)};
        private static final double[] uvs = new double[]{8.0, 0.0, 16.0, 8.0};
        private static final float[] color = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        List<List<BakedQuad>> quads = new ArrayList<List<BakedQuad>>(6);

        public SpecialPostBaseModel(Key key) {
            this.build(key);
        }

        private void build(Key key) {
            BakedModel model = Minecraft.getInstance().getBlockRenderer().getBlockModelShaper().getBlockModel(key.state);
            for (Direction side : Direction.values()) {
                ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(model.getQuads(key.state, side, RANDOM, ModelData.EMPTY, null));
                if (side == Direction.UP) {
                    TextureAtlasSprite sprite = SpecialPostBaseModel.getPostbaseSprite();
                    quads.add(ModelUtils.createBakedQuad((Vec3[])verts, (Direction)side, (TextureAtlasSprite)sprite, (double[])uvs, (float[])color, (boolean)false));
                }
                this.quads.add(quads);
            }
            this.quads.add((List<BakedQuad>)ImmutableList.of());
        }

        @Override
        @Nonnull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nullable RandomSource rand, @Nullable ModelData extraData, RenderType layer) {
            return this.quads.get(side == null ? this.quads.size() - 1 : side.get3DDataValue());
        }
    }

    public static class Loader
    implements IGeometryLoader<PostBaseModelRaw> {
        public static final ResourceLocation LOCATION = ResourceUtils.ipo("postbase");

        public PostBaseModelRaw read(@Nonnull JsonObject jsonObject, @Nonnull JsonDeserializationContext deserializationContext) throws JsonParseException {
            return new PostBaseModelRaw();
        }

        public static class PostBaseModelRaw
        implements IUnbakedGeometry<PostBaseModelRaw> {
            public BakedModel bake(@Nonnull IGeometryBakingContext iGeometryBakingContext, @Nonnull ModelBaker modelBaker, @Nonnull Function<Material, TextureAtlasSprite> function, @Nonnull ModelState modelState, @Nonnull ItemOverrides itemOverrides) {
                return new PostBaseModel();
            }
        }
    }

    public static class ReloadListener
    extends SimplePreparableReloadListener<Unit> {
        @Nonnull
        protected Unit prepare(@Nonnull ResourceManager resourceManager, @Nonnull ProfilerFiller profilerFiller) {
            return Unit.INSTANCE;
        }

        protected void apply(@Nonnull Unit unit, @Nonnull ResourceManager resourceManager, @Nonnull ProfilerFiller profilerFiller) {
            CACHE.invalidateAll();
        }
    }
}

