/*
 * Decompiled with CFR 0.152.
 */
package twistedgate.immersiveposts.api.posts;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.apache.commons.lang3.tuple.Pair;
import twistedgate.immersiveposts.api.posts.IPostMaterial;
import twistedgate.immersiveposts.common.blocks.HorizontalTrussBlock;
import twistedgate.immersiveposts.common.blocks.PostBlock;

public class PostMaterialRegistry {
    static final Map<IPostMaterial, Pair<DeferredHolder<Block, ? extends Block>, DeferredHolder<Block, ? extends Block>>> MAP = new HashMap<IPostMaterial, Pair<DeferredHolder<Block, ? extends Block>, DeferredHolder<Block, ? extends Block>>>();

    public static void register(DeferredRegister<Block> register, IPostMaterial material) {
        if (MAP.containsKey(material)) {
            throw new IllegalArgumentException("PostMaterial \"" + material.getName() + "\" already exists!");
        }
        DeferredHolder post = register.register(material.getBlockName(), () -> new PostBlock(material));
        DeferredHolder truss = register.register(material.getBlockName() + "_truss", () -> new HorizontalTrussBlock(material));
        MAP.put(material, (Pair<DeferredHolder<Block, ? extends Block>, DeferredHolder<Block, ? extends Block>>)Pair.of((Object)post, (Object)truss));
    }

    public static final DeferredHolder<Block, ? extends Block> getPostFrom(IPostMaterial material) {
        Pair<DeferredHolder<Block, ? extends Block>, DeferredHolder<Block, ? extends Block>> pair = MAP.get(material);
        return pair != null ? (DeferredHolder)pair.getLeft() : null;
    }

    public static final DeferredHolder<Block, ? extends Block> getTrussFrom(IPostMaterial material) {
        Pair<DeferredHolder<Block, ? extends Block>, DeferredHolder<Block, ? extends Block>> pair = MAP.get(material);
        return pair != null ? (DeferredHolder)pair.getRight() : null;
    }
}

