/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.util.survey;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import flaxbeard.immersivepetroleum.api.reservoir.Reservoir;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirHandler;
import flaxbeard.immersivepetroleum.common.IPDataComponents;
import flaxbeard.immersivepetroleum.common.util.survey.ISurveyInfo;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public record SurveyScan(@Nullable UUID uuid, int x, int z, byte[] data) implements ISurveyInfo
{
    public static final int SCAN_RADIUS = 32;
    public static final int SCAN_SIZE = 65;
    private static final double sqrt2048 = Math.sqrt(2048.0);
    private static final Codec<UUID> UUID_CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.LONG.fieldOf("msb").forGetter(UUID::getMostSignificantBits), (App)Codec.LONG.fieldOf("lsb").forGetter(UUID::getLeastSignificantBits)).apply((Applicative)inst, UUID::new));
    public static final Codec<SurveyScan> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)UUID_CODEC.optionalFieldOf("uuid").forGetter(s -> {
        if (s.uuid == null) {
            return Optional.empty();
        }
        return Optional.of(s.uuid);
    }), (App)Codec.INT.fieldOf("x").forGetter(s -> s.x), (App)Codec.INT.fieldOf("z").forGetter(s -> s.z), (App)Codec.BYTE.sizeLimitedListOf(4225).fieldOf("data").forGetter(s -> {
        ArrayList<Byte> bytes = new ArrayList<Byte>();
        for (byte b : s.data) {
            bytes.add(b);
        }
        return bytes;
    })).apply((Applicative)inst, SurveyScan::create));
    public static final StreamCodec<ByteBuf, SurveyScan> CODEC_STREAM = ByteBufCodecs.COMPOUND_TAG.map(SurveyScan::fromNBT, ISurveyInfo::writeToTag);

    private static SurveyScan fromNBT(CompoundTag nbt) {
        UUID uuid = nbt.hasUUID("uuid") ? nbt.getUUID("uuid") : null;
        int x = nbt.getInt("x");
        int z = nbt.getInt("z");
        byte[] data = nbt.getByteArray("map");
        return new SurveyScan(uuid, x, z, data);
    }

    private static SurveyScan create(@Nonnull Optional<UUID> opUUID, int x, int z, @Nonnull List<Byte> dataList) {
        byte[] data = new byte[dataList.size()];
        for (int i = 0; i < dataList.size(); ++i) {
            data[i] = dataList.get(i);
        }
        return new SurveyScan(opUUID.orElse(null), x, z, data);
    }

    public static SurveyScan create(Level world, BlockPos pos) {
        UUID uuid = UUID.randomUUID();
        int x = pos.getX();
        int z = pos.getZ();
        byte[] data = SurveyScan.scanArea(world, pos);
        return new SurveyScan(uuid, x, z, data);
    }

    private static byte[] scanArea(Level world, BlockPos pos) {
        ArrayList<Reservoir> islandCache = new ArrayList<Reservoir>();
        byte[] scanData = new byte[4225];
        int j = -32;
        int a = 0;
        while (j <= 32) {
            int i = -32;
            int b = 0;
            while (i <= 32) {
                int x = pos.getX() - i;
                int z = pos.getZ() - j;
                int data = 0;
                double current = ReservoirHandler.getValueOf(world, x, z);
                if (current != -1.0) {
                    Optional<Reservoir> optional = islandCache.stream().filter(res -> res.getPolygon().contains(x, z)).findFirst();
                    Reservoir nearbyIsland = optional.orElse(null);
                    if (nearbyIsland == null && (nearbyIsland = ReservoirHandler.getReservoirNoCache(world, new ColumnPos(x, z))) != null) {
                        islandCache.add(nearbyIsland);
                    }
                    if (nearbyIsland != null) {
                        data = (int)Mth.clamp((double)(255.0 * current), (double)0.0, (double)255.0);
                    }
                }
                int noise = 31 + (int)(127.0 * Math.random());
                double blend = Math.sqrt(i * i + j * j) / sqrt2048;
                int lerped = (int)Mth.clampedLerp((double)data, (double)noise, (double)blend);
                scanData[a * 65 + b] = (byte)(lerped & 0xFF);
                ++i;
                ++b;
            }
            ++j;
            ++a;
        }
        return SurveyScan.normalizeScanData(scanData);
    }

    private static byte[] normalizeScanData(byte[] scanData) {
        int data;
        int i;
        int max = Integer.MIN_VALUE;
        for (i = 0; i < scanData.length; ++i) {
            data = scanData[i] & 0xFF;
            if (data <= max) continue;
            max = data;
        }
        for (i = 0; i < scanData.length; ++i) {
            data = scanData[i] & 0xFF;
            scanData[i] = (byte)(255.0f * ((float)data / (float)max));
        }
        return scanData;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getZ() {
        return this.z;
    }

    @Override
    public void writeToStack(ItemStack stack) {
        stack.set(IPDataComponents.SURVEY_SCAN, (Object)this);
    }

    @Override
    public CompoundTag writeToTag() {
        CompoundTag tag = new CompoundTag();
        tag.putUUID("uuid", UUID.randomUUID());
        tag.putInt("x", this.x);
        tag.putInt("z", this.z);
        tag.putByteArray("map", this.data);
        return tag;
    }
}

