/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.util.survey;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import flaxbeard.immersivepetroleum.ImmersivePetroleum;
import flaxbeard.immersivepetroleum.api.reservoir.Reservoir;
import flaxbeard.immersivepetroleum.common.IPDataComponents;
import flaxbeard.immersivepetroleum.common.util.RegistryUtils;
import flaxbeard.immersivepetroleum.common.util.survey.ISurveyInfo;
import io.netty.buffer.ByteBuf;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public record ReservoirInfo(int x, int z, byte percentage, long amount, FluidStack fluidStack, int expected) implements ISurveyInfo
{
    public static final Codec<ReservoirInfo> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.INT.fieldOf("x").forGetter(s -> s.x), (App)Codec.INT.fieldOf("z").forGetter(s -> s.z), (App)Codec.BYTE.fieldOf("percentage").forGetter(s -> s.percentage), (App)Codec.LONG.fieldOf("amount").forGetter(s -> s.amount), (App)FluidStack.CODEC.fieldOf("fluid").forGetter(s -> s.fluidStack), (App)Codec.INT.fieldOf("expected").forGetter(s -> s.expected)).apply((Applicative)inst, ReservoirInfo::new));
    public static final StreamCodec<ByteBuf, ReservoirInfo> CODEC_STREAM = ByteBufCodecs.COMPOUND_TAG.map(ReservoirInfo::fromNBT, ISurveyInfo::writeToTag);

    private static ReservoirInfo fromNBT(CompoundTag nbt) {
        int x = nbt.getInt("x");
        int z = nbt.getInt("z");
        byte status = nbt.getByte("percentage");
        long amount = nbt.getLong("amount");
        int expected = nbt.getInt("expected");
        FluidStack fluidStack = FluidStack.EMPTY;
        if (nbt.contains("fluid")) {
            try {
                ResourceLocation fluidRL = ResourceLocation.parse((String)nbt.getString("fluid"));
                Fluid fluid = RegistryUtils.getFluidFromRegistryName(fluidRL);
                if (fluid != null) {
                    fluidStack = new FluidStack(fluid, 1);
                }
            }
            catch (ResourceLocationException e) {
                ImmersivePetroleum.log.debug("ReservoirInfo invalid ResourceLocation. Ignoring.");
            }
        }
        return new ReservoirInfo(x, z, status, amount, fluidStack, expected);
    }

    public static ReservoirInfo create(Level world, BlockPos pos, Reservoir reservoir) {
        int x = pos.getX();
        int z = pos.getZ();
        byte status = (byte)((float)reservoir.getAmount() / (float)reservoir.getCapacity() * 100.0f);
        long amount = reservoir.getAmount();
        FluidStack fluidStack = new FluidStack(reservoir.getFluid(), 1);
        int expected = Reservoir.getFlow(reservoir.getPressure(world, pos.getX(), pos.getZ()));
        return new ReservoirInfo(x, z, status, amount, fluidStack, expected);
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getZ() {
        return this.z;
    }

    public Fluid getFluid() {
        return this.fluidStack.getFluid();
    }

    @Override
    public void writeToStack(ItemStack stack) {
        stack.set(IPDataComponents.RESERVOIR_INFO, (Object)this);
    }

    @Override
    public CompoundTag writeToTag() {
        CompoundTag tag = new CompoundTag();
        tag.putInt("x", this.x);
        tag.putInt("z", this.z);
        tag.putByte("percentage", this.percentage);
        tag.putLong("amount", this.amount);
        tag.putInt("expected", this.expected);
        if (!this.fluidStack.isEmpty()) {
            tag.putString("fluid", RegistryUtils.getRegistryNameOf(this.fluidStack.getFluid()).toString());
        }
        return tag;
    }
}

