/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.util.projector;

import blusunrize.immersiveengineering.api.multiblocks.MultiblockHandler;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import flaxbeard.immersivepetroleum.common.IPDataComponents;
import flaxbeard.immersivepetroleum.common.network.MessageProjectorSync;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Rotation;

public class Settings {
    public static final String KEY_MODE = "mode";
    public static final String KEY_MULTIBLOCK = "multiblock";
    public static final String KEY_MIRROR = "mirror";
    public static final String KEY_PLACED = "placed";
    public static final String KEY_ROTATION = "rotation";
    public static final String KEY_POSITION = "pos";
    @Nullable
    private MultiblockHandler.IMultiblock multiblock = null;
    @Nullable
    private BlockPos pos = null;
    private Mode mode = Mode.MULTIBLOCK_SELECTION;
    private Rotation rotation = Rotation.NONE;
    private boolean mirror = false;
    private boolean isPlaced = false;

    public Settings() {
        this(new CompoundTag());
    }

    public Settings(CompoundTag settingsNbt) {
        if (settingsNbt != null && !settingsNbt.isEmpty()) {
            this.mode = Mode.values()[Mth.clamp((int)settingsNbt.getInt(KEY_MODE), (int)0, (int)(Mode.values().length - 1))];
            this.rotation = Rotation.values()[settingsNbt.contains(KEY_ROTATION) ? settingsNbt.getInt(KEY_ROTATION) : 0];
            this.mirror = settingsNbt.getBoolean(KEY_MIRROR);
            this.isPlaced = settingsNbt.getBoolean(KEY_PLACED);
            if (settingsNbt.contains(KEY_MULTIBLOCK, 8)) {
                String str = settingsNbt.getString(KEY_MULTIBLOCK);
                this.multiblock = MultiblockHandler.getByUniqueName((ResourceLocation)ResourceLocation.parse((String)str));
            }
            if (settingsNbt.contains(KEY_POSITION, 10)) {
                CompoundTag pos = settingsNbt.getCompound(KEY_POSITION);
                int x = pos.getInt("x");
                int y = pos.getInt("y");
                int z = pos.getInt("z");
                this.pos = new BlockPos(x, y, z);
            }
        }
    }

    public CompoundTag toNbt() {
        CompoundTag nbt = new CompoundTag();
        nbt.putInt(KEY_MODE, this.mode.ordinal());
        nbt.putInt(KEY_ROTATION, this.rotation.ordinal());
        nbt.putBoolean(KEY_MIRROR, this.mirror);
        nbt.putBoolean(KEY_PLACED, this.isPlaced);
        if (this.multiblock != null) {
            nbt.putString(KEY_MULTIBLOCK, this.multiblock.getUniqueName().toString());
        }
        if (this.pos != null) {
            CompoundTag pos = new CompoundTag();
            pos.putInt("x", this.pos.getX());
            pos.putInt("y", this.pos.getY());
            pos.putInt("z", this.pos.getZ());
            nbt.put(KEY_POSITION, (Tag)pos);
        }
        return nbt;
    }

    public void rotateCW() {
        this.rotation = this.rotation.getRotated(Rotation.CLOCKWISE_90);
    }

    public void rotateCCW() {
        this.rotation = this.rotation.getRotated(Rotation.COUNTERCLOCKWISE_90);
    }

    public void flip() {
        this.mirror = !this.mirror;
    }

    public void switchMode() {
        int id = this.mode.ordinal() + 1;
        this.mode = Mode.values()[id % Mode.values().length];
    }

    public void sendPacketToServer(InteractionHand hand) {
        MessageProjectorSync.sendToServer(this, hand);
    }

    public void sendPacketToClient(Player player, InteractionHand hand) {
        MessageProjectorSync.sendToClient(player, this, hand);
    }

    public void setRotation(Rotation rotation) {
        this.rotation = rotation;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public void setMultiblock(@Nullable MultiblockHandler.IMultiblock multiblock) {
        this.multiblock = multiblock;
    }

    public void setMirror(boolean mirror) {
        this.mirror = mirror;
    }

    public void setPlaced(boolean isPlaced) {
        this.isPlaced = isPlaced;
    }

    public void setPos(@Nullable BlockPos pos) {
        this.pos = pos;
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public boolean isMirrored() {
        return this.mirror;
    }

    public boolean isPlaced() {
        return this.isPlaced;
    }

    public Mode getMode() {
        return this.mode;
    }

    @Nullable
    public BlockPos getPos() {
        return this.pos;
    }

    @Nullable
    public MultiblockHandler.IMultiblock getMultiblock() {
        return this.multiblock;
    }

    public ItemStack applyTo(ItemStack stack) {
        stack.set(IPDataComponents.PROJECTOR_SETTINGS, (Object)new SettingsRecord(this));
        return stack;
    }

    public String toString() {
        return "\"Settings\":[" + this.toNbt().toString() + "]";
    }

    public static enum Mode {
        MULTIBLOCK_SELECTION,
        PROJECTION;

        final String translation = "desc.immersivepetroleum.info.projector.mode_" + this.ordinal();

        public Component getTranslated() {
            return Component.translatable((String)this.translation);
        }
    }

    public record SettingsRecord(@Nullable MultiblockHandler.IMultiblock multiblock, @Nullable BlockPos pos, Mode mode, Rotation rotation, boolean isMirrored, boolean isPlaced) {
        public static final String KEY_MODE = "mode";
        public static final String KEY_MULTIBLOCK = "multiblock";
        public static final String KEY_MIRROR = "mirror";
        public static final String KEY_PLACED = "placed";
        public static final String KEY_ROTATION = "rotation";
        public static final String KEY_POSITION = "pos";
        public static final Codec<SettingsRecord> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.STRING.optionalFieldOf("multiblock").forGetter(s -> {
            if (s.multiblock == null) {
                return Optional.empty();
            }
            return Optional.of(s.multiblock.getUniqueName().toString());
        }), (App)BlockPos.CODEC.optionalFieldOf("pos").forGetter(s -> Optional.ofNullable(s.pos)), (App)Codec.INT.fieldOf("mode").forGetter(s -> s.mode.ordinal()), (App)Rotation.CODEC.fieldOf("rotation").forGetter(SettingsRecord::rotation), (App)Codec.BOOL.fieldOf("isMirrored").forGetter(SettingsRecord::isMirrored), (App)Codec.BOOL.fieldOf("isPlaced").forGetter(SettingsRecord::isPlaced)).apply((Applicative)inst, SettingsRecord::new));
        public static final StreamCodec<ByteBuf, SettingsRecord> CODEC_STREAM = ByteBufCodecs.COMPOUND_TAG.map(SettingsRecord::fromNbt, SettingsRecord::toNbt);

        private SettingsRecord(Optional<String> mbString, Optional<BlockPos> optPos, int mode, Rotation rotation, boolean isMirrored, boolean isPlaced) {
            this(mbString.map(s -> MultiblockHandler.getByUniqueName((ResourceLocation)ResourceLocation.parse((String)s))).orElse(null), optPos.orElse(null), Mode.values()[mode], rotation, isMirrored, isPlaced);
        }

        public SettingsRecord(Settings settings) {
            this(settings.multiblock, settings.pos, settings.mode, settings.rotation, settings.mirror, settings.isPlaced);
        }

        public static SettingsRecord fromNbt(CompoundTag settingsNbt) {
            MultiblockHandler.IMultiblock multiblock = null;
            BlockPos pos = null;
            Mode mode = Mode.MULTIBLOCK_SELECTION;
            Rotation rotation = Rotation.NONE;
            boolean isMirrored = false;
            boolean isPlaced = false;
            if (settingsNbt != null && !settingsNbt.isEmpty()) {
                mode = Mode.values()[Mth.clamp((int)settingsNbt.getInt("mode"), (int)0, (int)(Mode.values().length - 1))];
                rotation = Rotation.values()[settingsNbt.contains("rotation") ? settingsNbt.getInt("rotation") : 0];
                isMirrored = settingsNbt.getBoolean("mirror");
                isPlaced = settingsNbt.getBoolean("placed");
                if (settingsNbt.contains("multiblock", 8)) {
                    String str = settingsNbt.getString("multiblock");
                    multiblock = MultiblockHandler.getByUniqueName((ResourceLocation)ResourceLocation.parse((String)str));
                }
                if (settingsNbt.contains("pos", 10)) {
                    CompoundTag posNbt = settingsNbt.getCompound("pos");
                    int x = posNbt.getInt("x");
                    int y = posNbt.getInt("y");
                    int z = posNbt.getInt("z");
                    pos = new BlockPos(x, y, z);
                }
            }
            return new SettingsRecord(multiblock, pos, mode, rotation, isMirrored, isPlaced);
        }

        public CompoundTag toNbt() {
            CompoundTag nbt = new CompoundTag();
            nbt.putInt("mode", this.mode.ordinal());
            nbt.putInt("rotation", this.rotation.ordinal());
            nbt.putBoolean("mirror", this.isMirrored);
            nbt.putBoolean("placed", this.isPlaced);
            if (this.multiblock != null) {
                nbt.putString("multiblock", this.multiblock.getUniqueName().toString());
            }
            if (this.pos != null) {
                CompoundTag pos = new CompoundTag();
                pos.putInt("x", this.pos.getX());
                pos.putInt("y", this.pos.getY());
                pos.putInt("z", this.pos.getZ());
                nbt.put("pos", (Tag)pos);
            }
            return nbt;
        }

        public Settings convert() {
            Settings settings = new Settings();
            settings.multiblock = this.multiblock;
            settings.pos = this.pos;
            settings.mode = this.mode;
            settings.rotation = this.rotation;
            settings.mirror = this.isMirrored;
            settings.isPlaced = this.isPlaced;
            return settings;
        }
    }
}

