/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.util.commands;

import com.google.common.collect.Multimap;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import flaxbeard.immersivepetroleum.api.reservoir.Reservoir;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirBoundingBox;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirHandler;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirType;
import flaxbeard.immersivepetroleum.common.datastorage.reservoir.RegionData;
import flaxbeard.immersivepetroleum.common.datastorage.reservoir.RegionPos;
import flaxbeard.immersivepetroleum.common.datastorage.reservoir.ReservoirRegionDataStorage;
import flaxbeard.immersivepetroleum.common.util.Utils;
import flaxbeard.immersivepetroleum.common.util.commands.CommandUtils;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.coordinates.ColumnPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.FluidStack;

public class IslandCommand {
    private IslandCommand() {
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create() {
        LiteralArgumentBuilder main = (LiteralArgumentBuilder)Commands.literal((String)"reservoir").requires(source -> source.hasPermission(4));
        main.then(Commands.literal((String)"locate").executes(IslandCommand::locate));
        main.then(IslandCommand.setters());
        main.then((ArgumentBuilder)IslandCommand.positional(Commands.literal((String)"get"), IslandCommand::get));
        return main;
    }

    private static int get(CommandContext<CommandSourceStack> context, @Nonnull Reservoir reservoir) {
        CommandUtils.sendTranslated((CommandSourceStack)context.getSource(), "chat.immersivepetroleum.command.reservoir.get", reservoir.getAmount(), Utils.fDecimal((double)reservoir.getAmount() / (double)reservoir.getCapacity() * 100.0), new FluidStack(reservoir.getFluid(), 1).getHoverName());
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int locate(CommandContext<CommandSourceStack> command) {
        int x;
        int z;
        ReservoirBoundingBox IAABB;
        BlockPos srcPos;
        CommandSourceStack source = (CommandSourceStack)command.getSource();
        if (source.getEntity() != null) {
            srcPos = source.getEntity().blockPosition();
        } else {
            Vec3 position = source.getPosition();
            srcPos = new BlockPos((int)position.x, (int)position.y, (int)position.z);
        }
        double dx = (double)srcPos.getX() + 0.5;
        double dz = (double)srcPos.getZ() + 0.5;
        int range = 128;
        int rangeSqr = range * range;
        HashSet nearby = new HashSet();
        ReservoirRegionDataStorage storage = ReservoirRegionDataStorage.get();
        RegionData[] regions = new RegionData[]{storage.getRegionData(new RegionPos(srcPos, 1, -1)), storage.getRegionData(new RegionPos(srcPos, 1, 1)), storage.getRegionData(new RegionPos(srcPos, -1, -1)), storage.getRegionData(new RegionPos(srcPos, -1, 1))};
        ResourceKey dimKey = source.getLevel().dimension();
        for (RegionData rd : regions) {
            if (rd == null) continue;
            Multimap<ResourceKey<Level>, Reservoir> islands = rd.getReservoirList();
            Multimap<ResourceKey<Level>, Reservoir> multimap = islands;
            synchronized (multimap) {
                islands.get((Object)dimKey).forEach(reservoir -> {
                    if (reservoir.getBoundingBox().getCenter().distToCenterSqr(dx, 0.0, dz) <= (double)rangeSqr) {
                        nearby.add(reservoir);
                    }
                });
            }
        }
        if (nearby.isEmpty()) {
            CommandUtils.sendTranslated(source, "chat.immersivepetroleum.command.reservoir.notfound", new Object[0]);
            return 1;
        }
        Reservoir closestIsland = null;
        double smallestDistance = rangeSqr;
        ColumnPos p = null;
        for (Reservoir reservoir2 : nearby) {
            IAABB = reservoir2.getBoundingBox();
            for (z = IAABB.zMin() + 1; z < IAABB.zMax(); ++z) {
                for (x = IAABB.xMin() + 1; x < IAABB.xMax(); ++x) {
                    double za;
                    double xa;
                    double dst;
                    if (!reservoir2.getPolygon().contains(x, z) || !((dst = (xa = (double)x + 0.5 - dx) * xa + (za = (double)z + 0.5 - dz) * za) < smallestDistance)) continue;
                    p = new ColumnPos(x, z);
                    smallestDistance = dst;
                    closestIsland = reservoir2;
                }
            }
        }
        if (closestIsland == null) {
            CommandUtils.sendStringError(source, "List should not be empty. Please report this bug. (Immersive Petroleum)");
            return 1;
        }
        double hPressure = 0.0;
        IAABB = closestIsland.getBoundingBox();
        for (z = IAABB.zMin() + 1; z < IAABB.zMax(); ++z) {
            for (x = IAABB.xMin() + 1; x < IAABB.xMax(); ++x) {
                double d;
                if (!closestIsland.getPolygon().contains(x, z)) continue;
                double cPressure = ReservoirHandler.getValueOf((Level)source.getLevel(), x, z);
                if (!(d > hPressure)) continue;
                hPressure = cPressure;
                p = new ColumnPos(x, z);
            }
        }
        ClickEvent clickEvent = new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tp @s " + p.x() + " ~ " + p.z());
        HoverEvent hoverEvent = new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"chat.coordinates.tooltip"));
        Reservoir finalClosestIsland = closestIsland;
        ColumnPos finalP = p;
        source.sendSuccess(() -> Component.translatable((String)"chat.immersivepetroleum.command.reservoir.locate", (Object[])new Object[]{((ReservoirType)finalClosestIsland.getType().value()).name, ComponentUtils.wrapInSquareBrackets((Component)Component.literal((String)(finalP.x() + " " + finalP.z()))).withStyle(s -> s.withColor(ChatFormatting.GREEN).withItalic(Boolean.valueOf(true)).withClickEvent(clickEvent).withHoverEvent(hoverEvent))}), true);
        return 1;
    }

    private static LiteralArgumentBuilder<CommandSourceStack> setters() {
        LiteralArgumentBuilder set = (LiteralArgumentBuilder)Commands.literal((String)"set").requires(source -> source.hasPermission(4));
        set.then(Commands.literal((String)"amount").then((ArgumentBuilder)IslandCommand.positional(Commands.argument((String)"amount", (ArgumentType)LongArgumentType.longArg((long)0L, (long)0xFFFFFFFFL)), IslandCommand::setReservoirAmount)));
        set.then(Commands.literal((String)"capacity").then((ArgumentBuilder)IslandCommand.positional(Commands.argument((String)"capacity", (ArgumentType)LongArgumentType.longArg((long)0L, (long)0xFFFFFFFFL)), IslandCommand::setReservoirCapacity)));
        set.then(Commands.literal((String)"type").then((ArgumentBuilder)IslandCommand.positional(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).suggests(IslandCommand::typeSuggestor), IslandCommand::setReservoirType)));
        return set;
    }

    private static CompletableFuture<Suggestions> typeSuggestor(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.suggest(ReservoirType.map.values().stream().map(type -> ((ReservoirType)type.value()).name), (SuggestionsBuilder)builder);
    }

    private static int setReservoirAmount(CommandContext<CommandSourceStack> context, @Nonnull Reservoir reservoir) {
        long amount = (Long)context.getArgument("amount", Long.class);
        reservoir.setAmount(amount);
        reservoir.setDirty();
        CommandUtils.sendTranslated((CommandSourceStack)context.getSource(), "chat.immersivepetroleum.command.reservoir.set.amount.success", reservoir.getAmount());
        return 1;
    }

    private static int setReservoirCapacity(CommandContext<CommandSourceStack> context, @Nonnull Reservoir reservoir) {
        long capacity = (Long)context.getArgument("capacity", Long.class);
        reservoir.setAmountAndCapacity(capacity, capacity);
        reservoir.setDirty();
        CommandUtils.sendTranslated((CommandSourceStack)context.getSource(), "chat.immersivepetroleum.command.reservoir.set.capacity.success", reservoir.getCapacity());
        return 1;
    }

    private static int setReservoirType(CommandContext<CommandSourceStack> context, @Nonnull Reservoir reservoir) {
        String name = (String)context.getArgument("name", String.class);
        RecipeHolder<ReservoirType> type = null;
        for (RecipeHolder<ReservoirType> holder : ReservoirType.map.values()) {
            if (!((ReservoirType)holder.value()).name.equalsIgnoreCase(name)) continue;
            type = holder;
        }
        if (type == null) {
            CommandUtils.sendTranslatedError((CommandSourceStack)context.getSource(), "chat.immersivepetroleum.command.reservoir.set.type.fail", name);
            return 1;
        }
        reservoir.setReservoirType(type);
        reservoir.setDirty();
        CommandUtils.sendTranslated((CommandSourceStack)context.getSource(), "chat.immersivepetroleum.command.reservoir.set.type.success", ((ReservoirType)reservoir.getType().value()).name);
        return 1;
    }

    static <T extends ArgumentBuilder<CommandSourceStack, T>> T positional(T builder, BiFunction<CommandContext<CommandSourceStack>, Reservoir, Integer> function) {
        builder.executes(command -> {
            ColumnPos pos = Utils.toColumnPos(BlockPos.containing((Position)((CommandSourceStack)command.getSource()).getPosition()));
            Reservoir reservoir = ReservoirHandler.getReservoir((Level)((CommandSourceStack)command.getSource()).getLevel(), pos);
            if (reservoir == null) {
                CommandUtils.sendTranslated((CommandSourceStack)command.getSource(), "chat.immersivepetroleum.command.reservoir.notfound", new Object[0]);
                return 1;
            }
            return (Integer)function.apply(command, reservoir);
        }).then(Commands.argument((String)"location", (ArgumentType)ColumnPosArgument.columnPos()).executes(command -> {
            ColumnPos pos = ColumnPosArgument.getColumnPos((CommandContext)command, (String)"location");
            Reservoir reservoir = ReservoirHandler.getReservoir((Level)((CommandSourceStack)command.getSource()).getLevel(), pos);
            if (reservoir == null) {
                CommandUtils.sendTranslated((CommandSourceStack)command.getSource(), "chat.immersivepetroleum.command.reservoir.notfound", new Object[0]);
                return 1;
            }
            return (Integer)function.apply(command, reservoir);
        }));
        return builder;
    }
}

