/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.util;

import blusunrize.immersiveengineering.api.IEApiDataComponents;
import com.mojang.datafixers.util.Unit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;

public class FluidHelper {
    public static FluidStack copyFluid(FluidStack fluid, int amount) {
        return FluidHelper.copyFluid(fluid, amount, false);
    }

    public static FluidStack copyFluid(FluidStack fluid, int amount, boolean pressurize) {
        FluidStack fs = new FluidStack(fluid.getFluid(), amount);
        if (pressurize && amount > 50) {
            fs.set(IEApiDataComponents.FLUID_PRESSURIZED, (Object)Unit.INSTANCE);
        }
        return fs;
    }

    public static FluidStack makePressurizedFluid(Fluid fluid, int amount) {
        FluidStack fs = new FluidStack(fluid, amount);
        if (amount > 50) {
            fs.set(IEApiDataComponents.FLUID_PRESSURIZED, (Object)Unit.INSTANCE);
        }
        return fs;
    }

    public static boolean isFluidContainerFull(ItemStack stack) {
        return FluidUtil.getFluidHandler((ItemStack)stack).map(handler -> {
            for (int t = 0; t < handler.getTanks(); ++t) {
                if (handler.getFluidInTank(t).getAmount() >= handler.getTankCapacity(t)) continue;
                return false;
            }
            return true;
        }).orElse(true);
    }

    public static ItemStack fillFluidContainer(IFluidHandler handler, ItemStack containerIn, ItemStack containerOut, @Nullable Player player) {
        if (containerIn == null || containerIn.isEmpty()) {
            return ItemStack.EMPTY;
        }
        FluidActionResult result = FluidUtil.tryFillContainer((ItemStack)containerIn, (IFluidHandler)handler, (int)Integer.MAX_VALUE, (Player)player, (boolean)false);
        if (result.isSuccess()) {
            ItemStack full = result.getResult();
            if (containerOut.isEmpty() || containerOut.isStackable() && containerOut.getCount() < containerOut.getMaxStackSize()) {
                if (!containerOut.isEmpty() && containerOut.getCount() + full.getCount() > containerOut.getMaxStackSize()) {
                    return ItemStack.EMPTY;
                }
                result = FluidUtil.tryFillContainer((ItemStack)containerIn, (IFluidHandler)handler, (int)Integer.MAX_VALUE, (Player)player, (boolean)true);
                if (result.isSuccess()) {
                    return result.getResult();
                }
            }
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack fillFluidContainer(IFluidTank tank, FluidStack fluid, ItemStack containerIn, ItemStack containerOut) {
        if (containerIn == null || containerIn.isEmpty()) {
            return ItemStack.EMPTY;
        }
        FluidActionResult result = FluidHelper.tryFillContainer(tank, fluid, containerIn, false);
        if (result.isSuccess()) {
            ItemStack full = result.getResult();
            if (containerOut.isEmpty() || full.isStackable() && full.getCount() < full.getMaxStackSize()) {
                if (!containerOut.isEmpty() && containerOut.getCount() + full.getCount() > containerOut.getMaxStackSize()) {
                    return ItemStack.EMPTY;
                }
                result = FluidHelper.tryFillContainer(tank, fluid, containerIn, true);
                if (result.isSuccess()) {
                    return result.getResult();
                }
            }
        }
        return ItemStack.EMPTY;
    }

    static FluidActionResult tryFillContainer(IFluidTank tank, FluidStack fluidSource, @Nonnull ItemStack container, boolean doFill) {
        ItemStack containerCopy = container.copyWithCount(1);
        return FluidUtil.getFluidHandler((ItemStack)containerCopy).map(containerFluidHandler -> {
            int fillableAmount = containerFluidHandler.fill(fluidSource, IFluidHandler.FluidAction.SIMULATE);
            if (fillableAmount > 0) {
                if (doFill) {
                    FluidStack fs = new FluidStack(fluidSource.getFluid(), Math.min(fluidSource.getAmount(), fillableAmount));
                    containerFluidHandler.fill(fs, IFluidHandler.FluidAction.EXECUTE);
                    tank.drain(fs, IFluidHandler.FluidAction.EXECUTE);
                }
                ItemStack resultContainer = containerFluidHandler.getContainer();
                return new FluidActionResult(resultContainer);
            }
            return FluidActionResult.FAILURE;
        }).orElse(FluidActionResult.FAILURE);
    }

    public static ItemStack tryDrainContainer(@Nonnull ItemStack stack, @Nonnull IFluidTank source) {
        FluidStack fs;
        int amount;
        ItemStack emptyContainer = ItemStack.EMPTY;
        IFluidHandlerItem capability = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
        if (capability != null && (amount = Math.min(source.getCapacity() - source.getFluidAmount(), 1000)) > 0 && (amount = capability.drain((fs = capability.getFluidInTank(0)).copyWithAmount(Math.min(fs.getAmount(), amount)), IFluidHandler.FluidAction.SIMULATE).getAmount()) > 0) {
            FluidStack fluidStack = fs.copyWithAmount(amount);
            source.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
            capability.drain(fluidStack, IFluidHandler.FluidAction.EXECUTE);
            if (capability.getFluidInTank(0).isEmpty() && stack.getItem() instanceof BucketItem) {
                emptyContainer = new ItemStack((ItemLike)Items.BUCKET, 1);
            }
        }
        return emptyContainer;
    }

    private FluidHelper() {
    }
}

