/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.sound;

import flaxbeard.immersivepetroleum.client.utils.MCUtil;
import flaxbeard.immersivepetroleum.common.sound.IPTickableSound;
import flaxbeard.immersivepetroleum.common.sound.IPlaySound;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class IPWorldSound
extends IPTickableSound {
    private final BlockPos pos;
    private final double x;
    private final double y;
    private final double z;

    public IPWorldSound(BlockPos pos, SoundEvent event, float volume, float pitch) {
        super(event, volume, pitch);
        this.pos = pos;
        this.x = (double)pos.getX() + 0.5;
        this.y = (double)pos.getY() + 0.5;
        this.z = (double)pos.getZ() + 0.5;
    }

    public void tick() {
        BlockEntity blockEntity = MCUtil.getLevel().getBlockEntity(this.pos);
        if (blockEntity instanceof IPlaySound) {
            IPlaySound soundPlayer = (IPlaySound)blockEntity;
            this.stop = soundPlayer.stopSound(this.getLocation());
            if (!this.stop && MCUtil.getPlayer() != null) {
                float soundRadiusSqr = soundPlayer.soundRadiusSqr();
                double distancedSqr = MCUtil.getPlayer().distanceToSqr(Vec3.atCenterOf((Vec3i)this.pos));
                if (distancedSqr > (double)soundRadiusSqr) {
                    this.stop = true;
                }
            }
        } else {
            this.stop = true;
        }
    }

    public boolean isLooping() {
        return true;
    }

    public boolean isRelative() {
        return false;
    }

    @Nonnull
    public SoundSource getSource() {
        return SoundSource.BLOCKS;
    }

    @Override
    @Nonnull
    public SoundInstance.Attenuation getAttenuation() {
        return SoundInstance.Attenuation.LINEAR;
    }

    public BlockPos getPosition() {
        return this.pos;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }
}

