/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.sound;

import javax.annotation.Nonnull;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.client.sounds.WeighedSoundEvents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.Nullable;

public abstract class IPTickableSound
implements TickableSoundInstance {
    protected static final RandomSource RANDOM_SOURCE = RandomSource.create();
    protected final ResourceLocation soundRL;
    protected final float volume;
    protected final float pitch;
    protected boolean stop = false;
    private Sound sound;

    protected IPTickableSound(SoundEvent event, float volume, float pitch) {
        this.soundRL = event.getLocation();
        this.volume = volume;
        this.pitch = pitch;
    }

    public void stop() {
        this.stop = true;
    }

    public boolean isStopped() {
        return this.stop;
    }

    @Nonnull
    public ResourceLocation getLocation() {
        return this.soundRL;
    }

    @Nullable
    public WeighedSoundEvents resolve(SoundManager soundManager) {
        WeighedSoundEvents soundEvent = soundManager.getSoundEvent(this.soundRL);
        this.sound = soundEvent != null ? soundEvent.getSound(RANDOM_SOURCE) : SoundManager.EMPTY_SOUND;
        return soundEvent;
    }

    @Nonnull
    public Sound getSound() {
        return this.sound;
    }

    public int getDelay() {
        return 0;
    }

    public float getVolume() {
        return this.volume;
    }

    public float getPitch() {
        return this.pitch;
    }

    @Nonnull
    public SoundInstance.Attenuation getAttenuation() {
        return SoundInstance.Attenuation.NONE;
    }
}

