/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.network;

import flaxbeard.immersivepetroleum.api.reservoir.Reservoir;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirHandler;
import flaxbeard.immersivepetroleum.client.gui.SeismicSurveyScreen;
import flaxbeard.immersivepetroleum.client.utils.MCUtil;
import flaxbeard.immersivepetroleum.common.network.INetMessage;
import flaxbeard.immersivepetroleum.common.network.IPPacketHandler;
import flaxbeard.immersivepetroleum.common.util.survey.SurveyScan;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class MessageSurveyResultDetails {
    public static void sendRequestToServer(SurveyScan scan) {
        IPPacketHandler.sendToServer(new ClientToServer(scan));
    }

    private static void sendReply(Player player, UUID scanId, BitSet replyBitSet) {
        IPPacketHandler.sendToPlayer(player, new ServerToClient(scanId, replyBitSet));
    }

    public static class ClientToServer
    implements INetMessage {
        public static final CustomPacketPayload.Type<ClientToServer> ID = INetMessage.createType("survey_client_to_server");
        public static final StreamCodec<ByteBuf, ClientToServer> CODEC = ByteBufCodecs.COMPOUND_TAG.map(ClientToServer::new, ClientToServer::toTag);
        private final int x;
        private final int z;
        private final UUID scanId;

        public ClientToServer(SurveyScan scan) {
            this.x = scan.x();
            this.z = scan.z();
            this.scanId = scan.uuid();
        }

        private ClientToServer(CompoundTag tag) {
            this.x = tag.getInt("x");
            this.z = tag.getInt("z");
            this.scanId = tag.getUUID("scanId");
        }

        private CompoundTag toTag() {
            CompoundTag tag = new CompoundTag();
            tag.putInt("x", this.x);
            tag.putInt("z", this.z);
            tag.putUUID("scanId", this.scanId);
            return tag;
        }

        @Nonnull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return ID;
        }

        @Override
        public void process(IPayloadContext context) {
            if (context.connection().getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                return;
            }
            context.enqueueWork(() -> {
                ServerPlayer sPlayer = (ServerPlayer)Objects.requireNonNull(context.player());
                ServerLevel sLevel = sPlayer.serverLevel();
                if (sLevel.isAreaLoaded(new BlockPos(this.x, 0, this.z), 32)) {
                    BitSet set = this.compileBitSet((Level)sLevel);
                    MessageSurveyResultDetails.sendReply((Player)sPlayer, this.scanId, set);
                }
            });
        }

        private BitSet compileBitSet(Level level) {
            ArrayList<Reservoir> islandCache = new ArrayList<Reservoir>();
            BitSet set = new BitSet(4225);
            int r = 32;
            int j = -32;
            int a = 0;
            while (j <= 32) {
                int i = -32;
                int b = 0;
                while (i <= 32) {
                    int x = this.x - i;
                    int z = this.z - j;
                    double current = ReservoirHandler.getValueOf(level, x, z);
                    if (current != -1.0) {
                        Optional<Reservoir> optional = islandCache.stream().filter(res -> res.getPolygon().contains(x, z)).findFirst();
                        Reservoir nearbyIsland = optional.orElse(null);
                        if (nearbyIsland == null && (nearbyIsland = ReservoirHandler.getReservoirNoCache(level, new ColumnPos(x, z))) != null) {
                            islandCache.add(nearbyIsland);
                        }
                        if (nearbyIsland != null) {
                            set.set(a * 65 + b);
                        }
                    }
                    ++i;
                    ++b;
                }
                ++j;
                ++a;
            }
            return set;
        }
    }

    public static class ServerToClient
    implements INetMessage {
        public static final CustomPacketPayload.Type<ServerToClient> ID = INetMessage.createType("survey_server_to_client");
        public static final StreamCodec<ByteBuf, ServerToClient> CODEC = ByteBufCodecs.COMPOUND_TAG.map(ServerToClient::new, ServerToClient::toTag);
        private final BitSet replyBitSet;
        private final UUID scanId;

        public ServerToClient(UUID scanId, BitSet replyBitSet) {
            this.scanId = scanId;
            this.replyBitSet = replyBitSet;
        }

        private ServerToClient(CompoundTag tag) {
            this(tag.getUUID("scanId"), BitSet.valueOf(tag.getByteArray("bitset")));
        }

        private CompoundTag toTag() {
            CompoundTag tag = new CompoundTag();
            tag.putByteArray("bitset", this.replyBitSet.toByteArray());
            tag.putUUID("scanId", this.scanId);
            return tag;
        }

        @Nonnull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return ID;
        }

        @Override
        public void process(IPayloadContext context) {
            if (context.connection().getDirection().getReceptionSide() == LogicalSide.SERVER) {
                return;
            }
            context.enqueueWork(() -> {
                Screen patt0$temp = MCUtil.getScreen();
                if (patt0$temp instanceof SeismicSurveyScreen) {
                    SeismicSurveyScreen surveyScreen = (SeismicSurveyScreen)patt0$temp;
                    if (this.scanId.equals(surveyScreen.scan.uuid())) {
                        surveyScreen.setBitSet(this.replyBitSet);
                    }
                }
            });
        }
    }
}

