/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.lubehandlers;

import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelperMaster;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockBE;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.CrusherLogic;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import flaxbeard.immersivepetroleum.api.crafting.LubricatedHandler;
import flaxbeard.immersivepetroleum.client.model.IPModel;
import flaxbeard.immersivepetroleum.client.model.IPModels;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.AutoLubricatorTileEntity;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import java.util.function.Supplier;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class CrusherLubricationHandler
implements LubricatedHandler.ILubricationHandler<IMultiblockBEHelperMaster<CrusherLogic.State>, CrusherLogic.State> {
    private static final BlockPos RELATIVE_GHOST_POS = new BlockPos(2, 0, -1);
    private static final ResourceLocation TEXTURE = ResourceUtils.ip("textures/models/lube_pipe.png");
    private static Supplier<IPModel> pipes;

    @Override
    public boolean isPlacedCorrectly(Level world, BlockPos lubricatorPosition, Direction lubricatorFacing) {
        IMultiblockLevel level;
        IMultiblockBE mb;
        BlockPos target = lubricatorPosition.relative(lubricatorFacing);
        BlockEntity blockEntity = world.getBlockEntity(target);
        if (blockEntity instanceof IMultiblockBE && (mb = (IMultiblockBE)blockEntity).getHelper().getContext() != null && (level = mb.getHelper().getContext().getLevel()).toRelative(lubricatorPosition).equals((Object)RELATIVE_GHOST_POS)) {
            return level.getOrientation().front().getOpposite() == lubricatorFacing;
        }
        return false;
    }

    @Override
    public LubricatedHandler.ILubricationHandler.GhostInfo getGhostBlockPosition(Level world, IMultiblockBEHelperMaster<CrusherLogic.State> mbte) {
        IMultiblockLevel level = mbte.getContext().getLevel();
        BlockPos position = level.toAbsolute(RELATIVE_GHOST_POS);
        Direction facing = level.getOrientation().front().getOpposite();
        return new LubricatedHandler.ILubricationHandler.GhostInfo(position, facing);
    }

    @Override
    public boolean isMachineEnabled(Level world, IMultiblockBEHelperMaster<CrusherLogic.State> mbte) {
        return ((CrusherLogic.State)mbte.getState()).shouldRenderActive();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void lubricateClient(ClientLevel world, Fluid lubricant, int ticks, IMultiblockBEHelperMaster<CrusherLogic.State> mbte) {
    }

    @Override
    public void lubricateServer(ServerLevel world, Fluid lubricant, int ticks, IMultiblockBEHelperMaster<CrusherLogic.State> mbte) {
        if (ticks % 4 == 0) {
            IServerTickableComponent tick = (IServerTickableComponent)mbte.getMultiblock().logic();
            tick.tickServer(mbte.getContext());
        }
    }

    @Override
    public void spawnLubricantParticles(ClientLevel world, BlockPos lubricatorPosition, Direction facing, IMultiblockBEHelperMaster<CrusherLogic.State> mbte) {
        boolean mirrored = mbte.getContext().getLevel().getOrientation().mirrored();
        Direction f = mirrored ? facing : facing.getOpposite();
        float location = world.random.nextFloat();
        boolean flip = f.getAxis() == Direction.Axis.Z ^ facing.getAxisDirection() == Direction.AxisDirection.NEGATIVE ^ !mirrored;
        float xO = 2.5f;
        float zO = -0.1f;
        float yO = 1.3f;
        if (location > 0.5f) {
            xO = 1.0f;
            yO = 3.0f;
            zO = 1.65f;
        }
        if (facing.getAxisDirection() == Direction.AxisDirection.NEGATIVE) {
            xO = -xO + 1.0f;
        }
        if (!flip) {
            zO = -zO + 1.0f;
        }
        float x = (float)lubricatorPosition.getX() + (f.getAxis() == Direction.Axis.X ? xO : zO);
        float y = (float)lubricatorPosition.getY() + yO;
        float z = (float)lubricatorPosition.getZ() + (f.getAxis() == Direction.Axis.X ? zO : xO);
        for (int i = 0; i < 3; ++i) {
            float r1 = (world.random.nextFloat() - 0.5f) * 2.0f;
            float r2 = (world.random.nextFloat() - 0.5f) * 2.0f;
            float r3 = world.random.nextFloat();
            world.addParticle((ParticleOptions)ParticleTypes.FALLING_HONEY, (double)x, (double)y, (double)z, (double)(r1 * 0.04f), (double)(r3 * 0.0125f), (double)(r2 * 0.025f));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderPipes(AutoLubricatorTileEntity lubricator, IMultiblockBEHelperMaster<CrusherLogic.State> mbte, PoseStack matrix, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        IPModel model;
        Direction rotation = mbte.getContext().getLevel().getOrientation().front();
        if (rotation == Direction.NORTH) {
            matrix.mulPose(Axis.YP.rotationDegrees(90.0f));
            matrix.translate(-3.0f, 0.0f, 0.0f);
        } else if (rotation == Direction.SOUTH) {
            matrix.mulPose(Axis.YP.rotationDegrees(270.0f));
            matrix.translate(-2.0f, 0.0f, -1.0f);
        } else if (rotation == Direction.EAST) {
            matrix.mulPose(Axis.YP.rotationDegrees(0.0f));
            matrix.translate(-2.0f, 0.0f, 0.0f);
        } else if (rotation == Direction.WEST) {
            matrix.mulPose(Axis.YP.rotationDegrees(180.0f));
            matrix.translate(-3.0f, 0.0f, -1.0f);
        }
        if (pipes == null) {
            pipes = IPModels.getSupplier("crusher_lubepipes");
        }
        if ((model = pipes.get()) != null) {
            model.renderToBuffer(matrix, buffer.getBuffer(model.renderType(TEXTURE)), combinedLight, combinedOverlay);
        }
    }
}

