/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.items;

import flaxbeard.immersivepetroleum.client.gui.SeismicSurveyScreen;
import flaxbeard.immersivepetroleum.client.utils.MCUtil;
import flaxbeard.immersivepetroleum.common.items.IPItemBase;
import flaxbeard.immersivepetroleum.common.util.survey.ISurveyInfo;
import flaxbeard.immersivepetroleum.common.util.survey.ReservoirInfo;
import flaxbeard.immersivepetroleum.common.util.survey.SurveyScan;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;

public class SurveyResultItem
extends IPItemBase {
    public SurveyResultItem() {
        super(new Item.Properties().stacksTo(1));
    }

    @Override
    public boolean addSelfToCreativeTab() {
        return false;
    }

    @Nonnull
    public Component getName(@Nonnull ItemStack stack) {
        String selfKey = this.getDescriptionId(stack);
        return Component.translatable((String)selfKey).withStyle(ChatFormatting.GOLD);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, @Nonnull InteractionHand pUsedHand) {
        ISurveyInfo iSurveyInfo;
        ItemStack held = pPlayer.getItemInHand(pUsedHand);
        if (pLevel.isClientSide && (iSurveyInfo = ISurveyInfo.from(held)) instanceof SurveyScan) {
            SurveyScan scan = (SurveyScan)iSurveyInfo;
            if (scan.uuid() == null) {
                pPlayer.displayClientMessage((Component)Component.literal((String)"This survey is faulty. (Destroy me!)").withStyle(ChatFormatting.RED), true);
                return InteractionResultHolder.fail((Object)held);
            }
            SurveyResultItem.openGUI(pLevel, scan);
            return InteractionResultHolder.success((Object)held);
        }
        return InteractionResultHolder.pass((Object)held);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void openGUI(Level level, @Nonnull SurveyScan scan) {
        MCUtil.setScreen(new SeismicSurveyScreen(level, scan));
    }

    public void appendHoverText(@Nonnull ItemStack stack, @Nonnull Item.TooltipContext ctx, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        ISurveyInfo info = ISurveyInfo.from(stack);
        if (info instanceof SurveyScan) {
            SurveyScan scan = (SurveyScan)info;
            if (scan.uuid() == null) {
                tooltip.add((Component)Component.literal((String)"SORRY, IM FAULTY!").withStyle(ChatFormatting.RED));
                tooltip.add((Component)Component.literal((String)"YOU'LL HAVE TO TOSS ME!").withStyle(ChatFormatting.RED));
                return;
            }
            tooltip.add((Component)Component.translatable((String)"desc.immersivepetroleum.flavour.surveytool.rightclickme"));
            if (flag == TooltipFlag.Default.ADVANCED) {
                tooltip.add((Component)Component.literal((String)("ID: " + String.valueOf(scan.uuid()))));
                tooltip.add((Component)Component.literal((String)("dSize: " + String.valueOf(scan.data() != null ? Integer.valueOf(scan.data().length) : "Null"))));
            }
        }
        if (info instanceof ReservoirInfo) {
            ReservoirInfo reservoirInfo = (ReservoirInfo)info;
            int expected = reservoirInfo.expected();
            long amount = reservoirInfo.amount();
            byte percentage = reservoirInfo.percentage();
            FluidStack fs = reservoirInfo.fluidStack();
            if (fs == FluidStack.EMPTY) {
                tooltip.add((Component)Component.literal((String)"SORRY, IM FAULTY!").withStyle(ChatFormatting.RED));
                tooltip.add((Component)Component.literal((String)"YOU'LL HAVE TO TOSS ME!").withStyle(ChatFormatting.RED));
                return;
            }
            tooltip.add((Component)Component.translatable((String)fs.getDescriptionId()).withStyle(ChatFormatting.DARK_GRAY));
            tooltip.add((Component)Component.translatable((String)"desc.immersivepetroleum.info.survey_result.amount", (Object[])new Object[]{String.format(Locale.ENGLISH, "%,.3f", (double)amount / 1000.0), percentage}).withStyle(ChatFormatting.DARK_GRAY));
            tooltip.add((Component)Component.translatable((String)"desc.immersivepetroleum.info.survey_result.expected", (Object[])new Object[]{expected}).withStyle(ChatFormatting.DARK_GRAY));
        }
        if (info != null) {
            int x = info.getX();
            int z = info.getZ();
            tooltip.add((Component)Component.translatable((String)"desc.immersivepetroleum.flavour.surveytool.location", (Object[])new Object[]{x, z}).withStyle(ChatFormatting.DARK_GRAY));
        }
    }
}

