/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.items;

import blusunrize.immersiveengineering.api.tool.upgrade.IUpgradeableTool;
import blusunrize.immersiveengineering.api.tool.upgrade.UpgradeData;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import flaxbeard.immersivepetroleum.api.event.ProjectorEvent;
import flaxbeard.immersivepetroleum.client.IPShaders;
import flaxbeard.immersivepetroleum.client.gui.ProjectorScreen;
import flaxbeard.immersivepetroleum.client.render.IPRenderTypes;
import flaxbeard.immersivepetroleum.client.utils.MCUtil;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.IPDataComponents;
import flaxbeard.immersivepetroleum.common.IPKeyBinds;
import flaxbeard.immersivepetroleum.common.items.IPItemBase;
import flaxbeard.immersivepetroleum.common.util.projector.MultiblockProjection;
import flaxbeard.immersivepetroleum.common.util.projector.Settings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.items.IItemHandler;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.glfw.GLFW;

public class ProjectorItem
extends IPItemBase
implements IUpgradeableTool {
    private static final Slot[] NONE = new Slot[0];

    public ProjectorItem() {
        super(new Item.Properties().stacksTo(1));
    }

    @Nonnull
    public Component getName(@Nonnull ItemStack stack) {
        Settings settings;
        String selfKey = this.getDescriptionId(stack);
        if (stack.has(IPDataComponents.PROJECTOR_SETTINGS) && (settings = ProjectorItem.getSettings(stack)).getMultiblock() != null) {
            Component name = settings.getMultiblock().getDisplayName();
            return Component.translatable((String)(selfKey + ".specific"), (Object[])new Object[]{name}).withStyle(ChatFormatting.GOLD);
        }
        return Component.translatable((String)selfKey).withStyle(ChatFormatting.GOLD);
    }

    public void appendHoverText(@Nonnull ItemStack stack, @Nonnull Item.TooltipContext ctx, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        Settings settings = ProjectorItem.getSettings(stack);
        Level level = ctx.level();
        if (settings.getMultiblock() != null && level != null) {
            MutableComponent text;
            MutableComponent title;
            Vec3i size = settings.getMultiblock().getSize(level);
            tooltip.add((Component)Component.translatable((String)"desc.immersivepetroleum.info.projector.build0"));
            tooltip.add((Component)Component.translatable((String)"desc.immersivepetroleum.info.projector.build1", (Object[])new Object[]{settings.getMultiblock().getDisplayName()}));
            if (this.isPressing(340) || this.isPressing(344)) {
                title = Component.translatable((String)"desc.immersivepetroleum.info.projector.holdshift.text").withStyle(ChatFormatting.DARK_AQUA);
                tooltip.add((Component)title);
                MutableComponent mbSize = Component.translatable((String)"desc.immersivepetroleum.info.projector.size", (Object[])new Object[]{size.getX(), size.getY(), size.getZ()}).withStyle(ChatFormatting.DARK_GRAY);
                tooltip.add(this.indent((Component)mbSize));
                Direction dir = Direction.from2DDataValue((int)settings.getRotation().ordinal());
                MutableComponent rotation = Component.translatable((String)("desc.immersivepetroleum.info.projector.rotated." + String.valueOf(dir))).withStyle(ChatFormatting.DARK_GRAY);
                MutableComponent flip = settings.isMirrored() ? Component.translatable((String)"desc.immersivepetroleum.info.projector.flipped.true").withStyle(ChatFormatting.DARK_GRAY) : Component.translatable((String)"desc.immersivepetroleum.info.projector.flipped.false").withStyle(ChatFormatting.DARK_GRAY);
                if (settings.getPos() != null) {
                    int x = settings.getPos().getX();
                    int y = settings.getPos().getY();
                    int z = settings.getPos().getZ();
                    MutableComponent centerText = Component.translatable((String)"desc.immersivepetroleum.info.projector.center", (Object[])new Object[]{x, y, z}).withStyle(ChatFormatting.DARK_GRAY);
                    tooltip.add(this.indent((Component)centerText));
                }
                tooltip.add(this.indent((Component)rotation));
                tooltip.add(this.indent((Component)flip));
            } else {
                text = Component.literal((String)"[").append((Component)Component.translatable((String)"desc.immersivepetroleum.info.projector.holdshift")).append("] ").append((Component)Component.translatable((String)"desc.immersivepetroleum.info.projector.holdshift.text")).withStyle(ChatFormatting.DARK_AQUA);
                tooltip.add((Component)text);
            }
            if (this.isPressing(341) || this.isPressing(345)) {
                title = Component.translatable((String)"desc.immersivepetroleum.info.projector.holdctrl.text").withStyle(ChatFormatting.DARK_PURPLE);
                MutableComponent ctrl0 = Component.translatable((String)"desc.immersivepetroleum.info.projector.control1").withStyle(ChatFormatting.DARK_GRAY);
                MutableComponent ctrl1 = Component.translatable((String)"desc.immersivepetroleum.info.projector.control2", (Object[])new Object[]{IPKeyBinds.keybind_preview_flip.getTranslatedKeyMessage()}).withStyle(ChatFormatting.DARK_GRAY);
                MutableComponent ctrl2 = Component.translatable((String)"desc.immersivepetroleum.info.projector.control3").withStyle(ChatFormatting.DARK_GRAY);
                tooltip.add((Component)title);
                tooltip.add(this.indent((Component)ctrl0));
                tooltip.add(this.indent((Component)ctrl1));
                tooltip.add(this.indent((Component)ctrl2));
            } else {
                text = Component.literal((String)"[").append((Component)Component.translatable((String)"desc.immersivepetroleum.info.projector.holdctrl")).append("] ").append((Component)Component.translatable((String)"desc.immersivepetroleum.info.projector.holdctrl.text")).withStyle(ChatFormatting.DARK_PURPLE);
                tooltip.add((Component)text);
            }
        } else {
            tooltip.add((Component)Component.translatable((String)"desc.immersivepetroleum.info.projector.noMultiblock"));
        }
    }

    private Component indent(Component text) {
        return Component.literal((String)"  ").append(text);
    }

    @OnlyIn(value=Dist.CLIENT)
    private boolean isPressing(int key) {
        long window = Minecraft.getInstance().getWindow().getWindow();
        return GLFW.glfwGetKey((long)window, (int)key) == 1;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack held = player.getItemInHand(hand);
        if (world.isClientSide) {
            boolean changeMode = false;
            Settings settings = ProjectorItem.getSettings(held);
            switch (settings.getMode()) {
                case PROJECTION: {
                    if (!player.isShiftKeyDown()) break;
                    if (settings.getPos() != null) {
                        settings.setPos(null);
                        settings.sendPacketToServer(hand);
                        break;
                    }
                    changeMode = true;
                    break;
                }
                case MULTIBLOCK_SELECTION: {
                    if (!player.isShiftKeyDown()) {
                        ProjectorItem.openGUI(hand, held);
                        break;
                    }
                    changeMode = true;
                    break;
                }
            }
            if (changeMode) {
                settings.switchMode();
                settings.applyTo(held);
                settings.sendPacketToServer(hand);
                player.displayClientMessage(settings.getMode().getTranslated(), true);
            }
        }
        return InteractionResultHolder.success((Object)held);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void openGUI(InteractionHand hand, ItemStack held) {
        MCUtil.setScreen(new ProjectorScreen(hand, held));
    }

    @Nonnull
    public InteractionResult useOn(UseOnContext context) {
        if (context.getPlayer() == null) {
            return InteractionResult.PASS;
        }
        Level world = context.getLevel();
        Player playerIn = context.getPlayer();
        InteractionHand hand = context.getHand();
        BlockPos pos = context.getClickedPos();
        Direction facing = context.getClickedFace();
        ItemStack stack = playerIn.getItemInHand(hand);
        Settings settings = ProjectorItem.getSettings(stack);
        if (playerIn.isShiftKeyDown() && settings.getPos() != null) {
            if (world.isClientSide) {
                settings.setPos(null);
                settings.applyTo(stack);
                settings.sendPacketToServer(hand);
            }
            return InteractionResult.SUCCESS;
        }
        if (settings.getMode() == Settings.Mode.PROJECTION && settings.getPos() == null && settings.getMultiblock() != null) {
            BlockState state = world.getBlockState(pos);
            BlockPos.MutableBlockPos hit = pos.mutable();
            if (!state.is(BlockTags.REPLACEABLE) && facing == Direction.UP) {
                hit.setWithOffset((Vec3i)hit, 0, 1, 0);
            }
            Vec3i size = settings.getMultiblock().getSize(world);
            ProjectorItem.alignHit(hit, playerIn, size, settings.getRotation(), settings.isMirrored());
            if (playerIn.isShiftKeyDown() && playerIn.isCreative()) {
                if (!world.isClientSide) {
                    if (settings.getMultiblock().getUniqueName().getPath().contains("excavator_demo") || settings.getMultiblock().getUniqueName().getPath().contains("bucket_wheel")) {
                        hit.setWithOffset((Vec3i)hit, 0, -2, 0);
                    }
                    BiPredicate<Integer, MultiblockProjection.Info> pred = (layer, info) -> {
                        BlockState tstate1;
                        BlockPos realPos = info.tPos.offset((Vec3i)hit);
                        BlockState tstate0 = info.getModifiedState(world, realPos);
                        ProjectorEvent.PlaceBlock event = new ProjectorEvent.PlaceBlock(info.multiblock, info.templateWorld, info.tBlockInfo.pos(), world, realPos, tstate0, settings.getRotation());
                        if (NeoForge.EVENT_BUS.post((Event)event) != null && world.setBlockAndUpdate(realPos, tstate1 = event.getState())) {
                            ProjectorEvent.PlaceBlockPost postEvent = new ProjectorEvent.PlaceBlockPost(info.multiblock, info.templateWorld, event.getTemplatePos(), world, realPos, tstate1, settings.getRotation());
                            NeoForge.EVENT_BUS.post((Event)postEvent);
                        }
                        return false;
                    };
                    MultiblockProjection projection = new MultiblockProjection(world, settings.getMultiblock());
                    projection.setFlip(settings.isMirrored());
                    projection.setRotation(settings.getRotation());
                    projection.processAll(pred);
                }
                return InteractionResult.SUCCESS;
            }
            if (world.isClientSide) {
                settings.setPos((BlockPos)hit);
                settings.applyTo(stack);
                settings.sendPacketToServer(hand);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static Settings getSettings(@Nullable ItemStack stack) {
        Settings.SettingsRecord settings;
        if (stack == null || (settings = (Settings.SettingsRecord)stack.get(IPDataComponents.PROJECTOR_SETTINGS)) == null) {
            return new Settings();
        }
        return settings.convert();
    }

    private static void alignHit(BlockPos.MutableBlockPos hit, Player playerIn, Vec3i size, Rotation rotation, boolean mirror) {
        int x = (rotation.ordinal() % 2 == 0 ? size.getX() : size.getZ()) / 2;
        int z = (rotation.ordinal() % 2 == 0 ? size.getZ() : size.getX()) / 2;
        Direction facing = playerIn.getDirection();
        boolean xEven = size.getX() % 2 == 0;
        boolean zEven = size.getZ() % 2 == 0;
        switch (facing) {
            case NORTH: {
                hit.setWithOffset((Vec3i)hit, 0, 0, -z + (zEven ? 1 : 0));
                break;
            }
            case SOUTH: {
                hit.setWithOffset((Vec3i)hit, 0, 0, z);
                break;
            }
            case EAST: {
                hit.setWithOffset((Vec3i)hit, x, 0, 0);
                break;
            }
            case WEST: {
                hit.setWithOffset((Vec3i)hit, -x + (xEven ? 1 : 0), 0, 0);
                break;
            }
        }
    }

    public UpgradeData getUpgrades(ItemStack stack) {
        return UpgradeData.EMPTY;
    }

    public void clearUpgrades(ItemStack stack) {
    }

    public boolean canTakeFromWorkbench(ItemStack stack) {
        return true;
    }

    public boolean canModify(ItemStack stack) {
        return true;
    }

    public void recalculateUpgrades(ItemStack stack, Level w, Player player) {
    }

    public void removeFromWorkbench(Player player, ItemStack stack) {
    }

    public void finishUpgradeRecalculation(ItemStack stack, RegistryAccess registries) {
    }

    public Slot[] getWorkbenchSlots(AbstractContainerMenu container, ItemStack stack, Level level, Supplier<Player> getPlayer, IItemHandler toolInventory) {
        return NONE;
    }

    public static enum RenderLayer {
        ALL,
        BAD,
        PERFECT;

    }

    @OnlyIn(value=Dist.CLIENT)
    @EventBusSubscriber(modid="immersivepetroleum", value={Dist.CLIENT})
    public static class ClientInputHandler {
        static boolean shiftHeld = false;

        @SubscribeEvent
        public static void onPlayerTick(PlayerTickEvent.Post event) {
            if (event.getEntity() == Minecraft.getInstance().getCameraEntity() && !IPKeyBinds.keybind_preview_flip.isUnbound() && IPKeyBinds.keybind_preview_flip.consumeClick()) {
                ClientInputHandler.doAFlip();
            }
        }

        public static void onSneakScrolling(InputEvent.MouseScrollingEvent event, Player player, double scrollDelta) {
            boolean off;
            ItemStack mainItem = player.getMainHandItem();
            ItemStack secondItem = player.getOffhandItem();
            boolean main = mainItem.is((Item)IPContent.Items.PROJECTOR.get()) && mainItem.has(IPDataComponents.PROJECTOR_SETTINGS);
            boolean bl = off = secondItem.is((Item)IPContent.Items.PROJECTOR.get()) && secondItem.has(IPDataComponents.PROJECTOR_SETTINGS);
            if (main || off) {
                ItemStack target = main ? mainItem : secondItem;
                Settings settings = ProjectorItem.getSettings(target);
                if (scrollDelta > 0.0) {
                    settings.rotateCCW();
                } else {
                    settings.rotateCW();
                }
                settings.applyTo(target);
                settings.sendPacketToServer(main ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
                Direction facing = Direction.from2DDataValue((int)settings.getRotation().ordinal());
                player.displayClientMessage((Component)Component.translatable((String)("desc.immersivepetroleum.info.projector.rotated." + String.valueOf(facing))), true);
                event.setCanceled(true);
            }
        }

        private static void doAFlip() {
            ItemStack target;
            LocalPlayer player = MCUtil.getPlayer();
            ItemStack mainItem = player.getMainHandItem();
            ItemStack secondItem = player.getOffhandItem();
            boolean main = mainItem.is((Item)IPContent.Items.PROJECTOR.get()) && mainItem.has(IPDataComponents.PROJECTOR_SETTINGS);
            boolean off = secondItem.is((Item)IPContent.Items.PROJECTOR.get()) && secondItem.has(IPDataComponents.PROJECTOR_SETTINGS);
            ItemStack itemStack = target = main ? mainItem : secondItem;
            if (main || off) {
                Settings settings = ProjectorItem.getSettings(target);
                settings.flip();
                settings.applyTo(target);
                settings.sendPacketToServer(main ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
                MutableComponent flip = settings.isMirrored() ? Component.translatable((String)"desc.immersivepetroleum.info.projector.flipped.true") : Component.translatable((String)"desc.immersivepetroleum.info.projector.flipped.false");
                player.displayClientMessage((Component)flip, true);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @EventBusSubscriber(modid="immersivepetroleum", value={Dist.CLIENT})
    public static class ClientRenderHandler {
        static final int BYTE_BUFFER_SIZE = 0x100000;
        static final ByteBufferBuilder BUFFER_MAIN = new ByteBufferBuilder(0x100000);
        static final ByteBufferBuilder BUFFER_PHANTOM = new ByteBufferBuilder(0x100000);
        static final BlockPos.MutableBlockPos FULL_MAX = new BlockPos.MutableBlockPos(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);

        public static MultiBufferSource.BufferSource bufferSource_MAIN() {
            return MultiBufferSource.immediate((ByteBufferBuilder)BUFFER_MAIN);
        }

        public static MultiBufferSource.BufferSource bufferSource_PHANTOM() {
            return MultiBufferSource.immediate((ByteBufferBuilder)BUFFER_PHANTOM);
        }

        @SubscribeEvent
        public static void renderLevelStage(RenderLevelStageEvent event) {
            if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS) {
                ClientRenderHandler.renderProjection(event);
            }
        }

        private static void renderProjection(RenderLevelStageEvent event) {
            Minecraft mc = Minecraft.getInstance();
            if (mc.player != null) {
                PoseStack matrix = event.getPoseStack();
                matrix.pushPose();
                Vec3 renderView = MCUtil.getGameRenderer().getMainCamera().getPosition();
                matrix.translate(-renderView.x, -renderView.y, -renderView.z);
                ItemStack secondItem = mc.player.getOffhandItem();
                boolean off = secondItem.is((Item)IPContent.Items.PROJECTOR.get()) && secondItem.has(IPDataComponents.PROJECTOR_SETTINGS);
                for (int i = 0; i <= 10; ++i) {
                    ItemStack stack;
                    ItemStack itemStack = stack = i == 10 ? secondItem : mc.player.getInventory().getItem(i);
                    if (!stack.is((Item)IPContent.Items.PROJECTOR.get()) || !stack.has(IPDataComponents.PROJECTOR_SETTINGS)) continue;
                    Settings settings = ProjectorItem.getSettings(stack);
                    matrix.pushPose();
                    boolean renderMoving = i == mc.player.getInventory().selected || i == 10 && off;
                    ClientRenderHandler.renderSchematic(matrix, settings, (Player)mc.player, mc.player.level(), event.getPartialTick().getRealtimeDeltaTicks(), renderMoving);
                    matrix.popPose();
                }
                matrix.popPose();
            }
        }

        public static void renderSchematic(PoseStack matrix, Settings settings, Player player, Level world, float partialTicks, boolean renderMoving) {
            if (settings.getMultiblock() == null) {
                return;
            }
            Vec3i size = settings.getMultiblock().getSize(world);
            BlockPos.MutableBlockPos hit = new BlockPos.MutableBlockPos(FULL_MAX.getX(), FULL_MAX.getY(), FULL_MAX.getZ());
            MutableBoolean isPlaced = new MutableBoolean(false);
            if (settings.getPos() != null) {
                hit.set((Vec3i)settings.getPos());
                isPlaced.setTrue();
            } else if (renderMoving && MCUtil.getHitResult() != null && MCUtil.getHitResult().getType() == HitResult.Type.BLOCK) {
                BlockHitResult blockRTResult = (BlockHitResult)MCUtil.getHitResult();
                BlockPos pos = blockRTResult.getBlockPos();
                BlockState state = world.getBlockState(pos);
                if (state.is(BlockTags.REPLACEABLE) || blockRTResult.getDirection() != Direction.UP) {
                    hit.set((Vec3i)pos);
                } else {
                    hit.setWithOffset((Vec3i)pos, 0, 1, 0);
                }
                ProjectorItem.alignHit(hit, player, size, settings.getRotation(), settings.isMirrored());
            }
            if (!hit.equals((Object)FULL_MAX)) {
                ResourceLocation name = settings.getMultiblock().getUniqueName();
                if (name.getPath().contains("excavator_demo") || name.getPath().contains("bucket_wheel")) {
                    hit.setWithOffset((Vec3i)hit, 0, -2, 0);
                }
                MultiblockProjection projection = new MultiblockProjection(world, settings.getMultiblock());
                projection.setRotation(settings.getRotation());
                projection.setFlip(settings.isMirrored());
                ArrayList toRender = new ArrayList();
                MutableInt currentLayer = new MutableInt();
                MutableInt badBlocks = new MutableInt();
                MutableInt goodBlocks = new MutableInt();
                BiPredicate<Integer, MultiblockProjection.Info> bipred = (layer, info) -> {
                    if (badBlocks.getValue() == 0 && layer > currentLayer.getValue()) {
                        currentLayer.setValue((Number)layer);
                    } else if (!Objects.equals(layer, currentLayer.getValue())) {
                        return true;
                    }
                    if (isPlaced.booleanValue() && Objects.equals(layer, currentLayer.getValue())) {
                        BlockPos realPos = info.tPos.offset((Vec3i)hit);
                        BlockState toCompare = world.getBlockState(realPos);
                        BlockState tState = info.getModifiedState(world, realPos);
                        boolean skip = false;
                        if (tState == toCompare) {
                            toRender.add(Pair.of((Object)((Object)RenderLayer.PERFECT), (Object)info));
                            goodBlocks.increment();
                            skip = true;
                        } else if (!toCompare.isAir()) {
                            toRender.add(Pair.of((Object)((Object)RenderLayer.BAD), (Object)info));
                            skip = true;
                        } else {
                            badBlocks.increment();
                        }
                        if (skip) {
                            return false;
                        }
                    }
                    toRender.add(Pair.of((Object)((Object)RenderLayer.ALL), (Object)info));
                    return false;
                };
                projection.processAll(bipred);
                boolean perfect = goodBlocks.getValue().intValue() == projection.getBlockCount();
                BlockPos.MutableBlockPos min = new BlockPos.MutableBlockPos(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
                BlockPos.MutableBlockPos max = new BlockPos.MutableBlockPos(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
                float flicker = world.random.nextFloat() / 2.0f + 0.25f;
                matrix.translate((float)hit.getX(), (float)hit.getY(), (float)hit.getZ());
                toRender.sort((a, b) -> {
                    int bo;
                    int ao = ((RenderLayer)((Object)((Object)a.getLeft()))).ordinal();
                    if (ao > (bo = ((RenderLayer)((Object)((Object)b.getLeft()))).ordinal())) {
                        return 1;
                    }
                    if (ao < bo) {
                        return -1;
                    }
                    return 0;
                });
                MultiBufferSource.BufferSource mainBuffer = ClientRenderHandler.bufferSource_MAIN();
                ItemStack heldStack = player.getMainHandItem();
                for (Pair pair : toRender) {
                    MultiblockProjection.Info rInfo = (MultiblockProjection.Info)pair.getRight();
                    switch (((RenderLayer)((Object)pair.getLeft())).ordinal()) {
                        case 0: {
                            boolean held = heldStack.getItem() == rInfo.getRawState().getBlock().asItem();
                            float alpha = held ? 1.0f : 0.5f;
                            matrix.pushPose();
                            ClientRenderHandler.renderPhantom(matrix, world, rInfo, settings.isMirrored(), flicker, alpha, partialTicks);
                            if (held) {
                                ClientRenderHandler.renderCenteredOutlineBox((MultiBufferSource)mainBuffer, matrix, 0xAFAFAF, flicker);
                            }
                            matrix.popPose();
                            break;
                        }
                        case 1: {
                            matrix.pushPose();
                            matrix.translate((float)rInfo.tPos.getX(), (float)rInfo.tPos.getY(), (float)rInfo.tPos.getZ());
                            ClientRenderHandler.renderCenteredOutlineBox((MultiBufferSource)mainBuffer, matrix, 0xFF0000, flicker);
                            matrix.popPose();
                            break;
                        }
                        case 2: {
                            int x = rInfo.tPos.getX();
                            int y = rInfo.tPos.getY();
                            int z = rInfo.tPos.getZ();
                            min.set(Math.min(x, min.getX()), Math.min(y, min.getY()), Math.min(z, min.getZ()));
                            max.set(Math.max(x, max.getX()), Math.max(y, max.getY()), Math.max(z, max.getZ()));
                        }
                    }
                }
                if (perfect) {
                    matrix.pushPose();
                    ClientRenderHandler.renderOutlineBox((MultiBufferSource)mainBuffer, matrix, (Vec3i)min, (Vec3i)max, 48896, flicker);
                    matrix.popPose();
                    if (!player.getOffhandItem().isEmpty() && player.getOffhandItem().is((Item)IPContent.DEBUGITEM.get())) {
                        matrix.pushPose();
                        matrix.translate((float)min.getX(), (float)min.getY(), (float)min.getZ());
                        ClientRenderHandler.renderCenteredOutlineBox((MultiBufferSource)mainBuffer, matrix, 0xFF0000, flicker);
                        matrix.popPose();
                        matrix.pushPose();
                        matrix.translate((float)max.getX(), (float)max.getY(), (float)max.getZ());
                        ClientRenderHandler.renderCenteredOutlineBox((MultiBufferSource)mainBuffer, matrix, 65280, flicker);
                        matrix.popPose();
                        matrix.pushPose();
                        BlockPos center = min.immutable().offset((Vec3i)max);
                        matrix.translate((float)(center.getX() / 2), (float)(center.getY() / 2), (float)(center.getZ() / 2));
                        ClientRenderHandler.renderCenteredOutlineBox((MultiBufferSource)mainBuffer, matrix, 255, flicker);
                        matrix.popPose();
                    }
                }
                mainBuffer.endBatch();
            }
        }

        private static void renderPhantom(PoseStack matrix, Level realWorld, MultiblockProjection.Info rInfo, boolean mirror, float flicker, float alpha, float partialTicks) {
            BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
            ModelBlockRenderer blockRenderer = dispatcher.getModelRenderer();
            BlockColors blockColors = Minecraft.getInstance().getBlockColors();
            matrix.translate((float)rInfo.tPos.getX(), (float)rInfo.tPos.getY(), (float)rInfo.tPos.getZ());
            MultiBufferSource.BufferSource buffer = ClientRenderHandler.bufferSource_PHANTOM();
            BlockState state = rInfo.getModifiedState(realWorld, rInfo.tPos);
            ProjectorEvent.RenderBlock renderEvent = new ProjectorEvent.RenderBlock(rInfo.multiblock, rInfo.templateWorld, rInfo.tBlockInfo.pos(), realWorld, rInfo.tPos, state, rInfo.settings.getRotation());
            if (NeoForge.EVENT_BUS.post((Event)renderEvent) != null) {
                state = renderEvent.getState();
                state.updateNeighbourShapes((LevelAccessor)realWorld, rInfo.tPos, 3);
                ModelData modelData = ModelData.EMPTY;
                BlockEntity te = rInfo.templateWorld.getBlockEntity(rInfo.tBlockInfo.pos());
                if (te != null) {
                    te.setBlockState(state);
                    modelData = te.getModelData();
                }
                RenderShape blockrendertype = state.getRenderShape();
                switch (blockrendertype) {
                    case MODEL: {
                        BakedModel ibakedmodel = dispatcher.getBlockModel(state);
                        int i = blockColors.getColor(state, null, null, 0);
                        float red = (float)(i >> 16 & 0xFF) / 255.0f;
                        float green = (float)(i >> 8 & 0xFF) / 255.0f;
                        float blue = (float)(i & 0xFF) / 255.0f;
                        modelData = ibakedmodel.getModelData((BlockAndTintGetter)rInfo.templateWorld, rInfo.tBlockInfo.pos(), state, modelData);
                        IPShaders.projNoise(flicker * alpha, (float)MCUtil.getPlayer().tickCount + partialTicks);
                        RenderType renderType = IPRenderTypes.PROJECTION;
                        VertexConsumer vc = buffer.getBuffer(renderType);
                        blockRenderer.renderModel(matrix.last(), vc, state, ibakedmodel, red, green, blue, 0xF000F0, OverlayTexture.NO_OVERLAY, modelData, null);
                        break;
                    }
                    case ENTITYBLOCK_ANIMATED: {
                        ItemStack stack = new ItemStack((ItemLike)state.getBlock());
                        MCUtil.getItemRenderer().renderStatic(stack, ItemDisplayContext.NONE, 0xF000F0, OverlayTexture.NO_OVERLAY, matrix, (MultiBufferSource)buffer, realWorld, 0);
                        break;
                    }
                }
            }
            buffer.endBatch();
        }

        private static void renderOutlineBox(MultiBufferSource buffer, PoseStack matrix, Vec3i min, Vec3i max, int rgb, float flicker) {
            ClientRenderHandler.renderBox(buffer, matrix, Vec3.atLowerCornerOf((Vec3i)min), Vec3.atLowerCornerOf((Vec3i)max).add(1.0, 1.0, 1.0), rgb, flicker);
        }

        private static void renderBox(MultiBufferSource buffer, PoseStack matrix, Vec3 min, Vec3 max, int rgb, float flicker) {
            VertexConsumer builder = buffer.getBuffer(IPRenderTypes.TRANSLUCENT_LINE);
            float alpha = 0.25f + 0.5f * flicker;
            int rgba = rgb | (int)(alpha * 255.0f) << 24;
            ClientRenderHandler.line(builder, matrix, min, max, 2, 6, rgba);
            ClientRenderHandler.line(builder, matrix, min, max, 6, 7, rgba);
            ClientRenderHandler.line(builder, matrix, min, max, 7, 3, rgba);
            ClientRenderHandler.line(builder, matrix, min, max, 3, 2, rgba);
            ClientRenderHandler.line(builder, matrix, min, max, 2, 0, rgba);
            ClientRenderHandler.line(builder, matrix, min, max, 6, 4, rgba);
            ClientRenderHandler.line(builder, matrix, min, max, 3, 1, rgba);
            ClientRenderHandler.line(builder, matrix, min, max, 7, 5, rgba);
            ClientRenderHandler.line(builder, matrix, min, max, 0, 4, rgba);
            ClientRenderHandler.line(builder, matrix, min, max, 4, 5, rgba);
            ClientRenderHandler.line(builder, matrix, min, max, 5, 1, rgba);
            ClientRenderHandler.line(builder, matrix, min, max, 1, 0, rgba);
        }

        private static void renderCenteredOutlineBox(MultiBufferSource buffer, PoseStack matrix, int rgb, float flicker) {
            ClientRenderHandler.renderBox(buffer, matrix, Vec3.ZERO, new Vec3(1.0, 1.0, 1.0), rgb, flicker);
        }

        private static Vector3f combine(Vec3 start, Vec3 end, int mixBits) {
            float eps = 0.01f;
            return new Vector3f((float)((mixBits & 4) != 0 ? end.x + (double)0.01f : start.x - (double)0.01f), (float)((mixBits & 2) != 0 ? end.y + (double)0.01f : start.y - (double)0.01f), (float)((mixBits & 1) != 0 ? end.z + (double)0.01f : start.z - (double)0.01f));
        }

        private static void line(VertexConsumer out, PoseStack mat, Vec3 min, Vec3 max, int startBits, int endBits, int rgba) {
            Vector3f start = ClientRenderHandler.combine(min, max, startBits);
            Vector3f end = ClientRenderHandler.combine(min, max, endBits);
            Vector3f delta = new Vector3f((Vector3fc)end);
            delta.sub((Vector3fc)start);
            out.addVertex(mat.last().pose(), start.x(), start.y(), start.z()).setColor(rgba).setNormal(mat.last(), delta.x(), delta.y(), delta.z());
            out.addVertex(mat.last().pose(), end.x(), end.y(), end.z()).setColor(rgba).setNormal(mat.last(), delta.x(), delta.y(), delta.z());
        }
    }
}

