/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.items;

import blusunrize.immersiveengineering.api.tool.upgrade.IUpgrade;
import blusunrize.immersiveengineering.api.tool.upgrade.IUpgradeableTool;
import blusunrize.immersiveengineering.api.tool.upgrade.UpgradeData;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.register.IEDataComponents;
import flaxbeard.immersivepetroleum.ImmersivePetroleum;
import flaxbeard.immersivepetroleum.common.IPDataComponents;
import flaxbeard.immersivepetroleum.common.entity.MotorboatEntity;
import flaxbeard.immersivepetroleum.common.items.IPItemBase;
import flaxbeard.immersivepetroleum.common.util.IPItemStackContainerHandler;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public class MotorboatItem
extends IPItemBase
implements IUpgradeableTool {
    public static final int UPGRADE_SLOT_COUNT = 3;
    public static final String UPGRADE_TYPE = "MOTORBOAT";

    public MotorboatItem() {
        super(new Item.Properties().stacksTo(1));
    }

    public UpgradeData getUpgrades(ItemStack stack) {
        return (UpgradeData)stack.getOrDefault((Supplier)IEDataComponents.UPGRADE_DATA, (Object)UpgradeData.EMPTY);
    }

    public void clearUpgrades(ItemStack stack) {
        stack.remove((Supplier)IEDataComponents.UPGRADE_DATA);
    }

    protected NonNullList<ItemStack> getContainedItems(ItemStack stack) {
        IItemHandler handler = (IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM);
        if (handler == null) {
            ImmersivePetroleum.log.debug("No valid inventory handler found for " + String.valueOf(stack));
            return NonNullList.create();
        }
        if (handler instanceof IPItemStackContainerHandler) {
            IPItemStackContainerHandler ipStackHandler = (IPItemStackContainerHandler)handler;
            return ipStackHandler.getContainedItems();
        }
        ImmersivePetroleum.log.warn("Inefficiently getting contained items. Why does " + String.valueOf(stack) + " have a non-IP IItemHandler?");
        NonNullList inv = NonNullList.withSize((int)handler.getSlots(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < handler.getSlots(); ++i) {
            inv.set(i, (Object)handler.getStackInSlot(i));
        }
        return inv;
    }

    public boolean canTakeFromWorkbench(ItemStack stack) {
        return true;
    }

    public boolean canModify(ItemStack stack) {
        return true;
    }

    public void recalculateUpgrades(ItemStack stack, Level w, Player player) {
        if (w.isClientSide) {
            return;
        }
        this.clearUpgrades(stack);
        IItemHandler handler = (IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM);
        if (handler != null) {
            UpgradeData upgrades = UpgradeData.EMPTY;
            for (int i = 0; i < handler.getSlots(); ++i) {
                IUpgrade upg;
                Item item;
                ItemStack u = handler.getStackInSlot(i);
                if (u.isEmpty() || !((item = u.getItem()) instanceof IUpgrade) || !(upg = (IUpgrade)item).getUpgradeTypes(u).contains(UPGRADE_TYPE) || !upg.canApplyUpgrades(upgrades, u)) continue;
                upgrades = upg.applyUpgrades(upgrades, u);
            }
            stack.set((Supplier)IEDataComponents.UPGRADE_DATA, (Object)upgrades);
            this.finishUpgradeRecalculation(stack, w.registryAccess());
        }
    }

    public void removeFromWorkbench(Player player, ItemStack stack) {
    }

    public void finishUpgradeRecalculation(ItemStack stack, RegistryAccess registries) {
    }

    public Slot[] getWorkbenchSlots(AbstractContainerMenu container, ItemStack stack, Level level, Supplier<Player> getPlayer, IItemHandler inv) {
        if (inv != null) {
            return new Slot[]{new IESlot.Upgrades(container, inv, 0, 78, 30, UPGRADE_TYPE, stack, true, level, getPlayer), new IESlot.Upgrades(container, inv, 1, 98, 40, UPGRADE_TYPE, stack, true, level, getPlayer), new IESlot.Upgrades(container, inv, 2, 118, 30, UPGRADE_TYPE, stack, true, level, getPlayer)};
        }
        return new Slot[0];
    }

    @Nonnull
    public Component getName(@Nonnull ItemStack stack) {
        boolean hasUpgrades = this.getContainedItems(stack).stream().anyMatch(s -> s != ItemStack.EMPTY);
        Component c = super.getName(stack);
        if (hasUpgrades) {
            c = Component.translatable((String)"desc.immersivepetroleum.flavour.speedboat.prefix").append(c).withStyle(ChatFormatting.GOLD);
        }
        return c;
    }

    public void appendHoverText(@Nonnull ItemStack stack, @Nonnull Item.TooltipContext ctx, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        IItemHandler handler;
        IPDataComponents.TankData tankData = (IPDataComponents.TankData)stack.get(IPDataComponents.TANK_DATA);
        if (tankData != null && !tankData.fs().isEmpty()) {
            tooltip.add((Component)((MutableComponent)tankData.fs().getHoverName()).append(": " + tankData.fs().getAmount() + "mB").withStyle(ChatFormatting.GRAY));
        }
        if ((handler = (IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM)) != null) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                if (handler.getStackInSlot(i).isEmpty()) continue;
                tooltip.add((Component)Component.translatable((String)"desc.immersivepetroleum.flavour.speedboat.upgrade", (Object[])new Object[]{i + 1}).append(handler.getStackInSlot(i).getHoverName()));
            }
        }
        super.appendHoverText(stack, ctx, tooltip, flag);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, @Nonnull InteractionHand handIn) {
        ItemStack itemstack = playerIn.getItemInHand(handIn);
        float f1 = playerIn.xRotO + (playerIn.getXRot() - playerIn.xRotO);
        float f2 = playerIn.yRotO + (playerIn.getYRot() - playerIn.yRotO);
        double d0 = playerIn.xo + (playerIn.getX() - playerIn.xo);
        double d1 = playerIn.yo + (playerIn.getY() - playerIn.yo) + (double)playerIn.getEyeHeight();
        double d2 = playerIn.zo + (playerIn.getZ() - playerIn.zo);
        Vec3 vec3d = new Vec3(d0, d1, d2);
        float f3 = Mth.cos((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = Mth.sin((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -Mth.cos((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = Mth.sin((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        Vec3 vec3d1 = vec3d.add((double)f7 * 5.0, (double)f6 * 5.0, (double)f8 * 5.0);
        BlockHitResult raytraceresult = worldIn.clip(new ClipContext(vec3d, vec3d1, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)playerIn));
        Vec3 vec3d2 = playerIn.getViewVector(1.0f);
        boolean flag = false;
        AABB bb = playerIn.getBoundingBox();
        List list = worldIn.getEntities((Entity)playerIn, bb.expandTowards(vec3d2.x * 5.0, vec3d2.y * 5.0, vec3d2.z * 5.0).inflate(1.0));
        for (Entity entity : list) {
            AABB axisalignedbb;
            if (!entity.isPickable() || !(axisalignedbb = entity.getBoundingBox()).inflate((double)entity.getPickRadius()).contains(vec3d)) continue;
            flag = true;
        }
        if (flag) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
        }
        if (raytraceresult.getType() != HitResult.Type.BLOCK) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
        }
        Vec3 hit = raytraceresult.getLocation();
        Block block = worldIn.getBlockState(BlockPos.containing((Position)hit.add(0.0, 0.5, 0.0))).getBlock();
        boolean flag1 = block == Blocks.WATER;
        MotorboatEntity entityboat = new MotorboatEntity(worldIn, hit.x, flag1 ? hit.y - 0.12 : hit.y, hit.z);
        entityboat.setYRot(playerIn.yRotO);
        entityboat.setUpgrades(this.getContainedItems(itemstack));
        IPDataComponents.TankData tankData = (IPDataComponents.TankData)itemstack.get(IPDataComponents.TANK_DATA);
        if (tankData != null) {
            entityboat.setContainedFluid(tankData.fs());
        }
        if (worldIn.getBlockCollisions((Entity)entityboat, entityboat.getBoundingBox().inflate(-0.1)).iterator().hasNext()) {
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)itemstack);
        }
        if (!worldIn.isClientSide) {
            worldIn.addFreshEntity((Entity)entityboat);
        }
        if (!playerIn.isCreative()) {
            itemstack.shrink(1);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemstack);
    }
}

