/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.items;

import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.entity.MolotovItemEntity;
import flaxbeard.immersivepetroleum.common.items.IPItemBase;
import javax.annotation.Nonnull;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class MolotovItem
extends IPItemBase {
    private static final int SECONDS = 15;
    private final boolean isLit;

    private static Item.Properties makeProperty(boolean isLit) {
        Item.Properties prop = new Item.Properties().stacksTo(isLit ? 1 : 64).durability(15).setNoRepair();
        return prop;
    }

    public MolotovItem(boolean isLit) {
        super(MolotovItem.makeProperty(isLit));
        this.isLit = isLit;
    }

    @Override
    public boolean addSelfToCreativeTab() {
        return !this.isLit;
    }

    public void inventoryTick(@Nonnull ItemStack pStack, @Nonnull Level pLevel, @Nonnull Entity pEntity, int pSlotId, boolean pIsSelected) {
        super.inventoryTick(pStack, pLevel, pEntity, pSlotId, pIsSelected);
        if (this.isLit && pEntity instanceof Player) {
            CompoundTag tagCopy;
            Player player = (Player)pEntity;
            CustomData customData = (CustomData)pStack.get(DataComponents.CUSTOM_DATA);
            if (customData != null && (tagCopy = customData.copyTag()).contains("lit_time", 4)) {
                int duration = (int)(pLevel.getGameTime() - tagCopy.getLong("lit_time")) / 20;
                if (player.getAbilities().instabuild) {
                    if (duration > 0 && pStack.getDamageValue() == 0) {
                        pStack.setDamageValue(1);
                    }
                } else {
                    if (duration > 15) {
                        player.getSlot(pSlotId).set(new ItemStack((ItemLike)Items.GLASS_BOTTLE, 1));
                        return;
                    }
                    if (pStack.getDamageValue() != duration) {
                        pStack.setDamageValue(duration);
                    }
                }
            }
        }
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(@Nonnull Level pLevel, @Nonnull Player pPlayer, @Nonnull InteractionHand pUsedHand) {
        if (this.isLit) {
            ItemStack stack = pPlayer.getItemInHand(pUsedHand);
            if (stack.isDamaged() && !pLevel.isClientSide) {
                pLevel.playSound(null, pPlayer.getX(), pPlayer.getY(), pPlayer.getZ(), SoundEvents.EXPERIENCE_BOTTLE_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (pLevel.getRandom().nextFloat() * 0.4f + 0.8f));
                MolotovItemEntity entity = new MolotovItemEntity(pLevel, (LivingEntity)pPlayer);
                entity.setItem(stack);
                entity.shootFromRotation((Entity)pPlayer, pPlayer.getXRot(), pPlayer.getYRot(), 0.0f, 0.75f, 1.0f);
                pLevel.addFreshEntity((Entity)entity);
                if (!pPlayer.getAbilities().instabuild) {
                    stack.shrink(1);
                }
            }
            return InteractionResultHolder.consume((Object)pPlayer.getItemInHand(pUsedHand));
        }
        ItemStack mainStack = pPlayer.getItemInHand(pUsedHand);
        ItemStack offStack = pPlayer.getItemInHand(InteractionHand.OFF_HAND);
        if (mainStack.getItem() == this && offStack.getItem() == Items.FLINT_AND_STEEL) {
            pPlayer.startUsingItem(pUsedHand);
        }
        return InteractionResultHolder.consume((Object)pPlayer.getItemInHand(pUsedHand));
    }

    @Nonnull
    public ItemStack finishUsingItem(@Nonnull ItemStack pStack, @Nonnull Level pLevel, @Nonnull LivingEntity pLivingEntity) {
        if (!this.isLit && pLivingEntity instanceof Player) {
            Player player = (Player)pLivingEntity;
            ItemStack mainStack = player.getItemInHand(InteractionHand.MAIN_HAND);
            ItemStack offStack = player.getItemInHand(InteractionHand.OFF_HAND);
            if (mainStack.getItem() == this && offStack.getItem() == Items.FLINT_AND_STEEL) {
                pStack.shrink(1);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    if (!serverPlayer.getAbilities().instabuild) {
                        offStack.hurtAndBreak(1, serverPlayer.serverLevel(), serverPlayer, p -> {});
                    }
                }
                CompoundTag tag = new CompoundTag();
                tag.putLong("lit_time", pLevel.getGameTime() - 1L);
                ItemStack lit = new ItemStack((ItemLike)IPContent.Items.MOLOTOV_LIT.get(), 1);
                lit.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
                return lit;
            }
        }
        return pStack;
    }

    @Nonnull
    public UseAnim getUseAnimation(@Nonnull ItemStack pStack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(@Nonnull ItemStack stack, @Nonnull LivingEntity living) {
        return 20;
    }
}

