/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.items;

import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.items.IPItemBase;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class GasolineBottleItem
extends IPItemBase {
    public static final int FILLED_AMOUNT = 250;

    public GasolineBottleItem() {
        super(new Item.Properties().stacksTo(16));
    }

    public int getMaxStackSize(ItemStack stack) {
        return 16;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.getItemInHand(usedHand);
        BlockHitResult hit = GasolineBottleItem.getPlayerPOVHitResult(level, player, ClipContext.Block.COLLIDER);
        if (hit.getType() == HitResult.Type.BLOCK && hit instanceof BlockHitResult) {
            BlockHitResult bHit = hit;
            BlockPos pos = bHit.getBlockPos();
            if (!level.mayInteract(player, pos)) {
                return InteractionResultHolder.pass((Object)stack);
            }
            BlockEntity be = level.getBlockEntity(pos);
            if (be != null) {
                FluidStack fs;
                IFluidHandler fh = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, pos, null);
                if (fh != null && fh.fill(fs = new FluidStack(IPContent.Fluids.GASOLINE.get(), 250), IFluidHandler.FluidAction.SIMULATE) >= 250) {
                    fh.fill(fs, IFluidHandler.FluidAction.EXECUTE);
                    this.toEmptyBottle(player, stack);
                    return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide);
                }
                return InteractionResultHolder.pass((Object)stack);
            }
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public void toEmptyBottle(Player player, ItemStack stack) {
        if (player.getAbilities().instabuild) {
            return;
        }
        stack.shrink(1);
        ItemStack bottle = new ItemStack((ItemLike)Items.GLASS_BOTTLE);
        if (!player.addItem(bottle)) {
            player.drop(bottle, false);
        }
    }

    protected static BlockHitResult getPlayerPOVHitResult(Level level, Player player, ClipContext.Block blockMode) {
        float f = player.getXRot();
        float f1 = player.getYRot();
        Vec3 vec3 = player.getEyePosition();
        float f2 = Mth.cos((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.sin((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.cos((float)(-f * ((float)Math.PI / 180)));
        float f5 = Mth.sin((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d0 = player.blockInteractionRange();
        Vec3 vec31 = vec3.add((double)f6 * d0, (double)f5 * d0, (double)f7 * d0);
        return level.clip(new ClipContext(vec3, vec31, blockMode, ClipContext.Fluid.NONE, (Entity)player));
    }
}

