/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.gui;

import blusunrize.immersiveengineering.api.energy.AveragingEnergyStorage;
import blusunrize.immersiveengineering.api.energy.IMutableEnergyStorage;
import blusunrize.immersiveengineering.common.gui.IEContainerMenu;
import blusunrize.immersiveengineering.common.gui.sync.GenericContainerData;
import blusunrize.immersiveengineering.common.gui.sync.GenericDataSerializers;
import flaxbeard.immersivepetroleum.common.ExternalModContent;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.DerrickMultiblock;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.logic.DerrickLogic;
import flaxbeard.immersivepetroleum.common.gui.MultiblockAwareGuiContainer;
import flaxbeard.immersivepetroleum.common.util.inventory.FluidTankFiltered;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class DerrickContainer
extends MultiblockAwareGuiContainer {
    public final IEnergyStorage energy;
    public final FluidTankFiltered tank;
    public final ItemStackHandler items;
    public final Level level;
    private final BlockPos.MutableBlockPos pos;

    public static DerrickContainer makeServer(MenuType<?> type, int id, Inventory player, IEContainerMenu.MultiblockMenuContext<DerrickLogic.State> ctx) {
        DerrickLogic.State state = (DerrickLogic.State)ctx.mbContext().getState();
        BlockPos pos = ctx.mbContext().getLevel().getAbsoluteOrigin();
        Level level = ctx.mbContext().getLevel().getRawLevel();
        return new DerrickContainer(DerrickContainer.multiblockCtx(type, (int)id, ctx), player, new ItemStackHandler(state.inventory), state.tank, state.energy, level, pos.mutable());
    }

    public static DerrickContainer makeClient(MenuType<?> type, int id, Inventory player) {
        return new DerrickContainer(DerrickContainer.clientCtx(type, (int)id), player, new ItemStackHandler(1), new FluidTankFiltered(8000), new AveragingEnergyStorage(16000), player.player.level(), BlockPos.ZERO.mutable());
    }

    private DerrickContainer(IEContainerMenu.MenuContext ctx, Inventory playerInventory, ItemStackHandler items, FluidTankFiltered tank, AveragingEnergyStorage energy, Level level, BlockPos.MutableBlockPos pos) {
        super(ctx, DerrickMultiblock.INSTANCE);
        this.items = items;
        this.energy = energy;
        this.tank = tank;
        this.level = level;
        this.pos = pos;
        this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)this.items, 0, 37, 27){

            public boolean mayPlace(@Nonnull ItemStack stack) {
                return ExternalModContent.IE.isPipe(stack);
            }
        });
        this.ownSlotCount = 1;
        this.addPlayerInventorySlots(playerInventory, 20, 90);
        this.addPlayerHotbarSlots(playerInventory, 20, 148);
        this.addGenericData(new GenericContainerData(GenericDataSerializers.BLOCK_POS, () -> ((BlockPos.MutableBlockPos)this.pos).immutable(), arg_0 -> ((BlockPos.MutableBlockPos)this.pos).set(arg_0)));
        this.addGenericData(GenericContainerData.energy((IMutableEnergyStorage)energy));
        this.addGenericData(tank.getContainerData());
    }

    public BlockPos pos() {
        return this.pos.immutable();
    }
}

