/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.gui;

import blusunrize.immersiveengineering.api.energy.AveragingEnergyStorage;
import blusunrize.immersiveengineering.api.energy.IMutableEnergyStorage;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.common.gui.IEContainerMenu;
import blusunrize.immersiveengineering.common.gui.sync.GenericContainerData;
import blusunrize.immersiveengineering.common.gui.sync.GenericDataSerializers;
import flaxbeard.immersivepetroleum.api.crafting.CokerUnitRecipe;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.CokerUnitMultiblock;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.logic.coker.CokerUnitLogic;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.logic.coker.CokingChamber;
import flaxbeard.immersivepetroleum.common.gui.IPSlot;
import flaxbeard.immersivepetroleum.common.gui.MultiblockAwareGuiContainer;
import flaxbeard.immersivepetroleum.common.util.inventory.FluidTankFiltered;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class CokerUnitContainer
extends MultiblockAwareGuiContainer {
    public final AveragingEnergyStorage energy;
    public final FluidTankFiltered input;
    public final FluidTankFiltered output;
    public final ItemStackHandler items;
    public ChamberWrapper primary;
    public ChamberWrapper secondary;
    public final Level level;
    private final BlockPos.MutableBlockPos pos;

    public static CokerUnitContainer makeServer(MenuType<?> type, int id, Inventory player, IEContainerMenu.MultiblockMenuContext<CokerUnitLogic.State> ctx) {
        CokerUnitLogic.State state = (CokerUnitLogic.State)ctx.mbContext().getState();
        BlockPos pos = ctx.mbContext().getLevel().getAbsoluteOrigin();
        Level level = ctx.mbContext().getLevel().getRawLevel();
        return new CokerUnitContainer(CokerUnitContainer.multiblockCtx(type, (int)id, ctx), player, new ItemStackHandler(state.inventory.getInternal()), state.bufferTanks, state.chambers, state.energy, level, pos.mutable());
    }

    public static CokerUnitContainer makeClient(MenuType<?> type, int id, Inventory player) {
        return new CokerUnitContainer(CokerUnitContainer.clientCtx(type, (int)id), player, new ItemStackHandler(CokerUnitLogic.Inventory.values().length), new CokerUnitLogic.BufferTanks(), new CokerUnitLogic.Chambers(), new AveragingEnergyStorage(24000), player.player.level(), BlockPos.ZERO.mutable());
    }

    private CokerUnitContainer(IEContainerMenu.MenuContext ctx, Inventory playerInventory, ItemStackHandler items, CokerUnitLogic.BufferTanks tanks, CokerUnitLogic.Chambers chambers, AveragingEnergyStorage energy, Level level, BlockPos.MutableBlockPos pos) {
        super(ctx, CokerUnitMultiblock.INSTANCE);
        this.items = items;
        this.input = tanks.input();
        this.output = tanks.output();
        this.energy = energy;
        this.level = level;
        this.pos = pos;
        this.primary = new ChamberWrapper(chambers.primary());
        this.secondary = new ChamberWrapper(chambers.secondary());
        this.addSlot((Slot)new IPSlot.CokerInput((IItemHandler)this.items, CokerUnitLogic.Inventory.INPUT.id(), 20, 71));
        this.addSlot((Slot)new IPSlot((IItemHandler)this.items, CokerUnitLogic.Inventory.INPUT_FILLED.id(), 9, 14, stack -> FluidUtil.getFluidHandler((ItemStack)stack).map(h -> {
            if (h.getTanks() <= 0 || h.getFluidInTank(0).isEmpty()) {
                return false;
            }
            FluidStack fs = h.getFluidInTank(0);
            if (fs.isEmpty() || tanks.input().getFluidAmount() > 0 && !fs.is(tanks.input().getFluid().getFluid())) {
                return false;
            }
            return CokerUnitRecipe.hasRecipeWithInput(fs, true);
        }).orElse(false)));
        this.addSlot((Slot)new IPSlot.ItemOutput((IItemHandler)this.items, CokerUnitLogic.Inventory.INPUT_EMPTY.id(), 9, 45));
        this.addSlot((Slot)new IPSlot.FluidContainer((IItemHandler)this.items, CokerUnitLogic.Inventory.OUTPUT_EMPTY.id(), 175, 14, IPSlot.FluidContainer.FluidFilter.EMPTY));
        this.addSlot((Slot)new IPSlot.ItemOutput((IItemHandler)this.items, CokerUnitLogic.Inventory.OUTPUT_FILLED.id(), 175, 45));
        this.ownSlotCount = CokerUnitLogic.Inventory.values().length;
        this.addPlayerInventorySlots(playerInventory, 20, 105);
        this.addPlayerHotbarSlots(playerInventory, 20, 163);
        this.addGenericData(GenericContainerData.energy((IMutableEnergyStorage)energy));
        this.addGenericData(tanks.input().getContainerData());
        this.addGenericData(tanks.output().getContainerData());
        this.addGenericData(new GenericContainerData(GenericDataSerializers.BLOCK_POS, () -> ((BlockPos.MutableBlockPos)this.pos).immutable(), arg_0 -> ((BlockPos.MutableBlockPos)this.pos).set(arg_0)));
        this.primary.addData(this);
        this.secondary.addData(this);
    }

    public BlockPos pos() {
        return this.pos.immutable();
    }

    public static class ChamberWrapper {
        private final CokingChamber chamber;
        private Integer inputAmount = null;
        private Integer outputAmount = null;

        public ChamberWrapper(CokingChamber chamber) {
            this.chamber = chamber;
        }

        public void addData(CokerUnitContainer container) {
            container.addGenericData(new GenericContainerData(GenericDataSerializers.INT32, this::getInputAmount, this::setInputAmount));
            container.addGenericData(new GenericContainerData(GenericDataSerializers.INT32, this::getOutputAmount, this::setOutputAmount));
            container.addGenericData(this.chamber.getTank().getContainerData());
        }

        public int getInputAmount() {
            if (this.inputAmount == null) {
                return this.chamber.getInputAmount();
            }
            return this.inputAmount;
        }

        public int getOutputAmount() {
            if (this.outputAmount == null) {
                return this.chamber.getOutputAmount();
            }
            return this.outputAmount;
        }

        public void setInputAmount(int inputAmount) {
            this.inputAmount = inputAmount;
        }

        public void setOutputAmount(int outputAmount) {
            this.outputAmount = outputAmount;
        }

        public CokingChamber get() {
            return new CokingChamberDummy(this);
        }

        private static class CokingChamberDummy
        extends CokingChamber {
            private final Supplier<Integer> inputSupplier = wrapper::getInputAmount;
            private final Supplier<Integer> outputSupplier = wrapper::getOutputAmount;
            private final FluidTankFiltered tank;

            public CokingChamberDummy(ChamberWrapper wrapper) {
                super(wrapper.chamber.getCapacity(), wrapper.chamber.getTank().getCapacity());
                this.tank = wrapper.chamber.getTank();
            }

            @Override
            public int getInputAmount() {
                return this.inputSupplier.get();
            }

            @Override
            public int getOutputAmount() {
                return this.outputSupplier.get();
            }

            @Override
            public FluidTankFiltered getTank() {
                return this.tank;
            }

            @Override
            public ItemStack getInputItem() {
                return ItemStack.EMPTY;
            }

            @Override
            public ItemStack getOutputItem() {
                return ItemStack.EMPTY;
            }

            @Override
            @Nullable
            public RecipeHolder<CokerUnitRecipe> getRecipe() {
                return null;
            }

            @Override
            public boolean tick(IMultiblockContext<CokerUnitLogic.State> context, int chamberId) {
                return false;
            }
        }
    }
}

