/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.datastorage.reservoir;

import com.google.common.collect.Multimap;
import flaxbeard.immersivepetroleum.api.reservoir.Reservoir;
import flaxbeard.immersivepetroleum.common.datastorage.reservoir.RegionData;
import flaxbeard.immersivepetroleum.common.datastorage.reservoir.RegionPos;
import flaxbeard.immersivepetroleum.common.util.Utils;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReservoirRegionDataStorage
extends SavedData {
    protected static final Logger log = LogManager.getLogger((String)"immersivepetroleum/ReservoirRegionDataStorage");
    public static final int VERSION = 2;
    public static final String DATA_NAME = "ImmersivePetroleum-ReservoirRegions";
    private static ReservoirRegionDataStorage active_instance;
    final Map<RegionPos, RegionData> regions = new HashMap<RegionPos, RegionData>();
    final DimensionDataStorage dimData;

    public static ReservoirRegionDataStorage get() {
        return active_instance;
    }

    public static void init(DimensionDataStorage dimData) {
        active_instance = (ReservoirRegionDataStorage)dimData.computeIfAbsent(new SavedData.Factory(() -> {
            log.debug("Creating ReservoirRegionDataStorage instance.");
            return new ReservoirRegionDataStorage(dimData);
        }, (t, p) -> {
            log.debug("Creating and Loading Data for ReservoirRegionDataStorage instance.");
            return new ReservoirRegionDataStorage(dimData, (CompoundTag)t, (HolderLookup.Provider)p);
        }), DATA_NAME);
    }

    public ReservoirRegionDataStorage(DimensionDataStorage dimData) {
        this.dimData = dimData;
    }

    public ReservoirRegionDataStorage(DimensionDataStorage dimData, CompoundTag nbt, HolderLookup.Provider provider) {
        this(dimData);
        this.load(nbt, provider);
    }

    @Nonnull
    public CompoundTag save(CompoundTag nbt, @Nonnull HolderLookup.Provider provider) {
        nbt.putInt("version", 2);
        ListTag list = new ListTag();
        this.regions.forEach((key, entry) -> {
            CompoundTag tag = new CompoundTag();
            tag.putInt("x", key.x());
            tag.putInt("z", key.z());
            list.add((Object)tag);
        });
        nbt.put("regions", (Tag)list);
        log.debug("Saved regions file.");
        return nbt;
    }

    private void load(CompoundTag nbt, HolderLookup.Provider provider) {
        int version = nbt.getInt("version");
        if (version != 2) {
            // empty if block
        }
        ListTag regions = nbt.getList("regions", 10);
        for (int i = 0; i < regions.size(); ++i) {
            CompoundTag tag = regions.getCompound(i);
            int x = tag.getInt("x");
            int z = tag.getInt("z");
            RegionPos rPos = new RegionPos(x, z);
            RegionData rData = this.getOrCreateRegionData(rPos);
            this.regions.put(rPos, rData);
        }
        log.debug("Loaded regions file.");
    }

    public void markAllDirty() {
        this.setDirty();
        this.regions.values().forEach(SavedData::setDirty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReservoir(ResourceKey<Level> dimensionKey, Reservoir reservoir) {
        RegionPos regionPos = new RegionPos(reservoir.getBoundingBox().getCenter());
        RegionData regionData = this.getOrCreateRegionData(regionPos);
        Multimap<ResourceKey<Level>, Reservoir> multimap = regionData.reservoirlist;
        synchronized (multimap) {
            if (!regionData.reservoirlist.containsEntry(dimensionKey, (Object)reservoir)) {
                regionData.reservoirlist.put(dimensionKey, (Object)reservoir);
                reservoir.setRegion(regionData);
                regionData.setDirty();
            }
        }
    }

    @Nullable
    public Reservoir getReservoir(Level level, BlockPos pos) {
        return this.getReservoir(level, Utils.toColumnPos(pos));
    }

    @Nullable
    public Reservoir getReservoir(Level level, ColumnPos pos) {
        if (level.isClientSide) {
            return null;
        }
        ResourceKey dimKey = level.dimension();
        Reservoir ret = this.getReservoir((ResourceKey<Level>)dimKey, pos, 1, -1);
        if (ret == null && (ret = this.getReservoir((ResourceKey<Level>)dimKey, pos, 1, 1)) == null && (ret = this.getReservoir((ResourceKey<Level>)dimKey, pos, -1, -1)) == null) {
            ret = this.getReservoir((ResourceKey<Level>)dimKey, pos, -1, 1);
        }
        return ret;
    }

    private Reservoir getReservoir(ResourceKey<Level> dimKey, ColumnPos pos, int regionXOff, int regionZOff) {
        RegionData regionData = this.getRegionData(new RegionPos(pos, regionXOff, regionZOff));
        return regionData != null ? regionData.get(dimKey, pos) : null;
    }

    public boolean existsAt(ColumnPos pos) {
        boolean ret = this.existsAt(pos, 1, -1);
        if (!(ret || (ret = this.existsAt(pos, 1, 1)) || (ret = this.existsAt(pos, -1, -1)))) {
            ret = this.existsAt(pos, -1, 1);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean existsAt(ColumnPos pos, int regionXOff, int regionZOff) {
        RegionData regionData = this.getRegionData(new RegionPos(pos, regionXOff, regionZOff));
        if (regionData == null) {
            return false;
        }
        boolean ret = false;
        Multimap<ResourceKey<Level>, Reservoir> multimap = regionData.reservoirlist;
        synchronized (multimap) {
            ret = regionData.reservoirlist.values().stream().anyMatch(reservoir -> reservoir.getPolygon().contains(pos));
        }
        return ret;
    }

    @Nullable
    public RegionData getRegionData(BlockPos pos) {
        return this.getRegionData(new RegionPos(pos));
    }

    @Nullable
    public RegionData getRegionData(RegionPos regionPos) {
        RegionData ret = this.regions.getOrDefault(regionPos, null);
        return ret;
    }

    private RegionData getOrCreateRegionData(RegionPos regionPos) {
        RegionData ret = this.regions.computeIfAbsent(regionPos, pos -> {
            String fn = this.getRegionFileName((RegionPos)pos);
            RegionData data = (RegionData)this.dimData.computeIfAbsent(new SavedData.Factory(() -> new RegionData((RegionPos)pos), (t, p) -> new RegionData((RegionPos)pos, (CompoundTag)t, (HolderLookup.Provider)p)), fn);
            this.setDirty();
            log.debug("Created RegionData[{}, {}]", (Object)regionPos.x(), (Object)regionPos.z());
            return data;
        });
        return ret;
    }

    private String getRegionFileName(RegionPos regionPos) {
        return DATA_NAME + File.separatorChar + regionPos.x() + "_" + regionPos.z();
    }
}

