/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.crafting;

import blusunrize.immersiveengineering.api.crafting.IERecipeTypes;
import flaxbeard.immersivepetroleum.ImmersivePetroleum;
import flaxbeard.immersivepetroleum.api.crafting.CokerUnitRecipe;
import flaxbeard.immersivepetroleum.api.crafting.DistillationTowerRecipe;
import flaxbeard.immersivepetroleum.api.crafting.HighPressureRefineryRecipe;
import flaxbeard.immersivepetroleum.api.crafting.IPRecipeTypes;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirType;
import flaxbeard.immersivepetroleum.client.render.dyn.DynamicTextureWrapper;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ReloadableServerResources;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RecipesUpdatedEvent;

public class RecipeReloadListener
implements ResourceManagerReloadListener {
    private final ReloadableServerResources dataPackRegistries;

    public RecipeReloadListener(ReloadableServerResources dataPackRegistries) {
        this.dataPackRegistries = dataPackRegistries;
    }

    public void onResourceManagerReload(@Nonnull ResourceManager resourceManager) {
        if (this.dataPackRegistries != null) {
            RecipeReloadListener.lists(this.dataPackRegistries.getRecipeManager());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void recipesUpdated(RecipesUpdatedEvent event) {
        if (!Minecraft.getInstance().hasSingleplayerServer()) {
            RecipeReloadListener.lists(event.getRecipeManager());
        }
        DynamicTextureWrapper.clearCache();
    }

    static void lists(RecipeManager recipeManager) {
        Collection recipes = recipeManager.getRecipes();
        if (recipes.isEmpty()) {
            return;
        }
        ImmersivePetroleum.log.info("Loading Reservoirs.");
        ReservoirType.map = RecipeReloadListener.filterRecipes(recipes, ReservoirType.class, IPRecipeTypes.RESERVOIR);
        ImmersivePetroleum.log.info("Loading Distillation Recipes.");
        DistillationTowerRecipe.recipes = RecipeReloadListener.filterRecipes(recipes, DistillationTowerRecipe.class, IPRecipeTypes.DISTILLATION);
        ImmersivePetroleum.log.info("Loading Coker Recipes.");
        CokerUnitRecipe.recipes = RecipeReloadListener.filterRecipes(recipes, CokerUnitRecipe.class, IPRecipeTypes.COKER);
        ImmersivePetroleum.log.info("Loading High-Pressure Refinery Recipes.");
        HighPressureRefineryRecipe.recipes = RecipeReloadListener.filterRecipes(recipes, HighPressureRefineryRecipe.class, IPRecipeTypes.HYDROTREATER);
    }

    static <R extends Recipe<?>, H extends RecipeHolder<R>> Map<ResourceLocation, H> filterRecipes(Collection<RecipeHolder<?>> recipes, Class<R> recipeClass, IERecipeTypes.TypeWithClass<R> recipeType) {
        return recipes.stream().filter(holder -> holder.value().getType() == recipeType.get()).map(holder -> new Test(holder.id(), (RecipeHolder<?>)holder)).collect(Collectors.toMap(Test::id, Test::holder));
    }

    private record Test(ResourceLocation id, RecipeHolder<?> holder) {
    }
}

