/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks.wooden;

import flaxbeard.immersivepetroleum.common.IPTileTypes;
import flaxbeard.immersivepetroleum.common.blocks.IPBlockBase;
import flaxbeard.immersivepetroleum.common.blocks.IPBlockItemBase;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.AutoLubricatorTileEntity;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class AutoLubricatorBlock
extends IPBlockBase
implements EntityBlock {
    public static final DirectionProperty FACING = DirectionProperty.create((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    public static final BooleanProperty SLAVE = BooleanProperty.create((String)"slave");
    static final VoxelShape SHAPE_SLAVE = Shapes.box((double)0.1875, (double)0.0, (double)0.1875, (double)0.8125, (double)1.0, (double)0.8125);
    static final VoxelShape SHAPE_MASTER = Shapes.box((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)1.0, (double)0.9375);

    public AutoLubricatorBlock() {
        super(BlockBehaviour.Properties.of().strength(5.0f, 6.0f).sound(SoundType.WOOD).requiresCorrectToolForDrops().noOcclusion().mapColor(MapColor.COLOR_GRAY).instrument(NoteBlockInstrument.BASS).sound(SoundType.CHERRY_WOOD).pushReaction(PushReaction.BLOCK));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)SLAVE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public Supplier<BlockItem> blockItemSupplier() {
        return () -> new AutoLubricatorBlockItem(this);
    }

    @Override
    public boolean addSelfToCreativeTab() {
        return false;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, SLAVE});
    }

    public int getLightBlock(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos) {
        return 0;
    }

    public boolean propagatesSkylightDown(@Nonnull BlockState state, @Nonnull BlockGetter reader, @Nonnull BlockPos pos) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getShadeBrightness(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos) {
        return 1.0f;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection());
    }

    @Override
    public void setPlacedBy(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        super.setPlacedBy(pLevel, pPos, pState, pPlacer, pStack);
        if (!pLevel.isClientSide) {
            pLevel.setBlockAndUpdate(pPos.offset(0, 1, 0), (BlockState)pState.setValue((Property)SLAVE, (Comparable)Boolean.valueOf(true)));
        }
    }

    public BlockEntity newBlockEntity(@Nonnull BlockPos pPos, @Nonnull BlockState pState) {
        AutoLubricatorTileEntity te = (AutoLubricatorTileEntity)((BlockEntityType)IPTileTypes.AUTOLUBE.get()).create(pPos, pState);
        te.isSlave = (Boolean)pState.getValue((Property)SLAVE);
        te.facing = (Direction)pState.getValue((Property)FACING);
        return te;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@Nonnull Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<T> type) {
        return AutoLubricatorBlock.createCommonTicker(level.isClientSide, type, IPTileTypes.AUTOLUBE);
    }

    @Nonnull
    public BlockState playerWillDestroy(@Nonnull Level worldIn, @Nonnull BlockPos pos, BlockState state, @Nonnull Player player) {
        if (((Boolean)state.getValue((Property)SLAVE)).booleanValue()) {
            worldIn.destroyBlock(pos.offset(0, -1, 0), !player.isCreative());
        } else {
            worldIn.destroyBlock(pos.offset(0, 1, 0), false);
        }
        return super.playerWillDestroy(worldIn, pos, state, player);
    }

    @Nonnull
    public VoxelShape getShape(BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return (Boolean)state.getValue((Property)SLAVE) != false ? SHAPE_SLAVE : SHAPE_MASTER;
    }

    public static class AutoLubricatorBlockItem
    extends IPBlockItemBase {
        public AutoLubricatorBlockItem(Block blockIn) {
            super(blockIn, new Item.Properties());
        }

        protected boolean canPlace(@Nonnull BlockPlaceContext con, @Nonnull BlockState state) {
            if (!super.canPlace(con, state)) {
                return false;
            }
            BlockPos otherPos = con.getClickedPos().relative(Direction.UP);
            BlockState otherState = con.getLevel().getBlockState(otherPos);
            return otherState.isAir();
        }
    }
}

