/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks.tileentities;

import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockBE;
import flaxbeard.immersivepetroleum.api.reservoir.Reservoir;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirHandler;
import flaxbeard.immersivepetroleum.client.ClientProxy;
import flaxbeard.immersivepetroleum.common.IPTileTypes;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.logic.PumpjackLogic;
import flaxbeard.immersivepetroleum.common.blocks.stone.WellPipeBlock;
import flaxbeard.immersivepetroleum.common.blocks.ticking.IPCommonTickableTile;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.IPTileEntityBase;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.WellPipeTileEntity;
import flaxbeard.immersivepetroleum.common.util.RegistryUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.apache.commons.lang3.tuple.Pair;

public class WellTileEntity
extends IPTileEntityBase
implements IPCommonTickableTile {
    public static final int PIPE_WORTH = 6;
    static final int DEFAULT_PIPELENGTH = 384;
    @Nonnull
    public List<ColumnPos> tappedReservoirs = new ArrayList<ColumnPos>();
    public final List<Integer> phyiscalPipesList = new ArrayList<Integer>();
    public int pipes = 0;
    public int wellPipeLength = 0;
    public int additionalPipes = 0;
    public boolean drillingCompleted;
    public boolean pastPhysicalPart;
    private boolean selfDestruct;
    private int selfDestructTimer;
    private Fluid spillFType = Fluids.EMPTY;
    private int spillHeight = -1;
    boolean spill = false;
    int clientFlow = 0;

    public WellTileEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)IPTileTypes.WELL.get(), pWorldPosition, pBlockState);
    }

    @Override
    protected void readCustom(CompoundTag nbt, HolderLookup.Provider provider) {
        ListTag list;
        this.spill = nbt.getBoolean("spill");
        this.clientFlow = nbt.getInt("flow");
        this.drillingCompleted = nbt.getBoolean("drillingcompleted");
        this.pastPhysicalPart = nbt.getBoolean("pastphyiscalpart");
        this.pipes = nbt.getInt("pipes");
        this.wellPipeLength = nbt.getInt("wellpipelength");
        this.additionalPipes = nbt.getInt("additionalpipes");
        this.selfDestruct = nbt.getBoolean("selfdestruct");
        this.selfDestructTimer = nbt.getInt("selfdestructtimer");
        try {
            this.spillFType = (Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.parse((String)nbt.getString("spillftype")));
        }
        catch (ResourceLocationException rle) {
            this.spillFType = Fluids.EMPTY;
        }
        this.spillHeight = nbt.getInt("spillheight");
        if (nbt.contains("tappedislands", 9)) {
            list = nbt.getList("tappedislands", 10);
            ArrayList<ColumnPos> tmp = new ArrayList<ColumnPos>(list.size());
            list.forEach(n -> {
                CompoundTag pos = (CompoundTag)n;
                int x = pos.getInt("x");
                int z = pos.getInt("z");
                tmp.add(new ColumnPos(x, z));
            });
            this.tappedReservoirs = tmp;
        }
        if (nbt.contains("pipeLoc", 9)) {
            list = nbt.getList("pipeLoc", 3);
            ArrayList ints = new ArrayList(list.size());
            list.forEach(n -> ints.add(((IntTag)n).getAsInt()));
            this.phyiscalPipesList.clear();
            this.phyiscalPipesList.addAll(ints);
        }
    }

    @Override
    protected void writeCustom(CompoundTag nbt, HolderLookup.Provider provider) {
        ListTag list;
        nbt.putBoolean("spill", this.spill);
        nbt.putInt("flow", this.getFlow());
        nbt.putBoolean("drillingcompleted", this.drillingCompleted);
        nbt.putBoolean("pastphyiscalpart", this.pastPhysicalPart);
        nbt.putInt("pipes", this.pipes);
        nbt.putInt("wellpipelength", this.wellPipeLength);
        nbt.putInt("additionalpipes", this.additionalPipes);
        nbt.putBoolean("selfdestruct", this.selfDestruct);
        nbt.putInt("selfdestructtimer", this.selfDestructTimer);
        nbt.putString("spillftype", RegistryUtils.getRegistryNameOf(this.spillFType).toString());
        nbt.putInt("spillheight", this.spillHeight);
        if (!this.tappedReservoirs.isEmpty()) {
            list = new ListTag();
            this.tappedReservoirs.forEach(c -> {
                CompoundTag pos = new CompoundTag();
                pos.putInt("x", c.x());
                pos.putInt("z", c.z());
                list.add((Object)pos);
            });
            nbt.put("tappedislands", (Tag)list);
        }
        if (!this.phyiscalPipesList.isEmpty()) {
            list = new ListTag();
            this.phyiscalPipesList.forEach(i -> list.add((Object)IntTag.valueOf((int)i)));
            nbt.put("pipeLoc", (Tag)list);
        }
    }

    private int getFlow() {
        Reservoir reservoir = ReservoirHandler.getReservoir(this.getNonnullLevel(), this.getBlockPos());
        if (reservoir == null) {
            return 0;
        }
        return reservoir.getFlowFromPressure(this.getNonnullLevel(), this.getBlockPos());
    }

    @Override
    public void tickClient() {
        if (this.spill && this.spillFType != Fluids.EMPTY) {
            BlockPos pPos = this.spillHeight > -1 ? new BlockPos(this.worldPosition.getX(), this.spillHeight, this.worldPosition.getZ()) : this.worldPosition.above();
            ClientProxy.spawnSpillParticles(this.level, pPos, this.spillFType, 10, -0.25f, this.clientFlow);
        }
    }

    @Override
    public void tickServer() {
        if (this.drillingCompleted) {
            if (!this.tappedReservoirs.isEmpty()) {
                Reservoir reservoir;
                for (ColumnPos cPos : this.tappedReservoirs) {
                    reservoir = ReservoirHandler.getReservoir(this.getNonnullLevel(), cPos);
                    if (reservoir == null || !reservoir.belowHydrostaticEquilibrium(this.getNonnullLevel())) continue;
                    reservoir.equalizeHydrostaticPressure(this.getNonnullLevel());
                }
                if (this.getNonnullLevel().getGameTime() % 5L == 0L) {
                    boolean spill = false;
                    int height = -1;
                    Fluid fType = Fluids.EMPTY;
                    BlockEntity teHigh = this.getNonnullLevel().getBlockEntity(this.getBlockPos().above());
                    if (teHigh instanceof WellPipeTileEntity) {
                        IMultiblockBE multiblockBE;
                        WellPipeTileEntity well = (WellPipeTileEntity)teHigh;
                        Pair<Boolean, BlockPos> result = well.hasValidConnection();
                        BlockEntity te = this.getNonnullLevel().getBlockEntity((BlockPos)result.getRight());
                        if (!((Boolean)result.getLeft()).booleanValue() || te instanceof IMultiblockBE && (multiblockBE = (IMultiblockBE)te).getHelper().getContext().getState() instanceof PumpjackLogic.State) {
                            for (ColumnPos cPos : this.tappedReservoirs) {
                                Reservoir reservoir2 = ReservoirHandler.getReservoir(this.getNonnullLevel(), cPos);
                                if (reservoir2 == null || !((double)reservoir2.getPressure(this.getNonnullLevel(), cPos.x(), cPos.z()) > 0.0)) continue;
                                fType = reservoir2.getFluid();
                                height = ((BlockPos)result.getRight()).getY();
                                spill = true;
                                break;
                            }
                        }
                    } else {
                        ColumnPos cPos = this.tappedReservoirs.get(0);
                        Reservoir reservoir3 = ReservoirHandler.getReservoir(this.getNonnullLevel(), cPos);
                        if (reservoir3 != null && (double)reservoir3.getPressure(this.getNonnullLevel(), cPos.x(), cPos.z()) > 0.0) {
                            spill = true;
                            fType = reservoir3.getFluid();
                            height = this.worldPosition.getY() + 1;
                        }
                    }
                    if (spill != this.spill || spill && this.getNonnullLevel().getGameTime() % 10L == 0L) {
                        this.spill = spill;
                        if (this.spill) {
                            this.spillHeight = height;
                            this.spillFType = fType;
                        } else {
                            this.spillHeight = -1;
                            this.spillFType = Fluids.EMPTY;
                        }
                        this.setChanged();
                    }
                }
                if (this.spill) {
                    for (ColumnPos cPos : this.tappedReservoirs) {
                        reservoir = ReservoirHandler.getReservoir(this.getNonnullLevel(), cPos);
                        if (reservoir == null) continue;
                        reservoir.extractWithPressure(this.getNonnullLevel(), cPos.x(), cPos.z());
                    }
                }
            }
        } else if (this.selfDestruct && this.advanceTimer()) {
            if (!this.phyiscalPipesList.isEmpty()) {
                for (Integer integer : this.phyiscalPipesList) {
                    BlockPos pos = this.getBlockPos();
                    pos = new BlockPos(pos.getX(), integer.intValue(), pos.getZ());
                    BlockState state = this.getNonnullLevel().getBlockState(pos);
                    if (!(state.getBlock() instanceof WellPipeBlock)) continue;
                    this.getNonnullLevel().setBlockAndUpdate(pos, (BlockState)state.setValue((Property)WellPipeBlock.BROKEN, (Comparable)Boolean.valueOf(true)));
                }
            }
            this.getNonnullLevel().setBlockAndUpdate(this.getBlockPos(), Blocks.BEDROCK.defaultBlockState());
        }
    }

    public void usePipe() {
        if (this.drillingCompleted) {
            return;
        }
        --this.pipes;
        ++this.wellPipeLength;
        if (this.wellPipeLength >= this.getMaxPipeLength()) {
            this.drillingCompleted = true;
        }
        this.setChanged();
    }

    public int getMaxPipeLength() {
        return 384 + this.additionalPipes;
    }

    public void startSelfDestructSequence() {
        if (this.drillingCompleted) {
            return;
        }
        this.selfDestruct = true;
        this.selfDestructTimer = 6000;
    }

    public void abortSelfDestructSequence() {
        if (this.selfDestruct) {
            this.selfDestruct = false;
        }
    }

    public boolean advanceTimer() {
        return this.selfDestruct && this.selfDestructTimer-- <= 0;
    }

    public void setChanged() {
        super.setChanged();
        Level level = this.getNonnullLevel();
        BlockState state = level.getBlockState(this.worldPosition);
        level.sendBlockUpdated(this.worldPosition, state, state, 3);
        level.updateNeighborsAt(this.worldPosition, state.getBlock());
    }
}

