/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks.tileentities;

import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockBE;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.IPTileTypes;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.logic.DerrickLogic;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.logic.PumpjackLogic;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.IPTileEntityBase;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.WellTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.tuple.Pair;

public class WellPipeTileEntity
extends IPTileEntityBase {
    public WellPipeTileEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)IPTileTypes.WELL_PIPE.get(), pWorldPosition, pBlockState);
    }

    @Override
    protected void writeCustom(CompoundTag nbt, HolderLookup.Provider provider) {
    }

    @Override
    protected void readCustom(CompoundTag nbt, HolderLookup.Provider provider) {
    }

    public WellTileEntity getWell() {
        for (int y = this.worldPosition.getY() - 1; y >= this.level.getMinBuildHeight(); --y) {
            BlockEntity teLow = this.level.getBlockEntity(new BlockPos(this.worldPosition.getX(), y, this.worldPosition.getZ()));
            if (teLow instanceof WellTileEntity) {
                WellTileEntity well = (WellTileEntity)teLow;
                return well;
            }
            if (!(teLow instanceof WellPipeTileEntity)) break;
        }
        return null;
    }

    public BlockPos checkForMissingPipe() {
        for (int y = this.worldPosition.getY() + 1; y < this.level.getMaxBuildHeight(); ++y) {
            BlockPos pos = new BlockPos(this.worldPosition.getX(), y, this.worldPosition.getZ());
            BlockEntity teHigh = this.level.getBlockEntity(pos);
            if (teHigh instanceof WellPipeTileEntity) continue;
            return pos;
        }
        return null;
    }

    public Pair<Boolean, BlockPos> hasValidConnection() {
        BlockPos pos = null;
        for (int y = this.worldPosition.getY() + 1; y < this.level.getMaxBuildHeight(); ++y) {
            pos = new BlockPos(this.worldPosition.getX(), y, this.worldPosition.getZ());
            BlockEntity teHigh = this.level.getBlockEntity(pos);
            if (teHigh instanceof IMultiblockBE) {
                IMultiblockBE mb = (IMultiblockBE)teHigh;
                IMultiblockState mbState = mb.getHelper().getState();
                BlockPos positionInMB = mb.getHelper().getPositionInMB();
                if (mbState instanceof PumpjackLogic.State && positionInMB.equals((Object)IPContent.Multiblock.PUMPJACK.masterPosInMB())) {
                    return Pair.of((Object)true, (Object)pos);
                }
                if (mbState instanceof DerrickLogic.State && positionInMB.equals((Object)IPContent.Multiblock.DERRICK.masterPosInMB())) {
                    return Pair.of((Object)true, (Object)pos);
                }
            }
            if (!(teHigh instanceof WellPipeTileEntity)) break;
        }
        return Pair.of((Object)false, pos);
    }
}

