/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks.tileentities;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class IPTileEntityBase
extends BlockEntity {
    public IPTileEntityBase(BlockEntityType<?> blockEntityType, BlockPos pWorldPosition, BlockState pBlockState) {
        super(blockEntityType, pWorldPosition, pBlockState);
    }

    @Nonnull
    public Level getNonnullLevel() {
        return Objects.requireNonNull(super.getLevel());
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this, (b, p) -> this.getUpdateTag((HolderLookup.Provider)p));
    }

    public void handleUpdateTag(@Nonnull CompoundTag tag, @Nonnull HolderLookup.Provider provider) {
        this.loadAdditional(tag, provider);
    }

    @Nonnull
    public CompoundTag getUpdateTag(@Nonnull HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        this.saveAdditional(nbt, provider);
        return nbt;
    }

    public void onDataPacket(@Nonnull Connection net, ClientboundBlockEntityDataPacket pkt, @Nonnull HolderLookup.Provider provider) {
        this.loadAdditional(pkt.getTag(), provider);
    }

    protected void saveAdditional(@Nonnull CompoundTag nbt, @Nonnull HolderLookup.Provider provider) {
        this.writeCustom(nbt, provider);
    }

    protected void loadAdditional(@Nonnull CompoundTag nbt, @Nonnull HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        this.readCustom(nbt, provider);
    }

    protected abstract void writeCustom(CompoundTag var1, HolderLookup.Provider var2);

    protected abstract void readCustom(CompoundTag var1, HolderLookup.Provider var2);
}

