/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks.tileentities;

import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.MutableEnergyStorage;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.impl.ImmersiveConnectableBlockEntity;
import blusunrize.immersiveengineering.api.wires.localhandlers.EnergyTransferHandler;
import blusunrize.immersiveengineering.api.wires.utils.WireUtils;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.util.IESounds;
import com.google.common.collect.ImmutableList;
import flaxbeard.immersivepetroleum.ImmersivePetroleum;
import flaxbeard.immersivepetroleum.api.energy.FuelHandler;
import flaxbeard.immersivepetroleum.common.IPCapabilityRegistry;
import flaxbeard.immersivepetroleum.common.IPDataComponents;
import flaxbeard.immersivepetroleum.common.IPTileTypes;
import flaxbeard.immersivepetroleum.common.blocks.interfaces.IBlockEntityDrop;
import flaxbeard.immersivepetroleum.common.blocks.interfaces.IPlacementReader;
import flaxbeard.immersivepetroleum.common.blocks.interfaces.IPlayerInteraction;
import flaxbeard.immersivepetroleum.common.blocks.ticking.IPCommonTickableTile;
import flaxbeard.immersivepetroleum.common.sound.IPlaySound;
import flaxbeard.immersivepetroleum.common.util.Utils;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class GasGeneratorTileEntity
extends ImmersiveConnectableBlockEntity
implements IPCommonTickableTile,
IPCapabilityRegistry.IHasMultiCapability,
IPlacementReader,
IPlayerInteraction,
IBlockEntityDrop,
IPlaySound,
IEBlockInterfaces.IDirectionalBE,
IEBlockInterfaces.IBlockOverlayText,
EnergyTransferHandler.EnergyConnector {
    public static final int FUEL_CAPACITY = 8000;
    protected WireType wireType;
    protected boolean isActive = false;
    protected int fluidTick = 0;
    protected int currentFlux = 0;
    protected Direction facing = Direction.NORTH;
    protected final MutableEnergyStorage energyStorage = new MutableEnergyStorage(this.getMaxStorage(), Integer.MAX_VALUE, this.getMaxOutput());
    protected final FluidTank tank = new FluidTank(8000, fluid -> fluid != FluidStack.EMPTY && FuelHandler.isValidFuel(fluid.getFluid()));

    public GasGeneratorTileEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)IPTileTypes.GENERATOR.get(), pWorldPosition, pBlockState);
    }

    public int getMaxOutput() {
        return IEServerConfig.MACHINES.lvCapConfig.output.getAsInt();
    }

    private int getMaxStorage() {
        return IEServerConfig.MACHINES.lvCapConfig.storage.getAsInt();
    }

    protected void loadAdditional(@Nonnull CompoundTag nbt, @Nonnull HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        this.isActive = nbt.getBoolean("isActive");
        this.fluidTick = nbt.getInt("fluidTick");
        this.currentFlux = nbt.getInt("currentFlux");
        this.tank.readFromNBT(provider, nbt.getCompound("tank"));
        WireType wireType = this.wireType = nbt.contains("wiretype") ? WireUtils.getWireTypeFromNBT((CompoundTag)nbt, (String)"wiretype") : null;
        if (nbt.contains("buffer")) {
            this.energyStorage.deserializeNBT(provider, nbt.get("buffer"));
        }
    }

    public void saveAdditional(@Nonnull CompoundTag nbt, @Nonnull HolderLookup.Provider provider) {
        nbt.putInt("fluidTick", this.fluidTick);
        nbt.putInt("currentFlux", this.currentFlux);
        nbt.putBoolean("isActive", this.isActive);
        nbt.put("tank", (Tag)this.tank.writeToNBT(provider, new CompoundTag()));
        nbt.put("buffer", this.energyStorage.serializeNBT(provider));
        if (this.wireType != null) {
            nbt.putString("wiretype", this.wireType.getUniqueName());
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this, (b, p) -> this.getUpdateTag((HolderLookup.Provider)p));
    }

    @Nonnull
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        this.saveAdditional(nbt, provider);
        return nbt;
    }

    @Nonnull
    public Level getNonnullLevel() {
        return Objects.requireNonNull(this.level);
    }

    public void setChanged() {
        super.setChanged();
        BlockState state = this.getNonnullLevel().getBlockState(this.worldPosition);
        this.getNonnullLevel().sendBlockUpdated(this.worldPosition, state, state, 3);
        this.getNonnullLevel().updateNeighborsAt(this.worldPosition, state.getBlock());
    }

    public int getAvailableEnergy() {
        return Math.min(this.getMaxOutput(), this.energyStorage.getEnergyStored());
    }

    public void extractEnergy(int amount) {
        this.energyStorage.extractEnergy(amount, false);
    }

    public boolean isSource(ConnectionPoint cp) {
        return true;
    }

    public boolean isSink(ConnectionPoint cp) {
        return false;
    }

    @Override
    public boolean stopSound(ResourceLocation soundLocation) {
        return !this.isActive;
    }

    @Override
    public <C, T> T getCapability(BlockCapability<T, C> cap, Direction side) {
        if (cap == Capabilities.FluidHandler.BLOCK && (side == null || side == Direction.UP)) {
            return (T)this.tank;
        }
        if (cap == Capabilities.EnergyStorage.BLOCK && (side == null || side == this.facing)) {
            return (T)this.energyStorage;
        }
        return null;
    }

    @Nullable
    public Component[] getOverlayText(@Nullable BlockState blockState, Player player, HitResult mop, boolean hammer) {
        if (Utils.isFluidRelatedItemStack(player.getItemInHand(InteractionHand.MAIN_HAND))) {
            MutableComponent s = switch (this.tank.getFluid().isEmpty() ? 0 : 1) {
                case 0 -> Component.translatable((String)"gui.immersiveengineering.empty");
                case 1 -> ((MutableComponent)this.tank.getFluid().getHoverName()).append(": " + this.tank.getFluidAmount() + "mB");
                default -> null;
            };
            return new Component[]{s};
        }
        return null;
    }

    @Override
    public InteractionResult interact(Direction side, Player player, InteractionHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        if (FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)this.tank)) {
            this.setChanged();
            Utils.unlockIPAdvancement(player, "main/gas_generator");
            return InteractionResult.SUCCESS;
        }
        if (player.isShiftKeyDown()) {
            boolean added;
            if (player.getInventory().getSelected().isEmpty()) {
                added = true;
                player.getInventory().setItem(player.getInventory().selected, this.getFirstBlockEntityDrop());
            } else {
                added = player.getInventory().add(this.getFirstBlockEntityDrop());
            }
            if (added) {
                this.getNonnullLevel().setBlockAndUpdate(this.worldPosition, Blocks.AIR.defaultBlockState());
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    @Override
    public void readOnPlacement(LivingEntity placer, ItemStack stack) {
        IPDataComponents.TankData tankData = (IPDataComponents.TankData)stack.get(IPDataComponents.TANK_DATA);
        IPDataComponents.PowerData powerData = (IPDataComponents.PowerData)stack.get(IPDataComponents.POWER_DATA);
        if (tankData != null && !tankData.fs().isEmpty()) {
            this.tank.fill(tankData.fs(), IFluidHandler.FluidAction.EXECUTE);
        }
        if (powerData != null) {
            this.energyStorage.setStoredEnergy(powerData.energy());
        }
    }

    @Override
    @Nonnull
    public List<ItemStack> getBlockEntityDrop(LootContext context) {
        ItemStack stack = new ItemStack((ItemLike)this.getBlockState().getBlock());
        if (this.tank.getFluidAmount() > 0) {
            stack.set(IPDataComponents.TANK_DATA, (Object)new IPDataComponents.TankData((IFluidTank)this.tank));
        }
        if (this.energyStorage.getEnergyStored() > 0) {
            stack.set(IPDataComponents.POWER_DATA, (Object)new IPDataComponents.PowerData((IEnergyStorage)this.energyStorage));
        }
        return ImmutableList.of((Object)stack);
    }

    @Nonnull
    public Direction getFacing() {
        return this.facing;
    }

    public void setFacing(@Nonnull Direction facing) {
        this.facing = facing;
    }

    @Nonnull
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.HORIZONTAL;
    }

    public boolean mirrorFacingOnPlacement(@Nonnull LivingEntity placer) {
        return false;
    }

    public boolean canHammerRotate(@Nonnull Direction side, @Nonnull Vec3 hit, @Nonnull LivingEntity entity) {
        return true;
    }

    @Override
    public void tickClient() {
        ImmersivePetroleum.proxy.handleTileSound((Holder<SoundEvent>)IESounds.dieselGenerator, (BlockEntity)this, this.isActive, 0.3f, 1.25f);
        if (this.isActive && this.getNonnullLevel().getGameTime() % 4L == 0L) {
            Direction fl = this.facing;
            Direction fw = this.facing.getCounterClockWise();
            Vec3i vec = fw.getOpposite().getNormal();
            double x = (double)this.worldPosition.getX() + 0.5 + (double)((float)(fl.getStepX() * -2) / 6.0f) + (double)((float)(-fw.getStepX()) * 0.6125f);
            double y = (double)this.worldPosition.getY() + 0.4;
            double z = (double)this.worldPosition.getZ() + 0.5 + (double)((float)(fl.getStepZ() * -2) / 6.0f) + (double)((float)(-fw.getStepZ()) * 0.6125f);
            this.getNonnullLevel().addParticle((ParticleOptions)(this.getNonnullLevel().random.nextInt(10) == 0 ? ParticleTypes.LARGE_SMOKE : ParticleTypes.SMOKE), x, y, z, (double)vec.getX() * 0.025, 0.0, (double)vec.getZ() * 0.025);
        }
    }

    @Override
    public void tickServer() {
        boolean lastActive = this.isActive;
        this.isActive = false;
        if (!this.getNonnullLevel().hasNeighborSignal(this.worldPosition)) {
            if (this.fluidTick == 0) {
                FluidStack fStack = this.tank.getFluid();
                if ((fStack = fStack.copyWithAmount(FuelHandler.getGeneratorFuelUse(fStack.getFluid()))).getAmount() > 0 && this.tank.getFluidAmount() >= fStack.getAmount()) {
                    this.tank.drain(fStack, IFluidHandler.FluidAction.EXECUTE);
                    this.currentFlux = FuelHandler.getFluxGeneratedPerTick(fStack.getFluid());
                    this.fluidTick = 20;
                }
            }
            if (this.fluidTick > 0 && this.energyStorage.receiveEnergy(this.currentFlux, true) >= this.currentFlux) {
                this.energyStorage.receiveEnergy(this.currentFlux, false);
                this.isActive = true;
                --this.fluidTick;
            }
        }
        if (lastActive != this.isActive || this.isActive || this.wireType != null) {
            this.setChanged();
        }
    }

    public void connectCable(WireType cableType, ConnectionPoint target, IImmersiveConnectable other, ConnectionPoint otherTarget) {
        this.wireType = cableType;
        this.setChanged();
    }

    public void removeCable(@Nullable Connection connection, ConnectionPoint attachedPoint) {
        this.wireType = null;
        this.setChanged();
    }

    public boolean canConnect() {
        return true;
    }

    public boolean canConnectCable(WireType cableType, ConnectionPoint target, Vec3i offset) {
        if (this.getNonnullLevel().getBlockState(target.position()).getBlock() != this.getNonnullLevel().getBlockState(this.getBlockPos()).getBlock()) {
            return false;
        }
        return this.wireType == null && (cableType.getCategory().equals("LV") || cableType.getCategory().equals("MV"));
    }

    public BlockPos getConnectionMaster(@Nullable WireType cableType, TargetingInfo target) {
        return this.worldPosition;
    }

    public ConnectionPoint getTargetedPoint(TargetingInfo info, Vec3i offset) {
        return new ConnectionPoint(this.worldPosition, 0);
    }

    public Collection<ConnectionPoint> getConnectionPoints() {
        return List.of(new ConnectionPoint(this.worldPosition, 0));
    }

    public BlockPos getPosition() {
        return this.worldPosition;
    }

    public Vec3 getConnectionOffset(ConnectionPoint here, ConnectionPoint other, WireType type) {
        float xo = (float)this.facing.getNormal().getX() * 0.5f + 0.5f;
        float zo = (float)this.facing.getNormal().getZ() * 0.5f + 0.5f;
        return new Vec3((double)xo, 0.5, (double)zo);
    }

    public Collection<ResourceLocation> getRequestedHandlers() {
        return ImmutableList.of((Object)EnergyTransferHandler.ID);
    }
}

