/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks.tileentities;

import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelperMaster;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockBE;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import flaxbeard.immersivepetroleum.api.crafting.LubricantHandler;
import flaxbeard.immersivepetroleum.api.crafting.LubricatedHandler;
import flaxbeard.immersivepetroleum.common.IPCapabilityRegistry;
import flaxbeard.immersivepetroleum.common.IPDataComponents;
import flaxbeard.immersivepetroleum.common.IPTileTypes;
import flaxbeard.immersivepetroleum.common.blocks.interfaces.IBlockEntityDrop;
import flaxbeard.immersivepetroleum.common.blocks.interfaces.IPlacementReader;
import flaxbeard.immersivepetroleum.common.blocks.interfaces.IPlayerInteraction;
import flaxbeard.immersivepetroleum.common.blocks.ticking.IPCommonTickableTile;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.IPTileEntityBase;
import flaxbeard.immersivepetroleum.common.blocks.wooden.AutoLubricatorBlock;
import flaxbeard.immersivepetroleum.common.util.Utils;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.Nullable;

public class AutoLubricatorTileEntity
extends IPTileEntityBase
implements IPCommonTickableTile,
IPCapabilityRegistry.IHasCapability,
IPlacementReader,
IPlayerInteraction,
IBlockEntityDrop,
IEBlockInterfaces.IBlockOverlayText {
    public boolean isSlave;
    public Direction facing = Direction.NORTH;
    public FluidTank tank = new FluidTank(8000, fluid -> fluid != null && LubricantHandler.isValidLube(fluid.getFluid()));
    int count = 0;
    int countClient = 0;
    int lastTank = 0;

    public AutoLubricatorTileEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)IPTileTypes.AUTOLUBE.get(), pWorldPosition, pBlockState);
    }

    public AutoLubricatorTileEntity master() {
        AutoLubricatorTileEntity autolube;
        if (!this.isSlave || this.level == null) {
            return this;
        }
        BlockEntity te = this.level.getBlockEntity(this.getBlockPos().below());
        return te instanceof AutoLubricatorTileEntity ? (autolube = (AutoLubricatorTileEntity)te) : null;
    }

    @Override
    protected void readCustom(CompoundTag compound, HolderLookup.Provider provider) {
        this.isSlave = compound.getBoolean("slave");
        Direction facing = Direction.byName((String)compound.getString("facing"));
        this.facing = facing == null || facing.get2DDataValue() == -1 ? Direction.NORTH : facing;
        this.tank.readFromNBT(provider, compound.getCompound("tank"));
    }

    @Override
    protected void writeCustom(CompoundTag compound, HolderLookup.Provider provider) {
        compound.putBoolean("slave", this.isSlave);
        compound.putString("facing", this.facing.getName());
        compound.putInt("count", this.count);
        CompoundTag tank = this.tank.writeToNBT(provider, new CompoundTag());
        compound.put("tank", (Tag)tank);
    }

    @Override
    public void readOnPlacement(LivingEntity placer, ItemStack stack) {
        IPDataComponents.TankData tankData = (IPDataComponents.TankData)stack.get(IPDataComponents.TANK_DATA);
        if (tankData != null && !tankData.fs().isEmpty()) {
            this.tank.fill(tankData.fs(), IFluidHandler.FluidAction.EXECUTE);
        }
        if (placer instanceof Player) {
            IMultiblockBE me;
            LubricatedHandler.ILubricationHandler<?, ?> handler;
            BlockPos target;
            BlockEntity te;
            Player player = (Player)placer;
            if (this.level != null && (te = this.level.getBlockEntity(target = this.worldPosition.relative(this.facing))) instanceof IMultiblockBE && (handler = LubricatedHandler.getHandlerForTile((me = (IMultiblockBE)te).getHelper())) != null && handler.isPlacedCorrectly(this.level, this.getBlockPos(), this.facing)) {
                Utils.unlockIPAdvancement(player, "main/auto_lubricator");
            }
        }
    }

    @Override
    @Nonnull
    public List<ItemStack> getBlockEntityDrop(LootContext context) {
        BlockState state = (BlockState)context.getParamOrNull(LootContextParams.BLOCK_STATE);
        if (state == null || ((Boolean)state.getValue((Property)AutoLubricatorBlock.SLAVE)).booleanValue()) {
            return List.of(ItemStack.EMPTY);
        }
        ItemStack stack = new ItemStack((ItemLike)state.getBlock());
        BlockEntity te = (BlockEntity)context.getParamOrNull(LootContextParams.BLOCK_ENTITY);
        if (te instanceof AutoLubricatorTileEntity) {
            AutoLubricatorTileEntity autolube = (AutoLubricatorTileEntity)te;
            if (!autolube.tank.getFluid().isEmpty()) {
                FluidStack fs = autolube.tank.getFluid();
                stack.set(IPDataComponents.TANK_DATA, (Object)new IPDataComponents.TankData(fs));
            }
        }
        return List.of(stack);
    }

    @Override
    public <T> T getCapability(Direction side) {
        if (this.isSlave && (side == null || side == Direction.UP)) {
            AutoLubricatorTileEntity master = this.master();
            if (master == null) {
                return null;
            }
            return (T)master.tank;
        }
        return null;
    }

    public void setChanged() {
        super.setChanged();
        BlockState state = this.level.getBlockState(this.worldPosition);
        this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
        this.level.updateNeighborsAt(this.worldPosition, state.getBlock());
    }

    public Direction getFacing() {
        return this.facing;
    }

    public boolean isMaster() {
        return !this.isSlave;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        BlockPos pos = this.getBlockPos();
        return AABB.encapsulatingFullBlocks((BlockPos)pos.offset(-3, -3, -3), (BlockPos)pos.offset(3, 3, 3));
    }

    @Nullable
    public Component[] getOverlayText(@Nullable BlockState blockState, Player player, @Nonnull HitResult mop, boolean hammer) {
        AutoLubricatorTileEntity master;
        if (Utils.isFluidRelatedItemStack(player.getItemInHand(InteractionHand.MAIN_HAND)) && (master = this.master()) != null) {
            MutableComponent s = switch (master.tank.isEmpty() ? 0 : 1) {
                case 0 -> Component.translatable((String)"gui.immersiveengineering.empty");
                case 1 -> ((MutableComponent)master.tank.getFluid().getHoverName()).append(": " + master.tank.getFluidAmount() + "mB");
                default -> null;
            };
            return new Component[]{s};
        }
        return null;
    }

    @Override
    public InteractionResult interact(@Nonnull Direction side, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull ItemStack heldItem, float hitX, float hitY, float hitZ) {
        AutoLubricatorTileEntity master = this.master();
        if (master != null && this.level != null) {
            if (!this.level.isClientSide && FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)master.tank)) {
                this.setChanged();
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    @Override
    public void tickClient() {
        IMultiblockBEHelperMaster<?> masterHelper;
        IMultiblockBE mb;
        LubricatedHandler.ILubricationHandler<?, ?> handler;
        BlockPos target;
        BlockEntity te;
        if (this.isSlave || this.level == null) {
            return;
        }
        if (!this.tank.isEmpty() && LubricantHandler.isValidLube(this.tank.getFluid()) && this.tank.getFluidAmount() >= LubricantHandler.getLubeAmount(this.tank.getFluid()) && (te = this.level.getBlockEntity(target = this.worldPosition.relative(this.facing))) instanceof IMultiblockBE && (handler = LubricatedHandler.getHandlerForTile((mb = (IMultiblockBE)te).getHelper())) != null && handler.isPlacedCorrectly(this.level, this.getBlockPos(), this.facing) && handler.isMachineEnabled(this.level, masterHelper = Utils.getMultiblockMasterHelper(this.level, mb.getHelper()))) {
            handler.lubricateClient((ClientLevel)this.level, this.tank.getFluid().getFluid(), this.count, masterHelper);
            if (this.countClient++ % 50 == 0) {
                this.countClient = this.level.random.nextInt(40);
                handler.spawnLubricantParticles((ClientLevel)this.level, this.getBlockPos(), this.facing, masterHelper);
            }
        }
    }

    @Override
    public void tickServer() {
        IMultiblockBEHelperMaster<?> masterHelper;
        IMultiblockBE mb;
        LubricatedHandler.ILubricationHandler<?, ?> handler;
        BlockPos target;
        BlockEntity te;
        if (this.isSlave || this.level == null) {
            return;
        }
        if (!this.tank.isEmpty() && LubricantHandler.isValidLube(this.tank.getFluid()) && this.tank.getFluidAmount() >= LubricantHandler.getLubeAmount(this.tank.getFluid()) && (te = this.level.getBlockEntity(target = this.worldPosition.relative(this.facing))) instanceof IMultiblockBE && (handler = LubricatedHandler.getHandlerForTile((mb = (IMultiblockBE)te).getHelper())) != null && handler.isPlacedCorrectly(this.level, this.getBlockPos(), this.facing) && (masterHelper = Utils.getMultiblockMasterHelper(this.level, mb.getHelper())) != null && handler.isMachineEnabled(this.level, masterHelper)) {
            handler.lubricateServer((ServerLevel)this.level, this.tank.getFluid().getFluid(), this.count, masterHelper);
            if (this.count++ % 4 == 0) {
                this.tank.drain(LubricantHandler.getLubeAmount(this.tank.getFluid()), IFluidHandler.FluidAction.EXECUTE);
            }
            this.setChanged();
        }
        if (!this.level.isClientSide && this.lastTank != this.tank.getFluidAmount()) {
            this.lastTank = this.tank.getFluidAmount();
            this.setChanged();
        }
    }
}

