/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks.stone;

import flaxbeard.immersivepetroleum.common.IPTileTypes;
import flaxbeard.immersivepetroleum.common.blocks.IPBlockBase;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.WellPipeTileEntity;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.WellTileEntity;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.event.EventHooks;

public class WellPipeBlock
extends IPBlockBase
implements EntityBlock {
    public static final BooleanProperty BROKEN = BooleanProperty.create((String)"broken");

    public WellPipeBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).mapColor(MapColor.PODZOL).strength(75.0f, 10.0f).sound(SoundType.STONE).requiresCorrectToolForDrops().noLootTable());
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BROKEN, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BROKEN});
    }

    @Override
    public Supplier<BlockItem> blockItemSupplier() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addSelfToCreativeTab() {
        return false;
    }

    public void onNeighborChange(@Nonnull BlockState state, @Nonnull LevelReader world, @Nonnull BlockPos pos, @Nonnull BlockPos neighbor) {
    }

    public void onPlace(@Nonnull BlockState state, @Nonnull Level worldIn, @Nonnull BlockPos pos, @Nonnull BlockState oldState, boolean isMoving) {
    }

    public float getDestroyProgress(BlockState state, @Nonnull Player player, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos) {
        float f = state.getDestroySpeed(worldIn, pos);
        if (((Boolean)state.getValue((Property)BROKEN)).booleanValue()) {
            f /= 5.0f;
        }
        if (f == -1.0f) {
            return 0.0f;
        }
        int i = EventHooks.doPlayerHarvestCheck((Player)player, (BlockState)state, (BlockGetter)worldIn, (BlockPos)pos) ? 30 : 100;
        return player.getDigSpeed(state, pos) / f / (float)i;
    }

    public void onRemove(BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (!(!state.hasBlockEntity() || state.is(newState.getBlock()) && newState.hasBlockEntity())) {
            this.removed(state, world, pos);
            world.removeBlockEntity(pos);
        }
    }

    private void removed(BlockState state, Level world, BlockPos pos) {
        if (world.isClientSide || ((Boolean)state.getValue((Property)BROKEN)).booleanValue()) {
            return;
        }
        BlockEntity te = world.getBlockEntity(pos);
        if (te instanceof WellPipeTileEntity) {
            WellTileEntity well = null;
            for (int y = pos.getY() - 1; y >= world.getMinBuildHeight(); --y) {
                WellTileEntity w;
                BlockEntity teLow = world.getBlockEntity(new BlockPos(pos.getX(), y, pos.getZ()));
                if (!(teLow instanceof WellTileEntity)) continue;
                well = w = (WellTileEntity)teLow;
                break;
            }
            if (well != null && !well.pastPhysicalPart) {
                well.phyiscalPipesList.remove((Object)pos.getY());
                if (well.wellPipeLength > 0) {
                    --well.wellPipeLength;
                }
                well.setChanged();
            }
        }
    }

    public BlockEntity newBlockEntity(@Nonnull BlockPos pPos, @Nonnull BlockState pState) {
        return ((BlockEntityType)IPTileTypes.WELL_PIPE.get()).create(pPos, pState);
    }
}

