/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks.stone;

import flaxbeard.immersivepetroleum.common.blocks.IPBlockBase;
import flaxbeard.immersivepetroleum.common.cfg.IPServerConfig;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class AsphaltBlock
extends IPBlockBase {
    protected static final float SPEED_FACTOR = 1.2f;

    public AsphaltBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).speedFactor(1.2f).strength(2.0f, 10.0f).sound(SoundType.STONE).requiresCorrectToolForDrops());
    }

    public float getSpeedFactor() {
        return AsphaltBlock.speedFactor();
    }

    public void appendHoverText(@Nonnull ItemStack stack, @Nonnull Item.TooltipContext ctx, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        AsphaltBlock.tooltip(tooltip);
        super.appendHoverText(stack, ctx, tooltip, flag);
    }

    static void tooltip(List<Component> tooltip) {
        if (((Boolean)IPServerConfig.MISCELLANEOUS.asphalt_speed.get()).booleanValue()) {
            MutableComponent out = Component.translatable((String)"desc.immersivepetroleum.flavour.asphalt", (Object[])new Object[]{String.format(Locale.ENGLISH, "%.1f%%", Float.valueOf(20.000008f))}).withStyle(ChatFormatting.GRAY);
            tooltip.add((Component)out);
        }
    }

    static float speedFactor() {
        if (!((Boolean)IPServerConfig.MISCELLANEOUS.asphalt_speed.get()).booleanValue()) {
            return 1.0f;
        }
        return 1.2f;
    }
}

