/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks.multiblocks.shapes;

import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class GenericShape
implements Function<BlockPos, VoxelShape> {
    private static VoxelShape toVoxelShape(AABB aabb) {
        return Shapes.box((double)aabb.minX, (double)aabb.minY, (double)aabb.minZ, (double)aabb.maxX, (double)aabb.maxY, (double)aabb.maxZ);
    }

    @Override
    public VoxelShape apply(BlockPos posInMultiblock) {
        VoxelShape shape;
        List<AABB> list = this.getShape(posInMultiblock);
        if (list.size() > 1) {
            VoxelShape base = GenericShape.toVoxelShape(list.remove(0));
            shape = list.stream().map(GenericShape::toVoxelShape).reduce(base, Shapes::or);
        } else {
            shape = !list.isEmpty() ? GenericShape.toVoxelShape(list.remove(0)) : Shapes.empty();
        }
        return shape;
    }

    @Nonnull
    protected abstract List<AABB> getShape(BlockPos var1);
}

