/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks.multiblocks.logic;

import blusunrize.immersiveengineering.api.energy.AveragingEnergyStorage;
import blusunrize.immersiveengineering.api.fluid.IFluidPipe;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IMultiblockComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.common.blocks.multiblocks.blockimpl.InitialMultiblockContext;
import blusunrize.immersiveengineering.common.fluids.ArrayFluidHandler;
import flaxbeard.immersivepetroleum.api.reservoir.Reservoir;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirHandler;
import flaxbeard.immersivepetroleum.client.ClientProxy;
import flaxbeard.immersivepetroleum.client.gui.elements.PipeConfig;
import flaxbeard.immersivepetroleum.common.ExternalModContent;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.shapes.DerrickShape;
import flaxbeard.immersivepetroleum.common.blocks.stone.WellBlock;
import flaxbeard.immersivepetroleum.common.blocks.stone.WellPipeBlock;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.WellTileEntity;
import flaxbeard.immersivepetroleum.common.cfg.IPServerConfig;
import flaxbeard.immersivepetroleum.common.util.FluidHelper;
import flaxbeard.immersivepetroleum.common.util.RegistryUtils;
import flaxbeard.immersivepetroleum.common.util.Utils;
import flaxbeard.immersivepetroleum.common.util.inventory.FluidTankFiltered;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public class DerrickLogic
implements IMultiblockLogic<State>,
IServerTickableComponent<State>,
IClientTickableComponent<State> {
    public static final int REQUIRED_WATER_AMOUNT = 125;
    public static final int REQUIRED_CONCRETE_AMOUNT = 125;
    public static final FluidTank DUMMY_TANK = new FluidTank(0);
    public static final CapabilityPosition FLUID_IN = new CapabilityPosition(2, 0, 4, RelativeBlockFace.BACK);
    public static final CapabilityPosition FLUID_OUT = new CapabilityPosition(4, 0, 2, RelativeBlockFace.LEFT);
    public static final CapabilityPosition ENERGY_IN = new CapabilityPosition(2, 1, 0, RelativeBlockFace.UP);
    public static final BlockPos REDSTONE_IN = new BlockPos(0, 1, 1);
    private static final BlockState[] PARTICLE_STATES = new BlockState[]{Blocks.STONE.defaultBlockState(), Blocks.GRANITE.defaultBlockState(), Blocks.GRAVEL.defaultBlockState(), Blocks.DEEPSLATE.defaultBlockState(), Blocks.DIORITE.defaultBlockState(), Blocks.SAND.defaultBlockState(), Blocks.ANDESITE.defaultBlockState()};

    public State createInitialState(IInitialMultiblockContext<State> capabilitySource) {
        return new State(capabilitySource);
    }

    public void registerCapabilities(IMultiblockComponent.CapabilityRegistrar<State> register) {
        register.registerAtOrNull(Capabilities.EnergyStorage.BLOCK, ENERGY_IN, state -> state.energy);
        register.register(Capabilities.FluidHandler.BLOCK, (state, pos) -> {
            if (FLUID_IN.equals((Object)pos)) {
                return state.fluidHandler;
            }
            if (FLUID_OUT.equals((Object)pos)) {
                return state.emptyHandler;
            }
            return null;
        });
    }

    public void tickClient(IMultiblockContext<State> context) {
        State state = (State)context.getState();
        IMultiblockLevel level = context.getLevel();
        if (state.drilling) {
            state.rotation += 10;
            state.rotation %= 2160;
            double x = (double)level.toAbsolute(IPContent.Multiblock.DERRICK.masterPosInMB()).getX() + 0.5;
            double y = (double)level.toAbsolute(IPContent.Multiblock.DERRICK.masterPosInMB()).getY() + 1.0;
            double z = (double)level.toAbsolute(IPContent.Multiblock.DERRICK.masterPosInMB()).getZ() + 0.5;
            int r = level.getRawLevel().random.nextInt(PARTICLE_STATES.length);
            for (int i = 0; i < 5; ++i) {
                float xa = (level.getRawLevel().random.nextFloat() - 0.5f) * 10.0f;
                float ya = 5.0f;
                float za = (level.getRawLevel().random.nextFloat() - 0.5f) * 10.0f;
                level.getRawLevel().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, PARTICLE_STATES[r]), x, y, z, (double)xa, (double)ya, (double)za);
            }
        }
        if (state.spilling) {
            ClientProxy.spawnSpillParticles(level.getRawLevel(), level.toAbsolute(IPContent.Multiblock.DERRICK.masterPosInMB()), state.fluidSpilled, 5, 1.25f, state.clientFlow);
        }
    }

    public void tickServer(IMultiblockContext<State> context) {
        State state = (State)context.getState();
        IMultiblockLevel level = context.getLevel();
        boolean rsEnabled = state.rsState.isEnabled(context);
        if (state.level == null) {
            state.level = () -> ((IMultiblockLevel)level).getRawLevel();
        }
        if (state.originPos == null) {
            state.originPos = level.getAbsoluteOrigin();
        }
        boolean wasActive = false;
        boolean lastDrilling = state.drilling;
        boolean lastSpilling = state.spilling;
        state.spilling = false;
        state.drilling = false;
        if (level.getAbsoluteOrigin().getY() < level.getRawLevel().getSeaLevel()) {
            if (state.fluidSpilled == Fluids.EMPTY) {
                state.fluidSpilled = Fluids.WATER;
            }
            state.spilling = true;
        } else {
            WellTileEntity well = DerrickLogic.createAndGetWell(state.level, state, level.toAbsolute(IPContent.Multiblock.DERRICK.masterPosInMB()), this.getInventory(state, Inventory.INPUT) != ItemStack.EMPTY);
            if (rsEnabled && state.energy.extractEnergy(((Integer)IPServerConfig.EXTRACTION.derrick_consumption.get()).intValue(), true) >= (Integer)IPServerConfig.EXTRACTION.derrick_consumption.get() && well != null && well.wellPipeLength < well.getMaxPipeLength()) {
                ItemStack stack;
                if (well.pipes <= 0 && this.getInventory(state, Inventory.INPUT) != ItemStack.EMPTY && (stack = this.getInventory(state, Inventory.INPUT)).getCount() > 0) {
                    stack.shrink(1);
                    well.pipes = 6;
                    if (stack.getCount() <= 0) {
                        this.setInventory(state, Inventory.INPUT, ItemStack.EMPTY);
                    }
                    well.setChanged();
                    wasActive = true;
                }
                if (well.pipes > 0) {
                    BlockPos dPos = level.toAbsolute(IPContent.Multiblock.DERRICK.masterPosInMB());
                    BlockPos wPos = well.getBlockPos();
                    int realPipeLength = dPos.getY() - 1 - wPos.getY();
                    if (well.phyiscalPipesList.size() < realPipeLength && well.wellPipeLength < realPipeLength) {
                        if (state.tank.drain(125, IFluidHandler.FluidAction.SIMULATE).getAmount() >= 125) {
                            state.energy.extractEnergy(((Integer)IPServerConfig.EXTRACTION.derrick_consumption.get()).intValue(), false);
                            if (this.advanceTimer(state)) {
                                BlockPos current;
                                BlockState blockState;
                                Level world = level.getRawLevel();
                                for (int y = dPos.getY() - 1; y > wPos.getY() && (blockState = world.getBlockState(current = new BlockPos(dPos.getX(), y, dPos.getZ()))).getBlock() != Blocks.BEDROCK && blockState.getBlock() != IPContent.Blocks.WELL.get(); --y) {
                                    if (blockState.getBlock() == IPContent.Blocks.WELL_PIPE.get() && !((Boolean)blockState.getValue((Property)WellPipeBlock.BROKEN)).booleanValue()) continue;
                                    world.destroyBlock(current, false);
                                    world.setBlockAndUpdate(current, ((WellPipeBlock)IPContent.Blocks.WELL_PIPE.get()).defaultBlockState());
                                    well.phyiscalPipesList.add(y);
                                    state.tank.drain(125, IFluidHandler.FluidAction.EXECUTE);
                                    well.usePipe();
                                    break;
                                }
                                if (well.phyiscalPipesList.size() >= realPipeLength && well.wellPipeLength >= realPipeLength) {
                                    well.pastPhysicalPart = true;
                                    well.setChanged();
                                }
                            }
                            wasActive = true;
                            state.drilling = true;
                        }
                    } else {
                        if (!state.tank.getFluid().isEmpty() && ExternalModContent.IE.isConcrete(state.tank.getFluid())) {
                            state.tank.drain(state.tank.getFluidAmount(), IFluidHandler.FluidAction.EXECUTE);
                            wasActive = true;
                        }
                        if (state.tank.drain(125, IFluidHandler.FluidAction.SIMULATE).getAmount() >= 125) {
                            state.energy.extractEnergy(((Integer)IPServerConfig.EXTRACTION.derrick_consumption.get()).intValue(), false);
                            if (this.advanceTimer(state)) {
                                this.restorePhysicalPipeProgress(well, dPos, realPipeLength);
                                state.tank.drain(125, IFluidHandler.FluidAction.EXECUTE);
                                well.usePipe();
                            }
                            wasActive = true;
                            state.drilling = true;
                        }
                    }
                }
            }
            if (well != null && well.wellPipeLength == well.getMaxPipeLength()) {
                this.outputReservoirFluid(level, state, level.toAbsolute(FLUID_OUT.posInMultiblock()), context);
            }
        }
        if (state.spilling && state.fluidSpilled == Fluids.EMPTY) {
            state.fluidSpilled = IPContent.Fluids.CRUDEOIL.get();
        }
        if (!state.spilling && state.fluidSpilled != Fluids.EMPTY) {
            state.fluidSpilled = Fluids.EMPTY;
        }
        boolean forceSync = false;
        if (state.isRedstoned != !rsEnabled) {
            state.isRedstoned = !rsEnabled;
            forceSync = true;
        }
        if (forceSync || wasActive || lastDrilling != state.drilling || lastSpilling != state.spilling) {
            context.markDirtyAndSync();
        }
    }

    private static boolean acceptsFluid(Supplier<Level> level, State state, BlockPos inPos, FluidStack fs) {
        int waterNeeded;
        boolean isWater;
        if (fs.isEmpty()) {
            return false;
        }
        WellTileEntity well = DerrickLogic.createAndGetWell(level, state, inPos, false);
        if (well == null) {
            return false;
        }
        Fluid inFluid = fs.getFluid();
        boolean isConcrete = inFluid == ExternalModContent.IE.fluidConcrete();
        boolean bl = isWater = inFluid == Fluids.WATER;
        if (!isConcrete && !isWater) {
            return false;
        }
        int realPipeLength = inPos.getY() - 1 - well.getBlockPos().getY();
        int concreteNeeded = 125 * (realPipeLength - well.wellPipeLength);
        if (concreteNeeded > 0 && isConcrete) {
            FluidStack tankFluidStack = state.tank.getFluid();
            if (!tankFluidStack.isEmpty() && inFluid != tankFluidStack.getFluid() || tankFluidStack.getAmount() >= concreteNeeded) {
                return false;
            }
            return concreteNeeded >= fs.getAmount();
        }
        if (concreteNeeded <= 0 && (waterNeeded = 125 * (well.getMaxPipeLength() - well.wellPipeLength)) > 0 && isWater) {
            FluidStack tankFluidStack = state.tank.getFluid();
            if (!tankFluidStack.isEmpty() && inFluid != tankFluidStack.getFluid() || tankFluidStack.getAmount() >= waterNeeded) {
                return false;
            }
            return waterNeeded >= fs.getAmount();
        }
        return false;
    }

    public static WellTileEntity createAndGetWell(Supplier<Level> level, State state, BlockPos inPos, boolean popList) {
        Level rawLevel = level.get();
        if (state.wellCache != null && state.wellCache.isRemoved()) {
            state.wellCache = null;
        }
        if (state.wellCache == null) {
            WellTileEntity well = null;
            for (int y = inPos.below().getY(); y >= rawLevel.getMinBuildHeight() - 1; --y) {
                BlockPos current = new BlockPos(inPos.getX(), y, inPos.getZ());
                BlockState blockState = rawLevel.getBlockState(current);
                if (blockState.getBlock() == IPContent.Blocks.WELL.get()) {
                    well = (WellTileEntity)rawLevel.getBlockEntity(current);
                    break;
                }
                if (blockState.getBlock() != Blocks.BEDROCK) continue;
                rawLevel.setBlockAndUpdate(current, ((WellBlock)IPContent.Blocks.WELL.get()).defaultBlockState());
                well = (WellTileEntity)rawLevel.getBlockEntity(current);
                break;
            }
            state.wellCache = well;
        }
        if (popList && state.wellCache != null && state.wellCache.tappedReservoirs.isEmpty()) {
            if (state.gridStorage != null) {
                DerrickLogic.transferGridDataToWell(inPos, state, state.wellCache);
            } else {
                state.wellCache.tappedReservoirs.add(Utils.toColumnPos(inPos));
                state.wellCache.setChanged();
            }
        }
        if (state.wellCache != null) {
            state.wellCache.abortSelfDestructSequence();
        }
        return state.wellCache;
    }

    public ItemStack getInventory(State state, Inventory inv) {
        return (ItemStack)state.inventory.get(inv.id());
    }

    public ItemStack setInventory(State state, Inventory inv, ItemStack stack) {
        return (ItemStack)state.inventory.set(inv.id(), (Object)stack);
    }

    public void dropExtraItems(State state, Consumer<ItemStack> drop) {
        ItemStack stack = (ItemStack)state.inventory.getFirst();
        if (!stack.isEmpty()) {
            drop.accept(stack);
        }
    }

    private boolean advanceTimer(State state) {
        if (state.timer-- <= 0) {
            state.timer = 10;
            return true;
        }
        return false;
    }

    public void restorePhysicalPipeProgress(@Nonnull WellTileEntity well, BlockPos dPos, int realPipeLength) {
        int min = Math.min(well.wellPipeLength, realPipeLength);
        for (int i = 1; i < min; ++i) {
            BlockPos current = new BlockPos(dPos.getX(), dPos.getY() - i, dPos.getZ());
            BlockState blockState = well.getLevel().getBlockState(current);
            if (blockState.getBlock() instanceof WellPipeBlock) continue;
            well.getLevel().destroyBlock(current, false);
            well.getLevel().setBlockAndUpdate(current, ((WellPipeBlock)IPContent.Blocks.WELL_PIPE.get()).defaultBlockState());
        }
    }

    private void outputReservoirFluid(IMultiblockLevel mbLevel, State state, BlockPos inPos, IMultiblockContext<State> ctx) {
        Level rawLevel = mbLevel.getRawLevel();
        WellTileEntity well = DerrickLogic.createAndGetWell(() -> rawLevel, state, inPos, true);
        if (well == null) {
            return;
        }
        FluidStack extracted = this.getExtractedFluidStack(well);
        if (!extracted.isEmpty()) {
            Direction front = mbLevel.getOrientation().front();
            boolean mirrored = mbLevel.getOrientation().mirrored();
            Direction facing = mirrored ? front.getCounterClockWise() : front.getClockWise();
            BlockPos outPos = mbLevel.toAbsolute(FLUID_OUT.posInMultiblock()).relative(facing, 1);
            IFluidHandler fluidHandler = (IFluidHandler)rawLevel.getCapability(Capabilities.FluidHandler.BLOCK, outPos, (Object)facing.getOpposite());
            if (fluidHandler != null) {
                boolean isIEPipe = rawLevel.getBlockEntity(outPos) instanceof IFluidPipe;
                state.spilling = DerrickLogic.iterativeOutput(fluidHandler, extracted, isIEPipe);
            } else {
                state.spilling = true;
            }
        }
        if (state.spilling && !extracted.isEmpty() && state.fluidSpilled != extracted.getFluid()) {
            state.fluidSpilled = extracted.getFluid();
        }
        if (!state.spilling && state.fluidSpilled != Fluids.EMPTY) {
            state.fluidSpilled = Fluids.EMPTY;
        }
    }

    private static boolean iterativeOutput(IFluidHandler out, FluidStack extracted, boolean isIEPipe) {
        FluidStack fluid = FluidHelper.copyFluid(extracted, extracted.getAmount(), isIEPipe);
        int drainedTotal = 0;
        for (int attempt = 0; attempt < 10 && fluid.getAmount() > 0; ++attempt) {
            int accepted = out.fill(fluid, IFluidHandler.FluidAction.SIMULATE);
            if (accepted == 0) {
                return true;
            }
            int drained = out.fill(FluidHelper.copyFluid(fluid, Math.min(fluid.getAmount(), accepted), isIEPipe), IFluidHandler.FluidAction.EXECUTE);
            fluid = FluidHelper.copyFluid(extracted, fluid.getAmount() - drained, isIEPipe);
            drainedTotal += drained;
        }
        return extracted.getAmount() - drainedTotal > 0;
    }

    public static void transferGridDataToWell(BlockPos masterPos, State state, @Nullable WellTileEntity well) {
        if (well == null) {
            return;
        }
        int additionalPipes = 0;
        ArrayList<ColumnPos> list = new ArrayList<ColumnPos>();
        PipeConfig.Grid grid = state.gridStorage;
        for (int j = 0; j < grid.getHeight(); ++j) {
            for (int i = 0; i < grid.getWidth(); ++i) {
                int type = grid.get(i, j);
                if (type <= 0) continue;
                switch (type) {
                    case 2: 
                    case 3: {
                        int x = i - grid.getWidth() / 2;
                        int z = j - grid.getHeight() / 2;
                        ColumnPos pos = new ColumnPos(masterPos.getX() + x, masterPos.getZ() + z);
                        list.add(pos);
                    }
                    case 1: {
                        ++additionalPipes;
                    }
                }
            }
        }
        well.tappedReservoirs = list;
        well.additionalPipes = additionalPipes;
        well.setChanged();
    }

    private FluidStack getExtractedFluidStack(@Nonnull WellTileEntity well) {
        Fluid extractedFluid = Fluids.EMPTY;
        int extractedAmount = 0;
        for (ColumnPos cPos : well.tappedReservoirs) {
            Reservoir reservoir = ReservoirHandler.getReservoir(well.getLevel(), cPos);
            if (reservoir == null) continue;
            if (extractedFluid == Fluids.EMPTY) {
                extractedFluid = reservoir.getFluid();
            } else if (reservoir.getFluid() != extractedFluid) continue;
            extractedAmount += reservoir.extractWithPressure(well.getLevel(), cPos.x(), cPos.z());
        }
        return new FluidStack(extractedFluid, extractedAmount);
    }

    public void onRemoved(IMultiblockContext<State> context) {
        if (context.getLevel().getRawLevel().isClientSide) {
            return;
        }
        IMultiblockLevel mbLevel = context.getLevel();
        Level rawLevel = mbLevel.getRawLevel();
        WellTileEntity well = ((State)context.getState()).getWell(mbLevel, mbLevel.toRelative(IPContent.Multiblock.DERRICK.masterPosInMB()));
        if (well != null && !well.drillingCompleted) {
            if (well.wellPipeLength > 0) {
                well.startSelfDestructSequence();
            } else {
                rawLevel.setBlockAndUpdate(well.getBlockPos(), Blocks.BEDROCK.defaultBlockState());
            }
        }
    }

    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType forType) {
        return DerrickShape.GETTER;
    }

    public static class State
    implements IMultiblockState {
        public final AveragingEnergyStorage energy = new AveragingEnergyStorage(16000);
        public final RedstoneControl.RSState rsState = RedstoneControl.RSState.enabledByDefault();
        public int timer = 0;
        public int rotation = 0;
        public boolean drilling;
        public boolean spilling;
        private Fluid fluidSpilled = Fluids.EMPTY;
        public final FluidTankFiltered tank;
        public final NonNullList<ItemStack> inventory = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
        private WellTileEntity wellCache = null;
        @Nullable
        public PipeConfig.Grid gridStorage;
        private int clientFlow;
        private Supplier<Level> level;
        public BlockPos originPos;
        public boolean isRedstoned;
        private final IFluidHandler fluidHandler;
        private final IFluidHandler emptyHandler;
        private final IItemHandler itemHandler;

        public State(IInitialMultiblockContext<State> context) {
            this.originPos = ((InitialMultiblockContext)context).masterBE().getBlockPos();
            this.level = context.levelSupplier();
            Runnable markDirtyRunnable = context.getMarkDirtyRunnable();
            this.tank = new FluidTankFiltered(8000, fluidStack -> DerrickLogic.acceptsFluid(this.level, this, this.originPos, fluidStack));
            this.fluidHandler = ArrayFluidHandler.fillOnly((IFluidTank)this.tank, (Runnable)markDirtyRunnable);
            this.emptyHandler = ArrayFluidHandler.drainOnly((IFluidTank)DUMMY_TANK, (Runnable)markDirtyRunnable);
            this.itemHandler = new ItemStackHandler(this.inventory);
        }

        public void readSaveNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            this.drilling = nbt.getBoolean("drilling");
            this.spilling = nbt.getBoolean("spilling");
            this.clientFlow = nbt.getInt("spillflow");
            try {
                this.fluidSpilled = (Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.parse((String)nbt.getString("spillingfluid")));
            }
            catch (ResourceLocationException rle) {
                this.fluidSpilled = Fluids.EMPTY;
            }
            if (nbt.contains("grid", 10)) {
                this.gridStorage = PipeConfig.Grid.fromCompound(nbt.getCompound("grid"));
            }
            this.tank.readFromNBT(nbt.getCompound("tank"), provider);
            this.rsState.readSaveNBT(nbt, provider);
            this.isRedstoned = nbt.getBoolean("isRedstoned");
            ContainerHelper.loadAllItems((CompoundTag)nbt, this.inventory, (HolderLookup.Provider)provider);
        }

        public void writeSaveNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            nbt.putBoolean("drilling", this.drilling);
            nbt.putBoolean("spilling", this.spilling);
            nbt.putInt("spillflow", this.getReservoirFlow());
            nbt.putString("spillingfluid", RegistryUtils.getRegistryNameOf(this.fluidSpilled).toString());
            nbt.put("tank", (Tag)this.tank.writeToNBT(new CompoundTag(), provider));
            if (this.gridStorage != null) {
                nbt.put("grid", (Tag)this.gridStorage.toCompound());
            }
            this.rsState.writeSaveNBT(nbt, provider);
            nbt.putBoolean("isRedstoned", this.isRedstoned);
            ContainerHelper.saveAllItems((CompoundTag)nbt, this.inventory, (HolderLookup.Provider)provider);
        }

        public void readSyncNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            this.readSaveNBT(nbt, provider);
        }

        public void writeSyncNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            this.writeSaveNBT(nbt, provider);
        }

        private int getReservoirFlow() {
            Reservoir reservoir = ReservoirHandler.getReservoir(this.level.get(), this.originPos);
            if (reservoir == null || this.originPos.getY() < this.level.get().getSeaLevel()) {
                return 10;
            }
            return reservoir.getFlowFromPressure(this.level.get(), this.originPos);
        }

        public WellTileEntity getWell(IMultiblockLevel level, BlockPos inPos) {
            if (this.wellCache != null && this.wellCache.isRemoved()) {
                this.wellCache = null;
            }
            if (this.wellCache == null) {
                Level world = level.getRawLevel();
                WellTileEntity well = null;
                for (int y = inPos.below().getY(); y >= world.getMinBuildHeight(); --y) {
                    BlockPos current = new BlockPos(inPos.getX(), y, inPos.getZ());
                    BlockState blockState = world.getBlockState(current);
                    if (blockState.getBlock() != IPContent.Blocks.WELL.get()) continue;
                    well = (WellTileEntity)world.getBlockEntity(current);
                    break;
                }
                this.wellCache = well;
            }
            return this.wellCache;
        }
    }

    public static enum Inventory {
        INPUT;


        public int id() {
            return this.ordinal();
        }
    }
}

