/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks.multiblocks;

import blusunrize.immersiveengineering.api.multiblocks.ClientMultiblocks;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import flaxbeard.immersivepetroleum.client.utils.MCUtil;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.IPTemplateMultiblock;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;

public class IPMultiblockProperties
implements ClientMultiblocks.MultiblockManualData {
    static final Direction[] DIRECTIONS;
    private final IPTemplateMultiblock multiblock;
    @Nullable
    private NonNullList<ItemStack> materials;
    private final ItemStack renderStack;
    @Nullable
    private final Vec3 renderOffset;
    static final RandomSource RANDOM_SOURCE;

    public IPMultiblockProperties(IPTemplateMultiblock multiblock) {
        this(multiblock, null);
    }

    public IPMultiblockProperties(IPTemplateMultiblock multiblock, double offX, double offY, double offZ) {
        this(multiblock, new Vec3(offX, offY, offZ));
    }

    private IPMultiblockProperties(IPTemplateMultiblock multiblock, @Nullable Vec3 renderOffset) {
        this.multiblock = multiblock;
        this.renderStack = new ItemStack((ItemLike)multiblock.getBlock());
        this.renderOffset = renderOffset;
    }

    protected boolean usingCustomRendering() {
        return false;
    }

    public NonNullList<ItemStack> getTotalMaterials() {
        if (this.materials != null) {
            return this.materials;
        }
        List structure = this.multiblock.getStructure((Level)MCUtil.getLevel());
        this.materials = structure.stream().map(info -> new ItemStack((ItemLike)info.state().getBlock().asItem(), 1)).collect(HashMap::new, (map, stack) -> map.compute(stack.getItem(), (item, count) -> count == null ? 1 : count + 1), HashMap::putAll).entrySet().stream().map(e -> new ItemStack((ItemLike)e.getKey(), ((Integer)e.getValue()).intValue())).collect(NonNullList::create, AbstractList::add, AbstractCollection::addAll);
        return this.materials;
    }

    public boolean canRenderFormedStructure() {
        return this.renderOffset != null;
    }

    public void renderExtras(PoseStack matrix, MultiBufferSource buffer) {
    }

    public void renderCustomFormedStructure(PoseStack matrix, MultiBufferSource buffer) {
    }

    public final void renderFormedStructure(PoseStack matrix, MultiBufferSource buffer) {
        Objects.requireNonNull(this.renderOffset);
        if (this.usingCustomRendering()) {
            this.renderCustomFormedStructure(matrix, buffer);
            return;
        }
        matrix.pushPose();
        matrix.translate(this.renderOffset.x - 0.5, this.renderOffset.y - 0.5, this.renderOffset.z - 0.5);
        matrix.pushPose();
        PoseStack.Pose last = matrix.last();
        BakedModel bakedmodel = MCUtil.getItemRenderer().getModel(this.renderStack, null, null, 0);
        VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.cutout());
        for (Direction direction : DIRECTIONS) {
            RANDOM_SOURCE.setSeed(42L);
            List quads = bakedmodel.getQuads(null, direction, RANDOM_SOURCE, ModelData.EMPTY, null);
            for (BakedQuad quad : quads) {
                vertexConsumer.putBulkData(last, quad, 1.0f, 1.0f, 1.0f, 1.0f, 0xF000F0, OverlayTexture.NO_OVERLAY);
            }
        }
        matrix.popPose();
        matrix.pushPose();
        this.renderExtras(matrix, buffer);
        matrix.popPose();
        matrix.popPose();
    }

    static {
        Direction[] source = Direction.values();
        Direction[] destination = new Direction[source.length + 1];
        System.arraycopy(source, 0, destination, 0, source.length);
        destination[destination.length - 1] = null;
        DIRECTIONS = destination;
        RANDOM_SOURCE = RandomSource.create();
    }
}

