/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks.metal;

import blusunrize.immersiveengineering.common.util.ChatUtils;
import flaxbeard.immersivepetroleum.common.ExternalModContent;
import flaxbeard.immersivepetroleum.common.IPTileTypes;
import flaxbeard.immersivepetroleum.common.blocks.IPBlockBase;
import flaxbeard.immersivepetroleum.common.blocks.IPBlockItemBase;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.FlarestackTileEntity;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class FlarestackBlock
extends IPBlockBase
implements EntityBlock {
    public static final BooleanProperty SLAVE = BooleanProperty.create((String)"slave");
    static VoxelShape SHAPE_SLAVE;
    static VoxelShape SHAPE_MASTER;

    public FlarestackBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).pushReaction(PushReaction.BLOCK).strength(3.0f, 15.0f).sound(SoundType.METAL).requiresCorrectToolForDrops().noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)SLAVE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public Supplier<BlockItem> blockItemSupplier() {
        return () -> new FlarestackBlockItem(this);
    }

    @Override
    public boolean addSelfToCreativeTab() {
        return false;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{SLAVE});
    }

    public int getLightBlock(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos) {
        return 0;
    }

    public boolean propagatesSkylightDown(@Nonnull BlockState state, @Nonnull BlockGetter reader, @Nonnull BlockPos pos) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getShadeBrightness(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos) {
        return 1.0f;
    }

    @Override
    @Nonnull
    public InteractionResult use(@Nonnull BlockState state, @Nonnull Level worldIn, @Nonnull BlockPos pos, Player player, @Nonnull InteractionHand handIn, @Nonnull BlockHitResult hit) {
        if (ExternalModContent.IE.isScrewdriver(player.getItemInHand(handIn))) {
            BlockEntity te;
            if (((Boolean)state.getValue((Property)SLAVE)).booleanValue()) {
                pos = pos.relative(Direction.DOWN);
            }
            if (!worldIn.isClientSide && (te = worldIn.getBlockEntity(pos)) instanceof FlarestackTileEntity) {
                FlarestackTileEntity flare = (FlarestackTileEntity)te;
                flare.invertRedstone();
                ChatUtils.sendServerNoSpamMessages((Player)player, (Component)Component.translatable((String)("chat.immersiveengineering.info.rsControl." + (flare.isRedstoneInverted() ? "invertedOn" : "invertedOff"))));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Nonnull
    public BlockState playerWillDestroy(@Nonnull Level worldIn, @Nonnull BlockPos pos, BlockState state, @Nonnull Player player) {
        if (((Boolean)state.getValue((Property)SLAVE)).booleanValue()) {
            worldIn.destroyBlock(pos.offset(0, -1, 0), !player.isCreative());
        } else {
            worldIn.destroyBlock(pos.offset(0, 1, 0), false);
        }
        return super.playerWillDestroy(worldIn, pos, state, player);
    }

    @Override
    public void setPlacedBy(Level worldIn, @Nonnull BlockPos pos, @Nonnull BlockState state, LivingEntity placer, @Nonnull ItemStack stack) {
        if (!worldIn.isClientSide) {
            worldIn.setBlockAndUpdate(pos.relative(Direction.UP), (BlockState)state.setValue((Property)SLAVE, (Comparable)Boolean.valueOf(true)));
        }
    }

    public void entityInside(BlockState state, @Nonnull Level worldIn, @Nonnull BlockPos pos, @Nonnull Entity entityIn) {
        if (((Boolean)state.getValue((Property)SLAVE)).booleanValue() && !entityIn.fireImmune()) {
            entityIn.hurt(worldIn.damageSources().hotFloor(), 1.0f);
        }
    }

    @Nonnull
    public List<ItemStack> getDrops(BlockState state, @Nonnull LootParams.Builder builder) {
        if (((Boolean)state.getValue((Property)SLAVE)).booleanValue()) {
            return Collections.emptyList();
        }
        return super.getDrops(state, builder);
    }

    @Nonnull
    public VoxelShape getShape(BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        if (((Boolean)state.getValue((Property)SLAVE)).booleanValue()) {
            if (SHAPE_SLAVE == null) {
                VoxelShape s0 = Shapes.box((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)0.75, (double)0.875);
                VoxelShape s1 = Shapes.box((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.375, (double)0.9375);
                SHAPE_SLAVE = Shapes.join((VoxelShape)s0, (VoxelShape)s1, (BooleanOp)BooleanOp.OR);
            }
            return SHAPE_SLAVE;
        }
        if (SHAPE_MASTER == null) {
            VoxelShape s0 = Shapes.box((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)0.75, (double)0.875);
            VoxelShape s1 = Shapes.box((double)0.0625, (double)0.5, (double)0.0625, (double)0.9375, (double)1.0, (double)0.9375);
            SHAPE_MASTER = Shapes.join((VoxelShape)s0, (VoxelShape)s1, (BooleanOp)BooleanOp.OR);
        }
        return SHAPE_MASTER;
    }

    public BlockEntity newBlockEntity(@Nonnull BlockPos pPos, BlockState pState) {
        if (((Boolean)pState.getValue((Property)SLAVE)).booleanValue()) {
            return null;
        }
        return ((BlockEntityType)IPTileTypes.FLARE.get()).create(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@Nonnull Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<T> type) {
        if (((Boolean)state.getValue((Property)SLAVE)).booleanValue()) {
            return null;
        }
        return FlarestackBlock.createCommonTicker(level.isClientSide, type, IPTileTypes.FLARE);
    }

    public static class FlarestackBlockItem
    extends IPBlockItemBase {
        public FlarestackBlockItem(Block blockIn) {
            super(blockIn, new Item.Properties());
        }

        protected boolean canPlace(@Nonnull BlockPlaceContext con, @Nonnull BlockState state) {
            if (super.canPlace(con, state)) {
                BlockPos otherPos = con.getClickedPos().relative(Direction.UP);
                BlockState otherState = con.getLevel().getBlockState(otherPos);
                return otherState.isAir();
            }
            return false;
        }
    }
}

