/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common;

import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import java.util.function.Function;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.registries.DeferredHolder;

public class ExternalModContent {
    public static void setup(FMLCommonSetupEvent event) {
        IE.forceClassLoad();
    }

    public static class IE {
        private static final Loader loader = new Loader(ResourceUtils::ie);
        private static final DeferredHolder<Block, Block> BLOCK_REDSTONE_ENGINEERING = loader.block("rs_engineering");
        private static final DeferredHolder<Item, Item> ITEM_HAMMER = loader.item("hammer");
        private static final DeferredHolder<Item, Item> ITEM_SCREWDRIVER = loader.item("screwdriver");
        private static final DeferredHolder<Item, Item> ITEM_PIPE = loader.item("fluid_pipe");
        private static final DeferredHolder<Item, Item> ITEM_BUCKSHOT = loader.item("bullet_buckshot");
        private static final DeferredHolder<Item, Item> ITEM_EMPTY_SHELL = loader.item("empty_shell");
        private static final DeferredHolder<Fluid, Fluid> FLUID_CONCRETE = loader.fluid("concrete");

        public static Fluid fluidConcrete() {
            return (Fluid)FLUID_CONCRETE.get();
        }

        public static FluidStack fluidConcrete(int amount) {
            return new FluidStack((Fluid)FLUID_CONCRETE.get(), amount);
        }

        public static Block blockRSEngineering() {
            return (Block)BLOCK_REDSTONE_ENGINEERING.get();
        }

        public static Item itemBuckshot() {
            return (Item)ITEM_BUCKSHOT.get();
        }

        public static Item itemEmptyShell() {
            return (Item)ITEM_EMPTY_SHELL.get();
        }

        public static Item itemPipe() {
            return (Item)ITEM_PIPE.get();
        }

        public static Item itemHammer() {
            return (Item)ITEM_HAMMER.get();
        }

        public static Item itemScrewdriver() {
            return (Item)ITEM_SCREWDRIVER.get();
        }

        public static boolean isConcrete(FluidStack fluid) {
            return IE.isConcrete(fluid.getFluid());
        }

        public static boolean isConcrete(Fluid fluid) {
            return IE.fluidConcrete().equals(fluid);
        }

        public static boolean isRedstoneEngineering(Block block) {
            return IE.blockRSEngineering().equals(block);
        }

        public static boolean isBuckshot(ItemStack stack) {
            return IE.isBuckshot(stack.getItem());
        }

        public static boolean isBuckshot(Item item) {
            return IE.itemBuckshot().equals(item);
        }

        public static boolean isEmptyShell(ItemStack stack) {
            return IE.isEmptyShell(stack.getItem());
        }

        public static boolean isEmptyShell(Item item) {
            return IE.itemEmptyShell().equals(item);
        }

        public static boolean isPipe(ItemStack stack) {
            return IE.isPipe(stack.getItem());
        }

        public static boolean isPipe(Item item) {
            return IE.itemPipe().equals(item);
        }

        public static boolean isHammer(ItemStack stack) {
            return IE.isHammer(stack.getItem());
        }

        public static boolean isHammer(Item item) {
            return IE.itemHammer().equals(item);
        }

        public static boolean isScrewdriver(ItemStack stack) {
            return IE.isScrewdriver(stack.getItem());
        }

        public static boolean isScrewdriver(Item item) {
            return IE.itemScrewdriver().equals(item);
        }

        private static void forceClassLoad() {
        }
    }

    private record Loader(Function<String, ResourceLocation> modLoc) {
        public DeferredHolder<Block, Block> block(String name) {
            return DeferredHolder.create((ResourceKey)BuiltInRegistries.BLOCK.key(), (ResourceLocation)this.modLoc.apply(name));
        }

        public DeferredHolder<Item, Item> item(String name) {
            return DeferredHolder.create((ResourceKey)BuiltInRegistries.ITEM.key(), (ResourceLocation)this.modLoc.apply(name));
        }

        public DeferredHolder<Fluid, Fluid> fluid(String name) {
            return DeferredHolder.create((ResourceKey)BuiltInRegistries.FLUID.key(), (ResourceLocation)this.modLoc.apply(name));
        }
    }
}

