/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common;

import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelper;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelperMaster;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockBE;
import flaxbeard.immersivepetroleum.ImmersivePetroleum;
import flaxbeard.immersivepetroleum.api.crafting.LubricatedHandler;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirHandler;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.IPSaveData;
import flaxbeard.immersivepetroleum.common.cfg.IPServerConfig;
import flaxbeard.immersivepetroleum.common.datastorage.reservoir.ReservoirRegionDataStorage;
import flaxbeard.immersivepetroleum.common.entity.MotorboatEntity;
import flaxbeard.immersivepetroleum.common.fluids.NapalmFluid;
import flaxbeard.immersivepetroleum.common.util.IPEffects;
import flaxbeard.immersivepetroleum.common.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.EntityMountEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class CommonEventHandler {
    static final Random random = new Random();
    public static final Map<ResourceLocation, List<BlockPos>> napalmPositions = new HashMap<ResourceLocation, List<BlockPos>>();
    public static final Map<ResourceLocation, List<BlockPos>> toRemove = new HashMap<ResourceLocation, List<BlockPos>>();

    @SubscribeEvent
    public void onSave(LevelEvent.Save event) {
        if (!event.getLevel().isClientSide()) {
            IPSaveData.markDirty();
        }
    }

    @SubscribeEvent
    public void onUnload(LevelEvent.Unload event) {
        if (!event.getLevel().isClientSide()) {
            IPSaveData.markDirty();
            ReservoirRegionDataStorage.get().markAllDirty();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onServerStopped(ServerStoppedEvent event) {
        ImmersivePetroleum.log.debug("[ReservoirHandler]: Clearing Cache...");
        ReservoirHandler.clearCache();
    }

    @SubscribeEvent
    public void handleBoatImmunity(LivingDamageEvent.Pre event) {
        Level level = event.getEntity().level();
        DamageSources dmg = level.damageSources();
        if (event.getSource() == dmg.lava() || event.getSource() == dmg.onFire() || event.getSource() == dmg.inFire()) {
            LivingEntity entity = event.getEntity();
            Entity entity2 = entity.getVehicle();
            if (entity2 instanceof MotorboatEntity) {
                MotorboatEntity boat = (MotorboatEntity)entity2;
                if (boat.isFireproof) {
                    event.setNewDamage(0.0f);
                    return;
                }
            }
            if (entity.getRemainingFireTicks() > 0 && entity.getEffect(IPEffects.ANTI_DISMOUNT_FIRE) != null) {
                entity.clearFire();
                entity.removeEffect(IPEffects.ANTI_DISMOUNT_FIRE);
                event.setNewDamage(0.0f);
            }
        }
    }

    @SubscribeEvent
    public void handleBoatImmunity(PlayerTickEvent.Pre event) {
        Entity entity;
        Player entity2 = event.getEntity();
        if (entity2.isOnFire() && (entity = entity2.getVehicle()) instanceof MotorboatEntity) {
            MotorboatEntity boat = (MotorboatEntity)entity;
            if (boat.isFireproof) {
                entity2.clearFire();
                boat.setSharedFlag(0, false);
            }
        }
    }

    @SubscribeEvent
    public void handleDismountingBoat(EntityMountEvent event) {
        Entity entity = event.getEntityMounting();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            entity = event.getEntityBeingMounted();
            if (entity instanceof MotorboatEntity) {
                FluidState fluidstate;
                MotorboatEntity boat = (MotorboatEntity)entity;
                if (event.isDismounting() && boat.isFireproof && (fluidstate = event.getLevel().getBlockState(BlockPos.containing((Position)boat.position().add(0.5, 0.0, 0.5))).getFluidState()) != Fluids.EMPTY.defaultFluidState() && fluidstate.is(FluidTags.LAVA)) {
                    living.addEffect(new MobEffectInstance(IPEffects.ANTI_DISMOUNT_FIRE, 1, 0, false, false));
                }
            }
        }
    }

    @SubscribeEvent
    public void handleLubricatingMachinesServer(LevelTickEvent.Post event) {
        CommonEventHandler.handleLubricatingMachines(event.getLevel());
    }

    public static void handleLubricatingMachines(Level world) {
        HashSet<LubricatedHandler.LubricatedTileInfo> toRemove = new HashSet<LubricatedHandler.LubricatedTileInfo>();
        for (LubricatedHandler.LubricatedTileInfo info : LubricatedHandler.lubricatedTiles) {
            IMultiblockBE multiblockBE;
            IMultiblockBEHelperMaster<?> masterHelper;
            LubricatedHandler.ILubricationHandler<?, ?> lubeHandler;
            BlockEntity blockEntity;
            if (info.world != world.dimension() || !world.isAreaLoaded(info.pos, 0) || !((blockEntity = world.getBlockEntity(info.pos)) instanceof IMultiblockBE) || (lubeHandler = LubricatedHandler.getHandlerForTile(masterHelper = Utils.getMultiblockMasterHelper(world, (multiblockBE = (IMultiblockBE)blockEntity).getHelper()))) == null) continue;
            if (lubeHandler.isMachineEnabled(world, masterHelper)) {
                if (world.isClientSide) {
                    lubeHandler.lubricateClient((ClientLevel)world, info.lubricant, info.ticks, masterHelper);
                } else {
                    lubeHandler.lubricateServer((ServerLevel)world, info.lubricant, info.ticks, masterHelper);
                }
            }
            if (world.isClientSide && multiblockBE.getHelper().getContext() != null) {
                IMultiblockBEHelper helper = multiblockBE.getHelper();
                IMultiblockLevel mbLevel = helper.getContext().getLevel();
                Vec3i size = (Vec3i)helper.getMultiblock().getSize().apply(world);
                for (int y = 0; y < size.getY(); ++y) {
                    for (int z = 0; z < size.getZ(); ++z) {
                        for (int x = 0; x < size.getX(); ++x) {
                            Direction randomDir;
                            IMultiblockBE mb;
                            BlockPos pos;
                            BlockEntity blockEntity2;
                            if (random.nextFloat() >= 0.1f || !((blockEntity2 = world.getBlockEntity(pos = mbLevel.toAbsolute(new BlockPos(x, y, z)))) instanceof IMultiblockBE) || (mb = (IMultiblockBE)blockEntity2).getHelper().getContext().getState() != helper.getContext().getState() || !world.isEmptyBlock(pos.relative(randomDir = Direction.Plane.HORIZONTAL.getRandomDirection(world.random)))) continue;
                            float px = pos.getX();
                            float py = pos.getY();
                            float pz = pos.getZ();
                            switch (randomDir) {
                                case NORTH: {
                                    px += random.nextFloat();
                                    py += random.nextFloat();
                                    pz -= 0.0625f;
                                    break;
                                }
                                case EAST: {
                                    px += 1.0625f;
                                    py += random.nextFloat();
                                    pz += random.nextFloat();
                                    break;
                                }
                                case SOUTH: {
                                    px += random.nextFloat();
                                    py += random.nextFloat();
                                    pz += 1.0625f;
                                    break;
                                }
                                case WEST: {
                                    px -= 0.0625f;
                                    py += random.nextFloat();
                                    pz += random.nextFloat();
                                }
                            }
                            world.addParticle((ParticleOptions)ParticleTypes.FALLING_HONEY, (double)px, (double)py, (double)pz, 0.0, 0.0, 0.0);
                        }
                    }
                }
            }
            if (info.ticks-- > 0) continue;
            toRemove.add(info);
        }
        for (LubricatedHandler.LubricatedTileInfo info : toRemove) {
            LubricatedHandler.lubricatedTiles.remove(info);
        }
    }

    @SubscribeEvent
    public void onEntityJoiningWorld(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (event.getEntity() instanceof FakePlayer) {
                return;
            }
            if (((Boolean)IPServerConfig.MISCELLANEOUS.autounlock_recipes.get()).booleanValue()) {
                ArrayList l = new ArrayList();
                Collection recipes = event.getLevel().getRecipeManager().getRecipes();
                recipes.forEach(recipe -> {
                    ResourceLocation name = recipe.id();
                    if (name.getNamespace().equals("immersivepetroleum")) {
                        l.add(recipe);
                    }
                });
                player.awardRecipes(l);
            }
        }
    }

    @SubscribeEvent
    public void livingDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Skeleton) {
            DamageSource src;
            Entity entity;
            Skeleton skelly = (Skeleton)livingEntity;
            if (!skelly.level().isClientSide && (entity = (src = event.getSource()).getEntity()) instanceof Player) {
                Entity entity2;
                Player player = (Player)entity;
                if (!player.level().isClientSide && (entity2 = player.getVehicle()) instanceof MotorboatEntity) {
                    MotorboatEntity motorboat = (MotorboatEntity)entity2;
                    if (!motorboat.level().isClientSide && !src.isDirect() && motorboat.isSpinningFastEnough() && motorboat.hasRudders) {
                        Utils.unlockIPAdvancement(player, "main/rudders");
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void handleNapalmPre(LevelTickEvent.Pre event) {
        this.handleNapalm((LevelTickEvent)event);
    }

    @SubscribeEvent
    public void handleNapalmPost(LevelTickEvent.Post event) {
        this.handleNapalm((LevelTickEvent)event);
    }

    private void handleNapalm(LevelTickEvent event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        ResourceLocation d = event.getLevel().dimension().location();
        if (event instanceof LevelTickEvent.Pre) {
            if (napalmPositions.get(d) != null) {
                List trList = toRemove.computeIfAbsent(d, f -> new ArrayList());
                new ArrayList<BlockPos>((Collection)napalmPositions.get(d)).forEach(pos -> {
                    LiquidBlock fluidBlock;
                    BlockState state = event.getLevel().getBlockState(pos);
                    Block patt0$temp = state.getBlock();
                    if (patt0$temp instanceof LiquidBlock && (fluidBlock = (LiquidBlock)patt0$temp) == IPContent.Fluids.NAPALM.block().get()) {
                        NapalmFluid.processFire(IPContent.Fluids.NAPALM, event.getLevel(), pos);
                    }
                    trList.add(pos);
                });
            }
        } else if (event instanceof LevelTickEvent.Post && toRemove.get(d) != null && napalmPositions.get(d) != null) {
            ArrayList list = new ArrayList(toRemove.get(d));
            napalmPositions.get(d).removeAll(list);
            toRemove.get(d).clear();
        }
    }
}

