/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client.render.multiblock;

import blusunrize.immersiveengineering.api.multiblocks.blocks.registry.MultiblockBlockEntityMaster;
import blusunrize.immersiveengineering.client.utils.GuiHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import flaxbeard.immersivepetroleum.client.render.IPRenderTypes;
import flaxbeard.immersivepetroleum.client.render.multiblock.IPMultiblockRenderer;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.OilTankMultiblock;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.logic.OilTankLogic;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class MultiblockOilTankRenderer
extends IPMultiblockRenderer<OilTankLogic.State> {
    public MultiblockOilTankRenderer() {
        super(() -> OilTankMultiblock.INSTANCE);
    }

    public void render(MultiblockBlockEntityMaster<OilTankLogic.State> te, float partialTicks, @Nonnull PoseStack matrix, @Nonnull MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        if (te.isRemoved() || te.getLevel() == null || !te.getLevel().hasChunkAt(te.getBlockPos())) {
            return;
        }
        combinedOverlayIn = OverlayTexture.NO_OVERLAY;
        matrix.pushPose();
        switch (te.getHelper().getContext().getLevel().getOrientation().front()) {
            case EAST: {
                matrix.mulPose(ROT_270);
                matrix.translate(0.0f, 0.0f, -1.0f);
                break;
            }
            case SOUTH: {
                matrix.mulPose(ROT_180);
                matrix.translate(-1.0f, 0.0f, -1.0f);
                break;
            }
            case WEST: {
                matrix.mulPose(ROT_90);
                matrix.translate(-1.0f, 0.0f, 0.0f);
                break;
            }
        }
        matrix.pushPose();
        matrix.translate(1.0f, 2.0f, 2.995f);
        Matrix4f mat = matrix.last().pose();
        VertexConsumer builder = buffer.getBuffer(IPRenderTypes.TRANSLUCENT_POSITION_COLOR);
        builder.addVertex(mat, 1.5f, -0.5f, 0.0f).setColor(34, 34, 34, 255);
        builder.addVertex(mat, 1.5f, 1.0f, 0.0f).setColor(34, 34, 34, 255);
        builder.addVertex(mat, 0.0f, 1.0f, 0.0f).setColor(34, 34, 34, 255);
        builder.addVertex(mat, 0.0f, -0.5f, 0.0f).setColor(34, 34, 34, 255);
        FluidStack fs = ((OilTankLogic.State)te.getHelper().getState()).tank.getFluid();
        if (!fs.isEmpty()) {
            matrix.pushPose();
            matrix.translate(0.25, 0.875, (double)0.0025f);
            matrix.scale(0.0625f, -0.0625f, 0.0625f);
            float h = (float)fs.getAmount() / (float)((OilTankLogic.State)te.getHelper().getState()).tank.getCapacity();
            GuiHelper.drawRepeatedFluidSprite((VertexConsumer)buffer.getBuffer(RenderType.solid()), (PoseStack)matrix, (FluidStack)fs, (float)0.0f, (float)(0.0f + (1.0f - h) * 16.0f), (float)16.0f, (float)(h * 16.0f));
            matrix.popPose();
        }
        matrix.popPose();
        matrix.pushPose();
        if (te.getHelper().getContext().getLevel().getOrientation().mirrored()) {
            for (OilTankLogic.Port port : OilTankLogic.Port.DYNAMIC_PORTS) {
                matrix.pushPose();
                BlockPos p = port.posInMultiblock.posInMultiblock().subtract((Vec3i)te.getHelper().getPositionInMB());
                matrix.mulPose(Axis.YP.rotationDegrees(180.0f));
                matrix.translate((float)(p.getX() - 1), (float)p.getY(), (float)(-p.getZ() - 1));
                this.quad(matrix, buffer, ((OilTankLogic.State)te.getHelper().getState()).getPortStateFor(port), port.posInMultiblock.posInMultiblock().getX() == 4, combinedLightIn, combinedOverlayIn);
                matrix.popPose();
            }
        } else {
            for (OilTankLogic.Port port : OilTankLogic.Port.DYNAMIC_PORTS) {
                matrix.pushPose();
                BlockPos p = port.posInMultiblock.posInMultiblock().subtract((Vec3i)te.getHelper().getPositionInMB());
                matrix.translate((float)p.getX(), (float)p.getY(), (float)p.getZ());
                this.quad(matrix, buffer, ((OilTankLogic.State)te.getHelper().getState()).getPortStateFor(port), port.posInMultiblock.posInMultiblock().getX() == 4, combinedLightIn, combinedOverlayIn);
                matrix.popPose();
            }
        }
        matrix.popPose();
        matrix.popPose();
    }

    public void quad(PoseStack matrix, MultiBufferSource buffer, OilTankLogic.PortState portState, boolean flip, int combinedLight, int combinedOverlay) {
        Matrix4f mat = matrix.last().pose();
        VertexConsumer builder = buffer.getBuffer(IPRenderTypes.OIL_TANK);
        boolean input = portState == OilTankLogic.PortState.INPUT;
        float u0 = input ? 0.0f : 0.1f;
        float v0 = 0.5f;
        float u1 = u0 + 0.1f;
        float v1 = v0 + 0.1f;
        if (flip) {
            builder.addVertex(mat, 1.001f, 0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(u1, v1).setOverlay(combinedOverlay).setLight(combinedLight).setNormal(1.0f, 1.0f, 1.0f);
            builder.addVertex(mat, 1.001f, 1.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(u1, v0).setOverlay(combinedOverlay).setLight(combinedLight).setNormal(1.0f, 1.0f, 1.0f);
            builder.addVertex(mat, 1.001f, 1.0f, 1.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(u0, v0).setOverlay(combinedOverlay).setLight(combinedLight).setNormal(1.0f, 1.0f, 1.0f);
            builder.addVertex(mat, 1.001f, 0.0f, 1.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(u0, v1).setOverlay(combinedOverlay).setLight(combinedLight).setNormal(1.0f, 1.0f, 1.0f);
        } else {
            builder.addVertex(mat, -0.001f, 0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(u0, v1).setOverlay(combinedOverlay).setLight(combinedLight).setNormal(1.0f, 1.0f, 1.0f);
            builder.addVertex(mat, -0.001f, 0.0f, 1.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(u1, v1).setOverlay(combinedOverlay).setLight(combinedLight).setNormal(1.0f, 1.0f, 1.0f);
            builder.addVertex(mat, -0.001f, 1.0f, 1.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(u1, v0).setOverlay(combinedOverlay).setLight(combinedLight).setNormal(1.0f, 1.0f, 1.0f);
            builder.addVertex(mat, -0.001f, 1.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(u0, v0).setOverlay(combinedOverlay).setLight(combinedLight).setNormal(1.0f, 1.0f, 1.0f);
        }
    }
}

